/*

  TODO : alte Spalten und Funktionen entfernen

  05.04.2017   v12.07.00.00   ref20352   -> noch nicht aus DB, da in alten Prodats noch in der Synchronisation enthalten (USyncro)
     ALTER TABLE dokutypes DROP COLUMN dt_stamp; !
     ALTER TABLE recnocommentkategorie DROP COLUMN rck_stamp;

  06.03.2018                             -> VIEW kann weg, wenn keine "alten" Prodats 12.0.x.x bis 12.7.x.x mehr existieren
     DROP VIEW systemsqlstatement_current;

*/

CREATE OR REPLACE FUNCTION TSystem.License__Checksum__Get(str VARCHAR) RETURNS INTEGER AS $$
    DECLARE
      res INTEGER;
      n INTEGER;
    BEGIN
      str := md5(str);
      res := 0;
      FOR n IN 0..15 LOOP
        res := res # ('x' || lpad(substr(str,  n * 2 + 1, 2), 8, '0'))::bit(32)::int;
      END LOOP;
      RETURN res;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TSystem.GetChecksum(str VARCHAR) RETURNS INTEGER AS $$
BEGIN
  RETURN TSystem.License__Checksum__Get(str);
END $$ LANGUAGE plpgsql;

--Mandant von Datenbankname erhalten
CREATE OR REPLACE FUNCTION TSystem.GetMandant(name VARCHAR DEFAULT current_database()) RETURNS VARCHAR AS $$
    DECLARE
      res VARCHAR;
    BEGIN
      --'LOLL-MT'              -> 'LOLL-MT'
      --'LOLL-MT-BKP-20170828' -> 'LOLL-MT'
      --'LOLL-LIVE-TECHPLAN'   -> 'LOLL'
      --'PRODAT-DEMO'          -> 'PRODAT'

      SELECT (regexp_matches(name, E'(\\mLOLL-MT\\M|\\w+)(?:-(.*))?'))[1] INTO res;
      RETURN COALESCE(res, '');
    END $$ LANGUAGE plpgsql;

--Packt Lizenzenanzahl von Lizenzschlüssel aus
CREATE OR REPLACE FUNCTION TSystem.License__Count__Get() RETURNS INTEGER AS $$
    DECLARE
      ku INTEGER;
      hi INTEGER;
      lo INTEGER;
      db INTEGER;
      fl INTEGER;
      buf INTEGER[12];
      Key VARCHAR;
    BEGIN
      SELECT TSystem.Settings__Get('LicenseKey') INTO Key;

      IF (length(Key) <> 27) OR (substr(Key, 7, 1) <> '-') OR (substr(Key, 14, 1) <> '-') OR (substr(Key, 21, 1) <> '-') THEN
        --RAISE EXCEPTION 'Fehler: Lizenzschlüssel ist falsch';
        RETURN 0;
      END IF;
      Key = translate(Key, '-', '');

      FOR i IN 0..11 LOOP
        buf[i] := ('x' || lpad(substr(Key,  i * 2 + 1, 2), 8, '0'))::bit(32)::int;
      END LOOP;

      --Index-Konstanten
      ku = 4; lo = 5; hi = 6; db = 7; fl = 11;

      FOR i IN 0..3 LOOP
        buf[ku] = buf[ku] # buf[i];
        buf[lo] = buf[lo] # buf[i];
        buf[fl] = buf[fl] # buf[i];
        IF i <> 3 THEN
          buf[hi] = buf[hi] # buf[i + 8];
          buf[db] = buf[db] # buf[i + 8];
          buf[fl] = buf[fl] # buf[i + 8];
        END IF;
      END LOOP;

      buf[fl] = buf[fl] # buf[ku] # buf[lo] # buf[hi] # buf[db];
      buf[hi] = buf[hi] # 165;
      buf[lo] = buf[lo] # 90;

      IF (TSystem.License__Checksum__Get(TSystem.Settings__Get('KUNDE')) <> buf[ku]) OR   --Kunde ist falsch oder
         (TSystem.License__Checksum__Get(TSystem.GetMandant()) <> buf[db]) THEN --Datenbank ist falsch
        --RAISE NOTICE 'kunde: %, datenbank: %', UPPER(lpad(to_hex(buf[ku]), 2, '0')), UPPER(lpad(to_hex(buf[db]), 2, '0'));
        RETURN 0;
      END IF;

      IF buf[fl] <> 0 THEN
        RETURN 0; --Checkflag stimmt nicht
      END IF;
      RETURN buf[lo] + buf[hi] * 256;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TSystem.LicenseCount() RETURNS INTEGER AS $$
BEGIN
  RETURN TSystem.License__Count__Get();
END $$ LANGUAGE plpgsql;



--Prüft ob Verbindungsanzahl Lizenzanzahl überschrittet
DROP FUNCTION IF EXISTS tsystem.license__count__check();
CREATE OR REPLACE FUNCTION TSystem.License__Count__Check(
    OUT result boolean,
    OUT error_short varchar,
    OUT error varchar,
    OUT result_LizenzenAnzahl integer,
    OUT result_LizenzenAnzahl_used integer,
    OUT result_connections_bde_025 integer,
    OUT result_LizenzenAnzahl_used_BDE integer,
    OUT result_LizenzenAnzahl_used_USER integer
    )
    RETURNS record
    AS $$
    DECLARE
      LizenzenAnzahl integer;
      VerbindungsAnzahl integer;
      VerbindungsAnzahlBDE numeric;
      Verbindungen_full varchar;
      Verbindungen_short varchar;
      err_str varchar;
      usernames_exclude varchar[];
      usernames_025 varchar[];
      app_name varchar;
      rec record;
    BEGIN

      DROP TABLE IF EXISTS metadaten_show_f2;
      CREATE TEMP TABLE metadaten_show_f2(
        md_name     varchar,    --Kurzname
        md_fullname varchar,    --Name, Vorname
        md_client_addr varchar, --IP Adresse
        excluded    boolean,
        is_025      boolean
      );

      SELECT TSystem.License__Count__Get() INTO LizenzenAnzahl;

      IF (LizenzenAnzahl <= 0) THEN
         Result := FALSE;
         error  := lang_text(26318); --Kein gültiger Lizenzschlüssel vorhanden
         RETURN;
      END IF;

      --Vordefinition
      app_name          := 'PRODAT ERP';
      usernames_025     := ARRAY[ 'FERTIGUNG','PLANTAFEL' -- MZO/Fetzel Viewer für Fertigung nur Stempeln
                                 ,'LAGAS'
                                 ,'MONTAGE'
                                 -- TODO umbauen auf hidden Setting, wenn viele individuelle Erweiterungen
                                 ];
      usernames_exclude := ARRAY[ 'APPS', 'root', 'syncro', 'postgre', 'postgres', 'CIMPCS', '987'
                                  -- TODO umbauen auf hidden Setting, wenn viele individuelle Erweiterungen
                                 ,'ABK-SCAN', 'X', 'SCAN-WA', 'ETIKETT-WA', 'BS', 'DISPLAY' -- Kreyebger Special Entfernt: 'BDE-QS', 'BDE-MONTAGE', 'BDE-HU' => LIKE "BDE% siehe unten "is_bde"
                                 ];

      VerbindungsAnzahlBDE := 0;
      VerbindungsAnzahl    := 0;
      Verbindungen_short   := '';
      Verbindungen_full    := '';

      FOR rec IN SELECT DISTINCT
                        usename, datname, client_addr, nameAufloesen(usename::varchar, false) AS full_name,
                        usename LIKE 'BDE%' AS is_bde,
                        usename = ANY(usernames_025) AS is_025,
                        usename = ANY(usernames_exclude) AS is_excluded_user
                   FROM pg_stat_activity
                  WHERE
                        application_name = app_name
                        AND datname = current_database() --Anzahl pro DB
                        --AND TSystem.GetMandant(datname::varchar) = TSystem.GetMandant() --Anzahl pro Mandant
                  GROUP BY
                        usename, datname, client_addr, nameAufloesen(current_user::varchar, false)
      LOOP
          --Verbindungen BDE werden mit 1/4 gezählt.
          IF rec.is_bde OR rec.is_025 THEN
             VerbindungsAnzahlBDE := VerbindungsAnzahlBDE + 1;
          END IF;

          --"normale" Nutzer
          IF NOT rec.is_excluded_user THEN
             VerbindungsAnzahl := VerbindungsAnzahl + 1;
          END IF;

          --für Anzeige (nur Kutznamen kommasepariert)
          IF Verbindungen_short <> '' THEN
             Verbindungen_short := Verbindungen_short || ',';
          END IF;
          Verbindungen_short := Verbindungen_short || rec.usename;

          --für Anzeige (Kurznamen mit IP-Adressen)
          IF Verbindungen_full <> '' THEN
             Verbindungen_full := Verbindungen_full || E'\n';
          END IF;
          Verbindungen_full := Verbindungen_full || rec.usename || ' (' || rec.datname::varchar || ', ' || rec.client_addr::varchar || ')';

          --RAISE NOTICE 'VerbindungsAnzahlBDE: %', VerbindungsAnzahlBDE;
          --RAISE NOTICE 'VerbindungsAnzahl: %', VerbindungsAnzahl;
          --RAISE NOTICE 'Verbindungen_short: %', Verbindungen_short;
          --RAISE NOTICE 'Verbindungen_full: %', Verbindungen_full;

          --Eintrag für SHOW-F2 temp Tabelle
          INSERT INTO metadaten_show_f2 VALUES(rec.usename, rec.full_name, rec.client_addr, rec.is_excluded_user, rec.is_bde OR rec.is_025 );
      END LOOP;

      result_LizenzenAnzahl           := LizenzenAnzahl;
      result_LizenzenAnzahl_used      := VerbindungsAnzahl;
      result_connections_bde_025      := VerbindungsAnzahlBDE;
      result_LizenzenAnzahl_used_BDE  := trunc(VerbindungsAnzahlBDE / 4); -- BDE station abrunden im Kommafall
      result_LizenzenAnzahl_used_USER := VerbindungsAnzahl - VerbindungsAnzahlBDE + result_LizenzenAnzahl_used_BDE;

      IF LizenzenAnzahl < result_LizenzenAnzahl_used_USER THEN
         Result := FALSE;
         err_str     := concat(lang_text(26246), ' (', result_LizenzenAnzahl_used_USER, ' ', lang_text(981), ' ', LizenzenAnzahl, E'):\n'); --Verbindungsanzahl ist überschritten : x von y
         error       := concat(err_str, Verbindungen_full);   -- Verbindungsanzahl ist überschritten : x von y (Liste mit IP-Adressen)
         error_short := concat(err_str, Verbindungen_short);  -- Verbindungsanzahl ist überschritten : x von y (nur Benutzernamen kommasepariert)
         RETURN;
      ELSE
         Result := TRUE;
         error  := 'OK';
      END IF;
    END $$ LANGUAGE plpgsql VOLATILE;
--

-- Baut die 'metadaten_show_f2' Tabelle neu und liefert alle Datensätze zurück
DROP FUNCTION IF EXISTS  TSystem.metadaten_show_f2__get();
CREATE OR REPLACE FUNCTION TSystem.metadaten_show_f2__get(
    OUT md_name        varchar,
    OUT md_fullname    varchar,
    OUT md_client_addr varchar,
    OUT excluded       boolean,
    OUT is_025         boolean,
    OUT count_value    numeric
    )
    RETURNS SETOF RECORD AS $$
    DECLARE
      rec record;
    BEGIN
      PERFORM TSystem.License__Count__Check(); --dort wird die Tabelle 'metadaten_show_f2' neu gebaut

      FOR rec IN SELECT * FROM metadaten_show_f2 LOOP
        md_name         := rec.md_name;
        md_fullname     := rec.md_fullname;
        md_client_addr  := rec.md_client_addr;
        excluded        := rec.excluded;
        is_025          := rec.is_025;
        count_value     := IfThen(excluded, 0, IfThen(is_025, 0.25, 1));
        RETURN NEXT;
      END LOOP;

      RETURN;
    END $$ LANGUAGE plpgsql VOLATILE;

--
CREATE OR REPLACE FUNCTION TSystem.CheckLicenseCount(OUT result boolean, OUT error_short varchar, OUT error varchar) RETURNS record AS $$
BEGIN
  SELECT * INTO result, error_short, error
  FROM tsystem.License__Count__Check();
  RESULT := TRUE;
  RETURN;
END $$ LANGUAGE plpgsql VOLATILE;

--
CREATE OR REPLACE FUNCTION isInteger(varchar) RETURNS boolean AS $$
    DECLARE x integer;
    BEGIN
      x = $1::integer;
        RETURN TRUE;
      EXCEPTION WHEN others THEN
        RETURN FALSE;
    END;
    $$ STRICT LANGUAGE plpgsql IMMUTABLE;
--
CREATE OR REPLACE FUNCTION isBoolean(varchar) RETURNS boolean AS $$
    DECLARE x boolean;
    BEGIN
        x = $1::boolean;
        RETURN TRUE;
    EXCEPTION WHEN others THEN
        RETURN FALSE;
    END;
    $$ STRICT LANGUAGE plpgsql IMMUTABLE;
--
CREATE OR REPLACE FUNCTION isDate(varchar) RETURNS boolean AS $$
    DECLARE x date;
    BEGIN
      x = $1::date;
        RETURN TRUE;
      EXCEPTION WHEN others THEN
        RETURN FALSE;
    END;
    $$ STRICT LANGUAGE plpgsql IMMUTABLE;
--
CREATE OR REPLACE FUNCTION isTimeStamp(varchar) RETURNS boolean AS $$
    DECLARE x timestamp;
    BEGIN
      x = $1::timestamp;
        RETURN TRUE;
      EXCEPTION WHEN others THEN
        RETURN FALSE;
    END;
    $$ STRICT LANGUAGE plpgsql IMMUTABLE;


CREATE OR REPLACE FUNCTION TSystem.views__treporting__drop() RETURNS VOID AS $$
    BEGIN
     DROP VIEW IF EXISTS treporting.allg_beleg_positionen;
     DROP VIEW IF EXISTS treporting.allg_beleg_kopfdaten;
     DROP VIEW IF EXISTS treporting.allg_pos_abzuschlaege_pos;
     DROP VIEW IF EXISTS treporting.allg_abzuschlaege_beleg;
     DROP VIEW IF EXISTS treporting.allg_steuerartenbetrag;

     DROP VIEW IF EXISTS treporting.auftg_beleg_positionennachtrag;
     DROP VIEW IF EXISTS treporting.auftg_belegnachtrag_kopfdaten;
     DROP VIEW IF EXISTS treporting.auftg_beleg_positionen;
     DROP VIEW IF EXISTS treporting.auftg_beleg_kopfdaten;
     DROP VIEW IF EXISTS treporting.auftg_abzuschlaege_pos;
     DROP VIEW IF EXISTS treporting.auftg_abzuschlaege_beleg;
     DROP VIEW IF EXISTS treporting.auftg_steuerartenbetrag;
     --
     DROP VIEW IF EXISTS treporting.anfrage_anfart_positionen;
     DROP VIEW IF EXISTS treporting.anfrage_kopfdaten;
     DROP VIEW IF EXISTS treporting.anfrage_pos_abzu_pos;
     DROP VIEW IF EXISTS treporting.anfrage_abzu_kopf;
     DROP VIEW IF EXISTS treporting.anfrage_steuerartenbetrag;
     --
     DROP VIEW IF EXISTS treporting.lieferschein_pos_beleg_positionen;
     DROP VIEW IF EXISTS treporting.lieferschein_beleg_kopfdaten;
     DROP VIEW IF EXISTS treporting.lieferschein_pos_abzuschlaege_pos;
     DROP VIEW IF EXISTS treporting.lieferschein_abzuschlaege_beleg;
     DROP VIEW IF EXISTS treporting.lieferschein_steuerartenbetrag;
     --
     DROP VIEW IF EXISTS treporting.rechnung_pos_beleg_positionen;
     DROP VIEW IF EXISTS treporting.rechnung_beleg_kopfdaten;
     DROP VIEW IF EXISTS treporting.rechnung_pos_abzuschlaege_pos;
     DROP VIEW IF EXISTS treporting.rechnung_abzuschlaege_beleg;
     DROP VIEW IF EXISTS treporting.rechnung_steuerartenbetrag;
     --
     DROP VIEW IF EXISTS treporting.ldsdok_beleg_positionen CASCADE;
     DROP VIEW IF EXISTS treporting.ldsdok_beleg_positionenmahn;
     DROP VIEW IF EXISTS treporting.ldsdok_beleg_kopfdaten CASCADE;
     DROP VIEW IF EXISTS treporting.ldsdok_belegmahn_kopfdaten;
     DROP VIEW IF EXISTS treporting.ldsdok_abzuschlaege_pos;
     DROP VIEW IF EXISTS treporting.ldsdok_abzuschlaege_beleg;
     DROP VIEW IF EXISTS treporting.ldsdok_steuerartenbetrag;
     --
    END $$ LANGUAGE plpgsql;
--

-- Neuerstellung aller Report-Views. Verwendung nach DB-Updates bzw. Dbrid.
CREATE OR REPLACE FUNCTION TSystem.views__treporting__recreate() RETURNS VOID AS $$
    BEGIN
            PERFORM TSystem.views__ReportingAuftg__recreate();
            PERFORM TSystem.views__ReportingAnfrage__recreate();
            PERFORM TSystem.views__ReportingLieferschein__recreate();
            PERFORM TSystem.views__ReportingBelkopf__recreate();
            PERFORM TSystem.views__ReportingLdsdok__recreate();
            PERFORM TSystem.views__ReportingAllgBeleg__recreate();
            RETURN;
    END $$ LANGUAGE plpgsql;
--


--
CREATE OR REPLACE FUNCTION TSystem.views__TWawi__drop() RETURNS VOID AS $$
 BEGIN

   PERFORM TSystem.views__TWawi_Abzu__drop();

   PERFORM TSystem.views__wawi_auftrag__drop();

   PERFORM TSystem.views__wawi_einkauf__drop();

   PERFORM TSystem.views__wawi_Eingangsrechnung__drop();

   PERFORM TSystem.views__wawi_Ausgangsrechnung__drop();

   DROP VIEW IF EXISTS Twawi.lieferschein_posall;
   DROP VIEW IF EXISTS Twawi.lieferschein_posext;
   DROP VIEW IF EXISTS TWawi.lieferschein_pos;

   DROP VIEW IF EXISTS Twawi.lagab_ext;
   DROP VIEW IF EXISTS TWawi.lagab;

   DROP VIEW IF EXISTS TWawi.lagzu_ext;
   DROP VIEW IF EXISTS TWawi.lagzu;

  RETURN;
 END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.views__TWawi__recreate() RETURNS VOID AS $$
  BEGIN

      --Vorraussetzung für folgende Views
      PERFORM TSystem.views__Adressen__recreate();


      PERFORM TSystem.views__Twawi_abzu__recreate();
      PERFORM TSystem.views__Wawi_Auftrag__recreate();
      PERFORM TSystem.views__Wawi_Lagerabgang__recreate();
      PERFORM TSystem.views__Wawi_Lieferschein__recreate();
      PERFORM TSystem.views__Wawi_Ausgangsrechnung__recreate();
      PERFORM TSystem.views__Wawi_Einkauf__recreate();
      PERFORM TSystem.views__Wawi_Einkauf_anfpos__recreate();
      PERFORM TSystem.views__Wawi_Lagerzugang__recreate();
      PERFORM TSystem.views__Wawi_Eingangsrechnung__recreate();

      RETURN;

  END $$ LANGUAGE plpgsql;
--

--CREATE OR REPLACE FUNCTION cocsetprinted(dokument_dms_id VARCHAR, doktype_force VARCHAR) RETURNS VOID AS $$
-- integriert in treporting.setprinted
 -- Gedruckt-Status für Dokumente
 -- http://redmine.prodat-sql.de/issues/4668
 CREATE OR REPLACE FUNCTION treporting.setprinted(dokument_dms_id VARCHAR, doktype_force VARCHAR) RETURNS VOID AS $$
    BEGIN
     PERFORM disablemodified();
     IF doktype_force IN ('lfs', 'lfsbe') OR doktype_force LIKE 'lfslds_%' THEN -- #9896 lfsbe kann Anfang 2019 entfernt werden
       UPDATE belegdokument SET beld_print = true WHERE beld_dokunr = dokument_dms_id AND beld_belegtyp = 'LFS';
     END IF;
     --
     IF doktype_force = 'abk' THEN
        UPDATE abk SET ab_print = true WHERE ab_ix=dokument_dms_id AND NOT ab_print;
     END IF;
     --
     IF doktype_force = 'coc' THEN
       UPDATE coc SET coc_print = true, coc_definitiv = true WHERE coc_beld_dokunr = dokument_dms_id;
     END IF;
     PERFORM enablemodified();
     --
     RETURN;
    END $$ LANGUAGE plpgsql;

--

-- #9190 PHKO Barcode-Typ anhand der Version steuerm
CREATE OR REPLACE FUNCTION treporting.barcode_type() RETURNS INTEGER AS $$
    BEGIN
    /*In Fastreport ist bartype ein INTEGER
    bcCode128 = 5
    bcCode39  = 3
    */

     RETURN CASE WHEN (prodatversion()).versionstring >= '18.04.02' THEN 5 ELSE 3 END;

    END $$ LANGUAGE plpgsql;
--

-- Spaltentypen, Defaultwerte und Foreignkeys für Tabellen und Views
CREATE TABLE tablefieldinfo
 (isView                BOOLEAN DEFAULT false,  -- True für Viewspalten, False für alle Tabellenspalten
  isWritable            BOOLEAN DEFAULT false,  -- Für Tabellen immer True, bei Views nur wenn Update und Insert möglich sind
  schemaname            VARCHAR(40),            -- Schema der Tabelle / View
  tablename             VARCHAR NOT NULL,       -- View oder Tabellenname
  index                 SMALLINT NOT NULL,      -- Feldindex (Position in der Tabellendefinition)
  field                 VARCHAR NOT NULL,       -- Feldname
  type                  VARCHAR,                -- Feldtyp
  length                INTEGER,                -- Feldlänge (Nur für varchar)
  def                   TEXT,                   -- Defaultwert (Fixwert oder "nextval('name_der_id_sequenz'::regclass)"
  foreign_schema        VARCHAR(100),           -- Die Spalte referenziert auf dieses Schema ...
  foreign_table         VARCHAR(100),           -- Die Spalte referenziert auf diese Tabelle ...
  foreign_column        VARCHAR(50),            -- ... und Spalte
  -- System (tables__generate_missing_fields)
  --   kein automatisches dbrid, insert_date, insert_by, modified_by, modified_date und table_delete-Trigger (tables__fieldInfo__fetch)
  PRIMARY KEY("schemaname","tablename", "index", "field", "isview")
 );

 CREATE INDEX tablefieldinfo_tablename ON tablefieldinfo(tablename);
 CREATE INDEX tablefieldinfo_field ON tablefieldinfo(field);


/*Tabelle für Zeiteinheiten*/

CREATE TABLE zeinh
 (z_id                  serial PRIMARY KEY,
  z_einh                integer, /*TEXT NR*/
  z_iso                 varchar(5),
  z_uf                  numeric
 );

/*externe Anwendungen*/

CREATE TABLE beltitel
 (bt_id                 SERIAL PRIMARY KEY,
  bt_bez                VARCHAR(200),
  bt_isrech             BOOL NOT NULL DEFAULT FALSE,
  bt_isang              BOOL NOT NULL DEFAULT FALSE,
  bt_isbes              BOOL NOT NULL DEFAULT FALSE,
  bt_islief             BOOL NOT NULL DEFAULT FALSE,
  bt_isvtr              BOOL NOT NULL DEFAULT FALSE,
  bt_isanfrage          BOOL NOT NULL DEFAULT FALSE -- Anfrage Einkauf
 );

-- Pfad für Dokumente
CREATE TABLE dokuarchiv
 (da_name               VARCHAR(21) NOT NULL PRIMARY KEY,
  da_descr              TEXT,--Zusatzinformation
  da_path               VARCHAR(500) NOT NULL-- Laufwerkpfad
 );


/*Bilder und Dokumente*/

-- [SYNCRO-TABLE] Dokumenttypen
-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Dokumentenmanagement_-_DMS > Tabelle dokutypes : Liste aller Dokumenttypen [v Felder]
--
-- TDokument.isFileLink           pd_dokumentfile IS NOT NULL AND pd_dmsremotefile IS NULL   -- Dokument ist nur extern verlinkt
-- TDokument.isDMSDokument        pd_dokumentfile <> '' and pd_dmsremotefile <> ''           -- Dokument liegt im DMS
-- TDokument.isDMSViewDokument    lower(pd_dmsremotefile) ~ E'\\(.tiff?|.pdf)$'              -- Dokument liegt im DMS und besitzt einen Prodat-Viewer
-- TDokument.isDMSEditDokument    lower(pd_dmsremotefile) ~ E'\\.tiff?$'                     -- Dokument liegt im DMS und besitzt einen Prodat-Viewer/Editor
-- TDokument.isCustomFolder       pd_dokumentfile IS NULL                                    -- ist ein benutzerdefiniertes Verzeichnis in der Objektablage
-- TDokument.isLocked             pdr_blocked_pd_id IS NOT NULL                              --
CREATE TABLE dokutypes
 (--dt_stamp               TIMESTAMP(0) UNIQUE NOT NULL DEFAULT currenttime(),   -- [ALT] entfernt wegen Synchro-Fehler da ZWEI konkurrierende UNIQUE-Felder
  dt_id                    VARCHAR(30) PRIMARY KEY,                              -- [SYNCRO:SyncID] Kurzname des Dokumentyps
  dt_modified              TIMESTAMP(0),                                         -- [SYNCRO:Modified]
  dt_descr                 VARCHAR(100),
  dt_abteilung             VARCHAR(50),                                          -- für Gruppierung in F2-Fenstern
  dt_linkto                VARCHAR(30),                                          -- automatische Verlinkung mit Tabelle (wenn pd_tablename leer) < abhängig vom Dokumenttyp
                                                                                    -- pd_tablename := dt_linkto wenn pd_tablename = NULL or 'scaneingang' (siehe picndoku__b_iud)
                                                                                    -- Dokumenttyp-F2 in Objektablage: verlinkte DokuTypes zum aktuellen Modul/Tabelle werden hervorgehoben (doktyp_fav/cimyellow)
  dt_dokident              VARCHAR(30),                                          -- KeyField für Tabelle (Query._SqlTable bzw. pd_tablename), um beim Drucken pd_dokident zu füllen (TDokument.GetDokumentIdentFieldName, TReport.ExportDokument_SetPrintStat und TReport.CheckDMSLocks)
  dt_linkforms             VARCHAR(50),                                          -- Zuordnung von Modulname zu Dokutyp > Vorgabe für r_dokutype, beim Neuanlegen von Reports zu diesem Modul
   dt_treeparentid        INTEGER,                                               -- kann weg
  dt_txtnr                 INTEGER,                                              -- Default-Caption (pd_path) wenn in picndoku__b_iud nicht anders gefüllt
  dt_dbridsql              TEXT,                                                 -- SQL um pd_dbrid anhand pd_dokident und pd_tablenamer zu suchen > siehe picndoku__b_iud: wir holen die dbrid
                                                                                   -- nur wenn pd_dbrid = NULL, '0' oder 'DV' / das SQL endet mit einem impliziten :pd_dokident
  dt_forcekeyword          TEXT,                                                 -- in Dokumenteigenschaften immer angezeigte RecnoKeyWords/Zwangsschlüsselworte, selbst wenn nicht vorhanden (je ein Schlüsselwort pro Zeile)
  dt_parentnodeid          VARCHAR(10),                                          -- dtn_nodeid oder pd_id(CustomFolder)
  dt_sync                  BOOLEAN NOT NULL DEFAULT false,
  dt_relateddokkeyword     VARCHAR(40),                                          -- Kategorie (r_kategorie) für Anzeige von Beziehungsdokumenten in TFileViewerFrameTIFF
  -- SYNCRO START - diese Felder werden nicht synchronisiert -> siehe dokutypes__b_iu und TFormSyncro.BtSyncClick
  dt_config                TEXT,                                                 -- [SYNCRO:NotThisFields] Zusätzliche Konfiguration (INI) : z.B. DefaultPath und ImportMode beim Dokument-Importieren
  dt_auto_revision         BOOLEAN NOT NULL DEFAULT false,                       -- [SYNCRO:NotThisFields] [DMSArchive] Dokumente des gleichen Typs vom selben Tag revisionieren (z.B. beim Drucken und Scannen)
  dt_auto_rev_period       INTEGER,                                              -- [SYNCRO:NotThisFields] [DMSArchive] Dauer in Tagen, wie weit zurück alte Revisionen verlinkt werden
  dt_da_name               VARCHAR(21) REFERENCES dokuarchiv ON UPDATE CASCADE,  -- [SYNCRO:NotThisFields] [DMSArchive] Archiv/Pfad für Datei
  dt_da_name_archive       VARCHAR(21) REFERENCES dokuarchiv ON UPDATE CASCADE,  -- [SYNCRO:NotThisFields] [DMSArchive] Archiv/Pfad für archivierte Datei
  dt_write_once            BOOLEAN NOT NULL DEFAULT false,                       -- [SYNCRO:NotThisFields] [DMSArchive] Dateien/Revisionen dürfen nicht geändert/gelöscht werden
  dt_archive_default       BOOLEAN NOT NULL DEFAULT false,                       -- [SYNCRO:NotThisFields] [DMSArchive] neue Dokumente, bzw. neu zugewiesene Dokumente (dokutype), per default archivieren
  dt_archive_hideold       BOOLEAN NOT NULL DEFAULT false,                       -- [DMSArchive] alte Version verstecken (pd_deletable), wenn neue Revision hochgeladen wird
  dt_autoexportpath        VARCHAR(250),                                         -- [SYNCRO:NotThisFields]
  dt_external_dms_dokutype VARCHAR(100),                                         -- [SYNCRO:NotThisFields] [DMS-SYNC-USER] alternierender Dokumenttyp im externen DMS (z.B. ELO) > siehe TDMS.External_DMS__get_Documents pd_external_doktype
   --dt_workflow          INTEGER                                                -- [ALT] references wsworkflow - definition in CA Kostrech_Controll
  -- SYNCRO ENDE
  dt_display_limit         integer NOT null DEFAULT 35,                          -- limitiert Elemente in der Baumanzeige des DMS
  dt_parentnodeid_default  boolean NOT null DEFAULT false                        -- legt fest, ob ein Dokumenttyp bei der Auswahl bevorzugt wird
 );

-- es kann nur ein default pro dt_parentnodeid geben
CREATE UNIQUE INDEX dokutypes_dt_parentnodeid_if_dt_parentnodeid_default
  ON dokutypes (dt_parentnodeid)
WHERE dt_parentnodeid_default;


--
CREATE OR REPLACE FUNCTION dokutypes__b_iu() RETURNS TRIGGER AS $$
  DECLARE temp RECORD;
  BEGIN
    IF current_user <> 'syncro' THEN
      IF tg_op = 'INSERT' THEN
        new.dt_modified := currenttime();
      END IF;
      IF tg_op = 'UPDATE' THEN
        -- Diese Felder für die Syncro (Synchro-Modified-Date) ignorieren.
        -- z.B. eine Änderung von dt_config aktualisiert das modified_date, da es aber nicht synchronisiert wird, soll es nicht die Synchronisation veranlassen.
        --
        temp := new;
        temp.modified_by        := old.modified_by;
        temp.modified_date      := old.modified_date;
        --
        temp.dt_config          := old.dt_config;
        temp.dt_auto_revision   := old.dt_auto_revision;
        temp.dt_auto_rev_period := old.dt_auto_rev_period;
        temp.dt_da_name         := old.dt_da_name;
        temp.dt_da_name_archive := old.dt_da_name_archive;
        temp.dt_write_once      := old.dt_write_once;
        temp.dt_archive_default := old.dt_archive_default;
        -- temp.dt_archive_hideold := old.dt_archive_hideold;
        temp.dt_autoexportpath  := old.dt_autoexportpath;
        temp.dt_external_dms_dokutype := old.dt_external_dms_dokutype;
        IF old IS DISTINCT FROM temp THEN
          new.dt_modified := currenttime();
        END IF;
      END IF;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER dokutypes__b_iu
    BEFORE INSERT OR UPDATE
    ON dokutypes
    FOR EACH ROW
    EXECUTE PROCEDURE dokutypes__b_iu();
--

--
  CREATE SEQUENCE picndoku__pd_nodeident;
  SELECT setval('picndoku__pd_nodeident', 1000);
 --
--









-- Statusinformationen zur Revision
CREATE TABLE picndoku_revision
  (pdr_revision_id       INTEGER PRIMARY KEY,  -- [DMSArchive] ID/Kennung für gleiche Dokumente (ist die pd_id des jeweils ersten revisionierten Dokuments)
   pdr_blocked_pd_id     INTEGER,
   pdr_blocked_date      TIMESTAMP(0),         -- Sperre für Auscheckkorb
   pdr_blocked_by        VARCHAR(32),
   pdr_checkout_path     VARCHAR(500),
   pdr_checkout_ask_user BOOL                  -- bei nächster Änderung der Datei fragen, ob gespeichert werden soll
   --pdr_valid_from      TIMESTAMP(0),
   --pdr_expires_on      TIMESTAMP(0)
  );


  CREATE INDEX picndoku_revision__blocked ON picndoku_revision (pdr_blocked_date) INCLUDE ( pdr_blocked_pd_id ) WHERE pdr_blocked_date IS NOT null; -- FUNCTION table_delete()

-- Dokument ist gesperrt? (pd_id)
-- Sperre bei aufrufenden Codes eventuell umgehbar, für bestimmte operationen (z.B. Entsperren durch Admin)
--   Delphi: CurrentRights.Admin_User or CurrentRights.DMS_DokuAdmin
--   DB: TSystem.roles__user__group__is_in(current_user::VARCHAR, 'SYS.Administratoren') OR TSystem.roles__user__group__is_in(current_user::VARCHAR, 'Dokumente-Admin')
CREATE OR REPLACE FUNCTION picndoku_is_blocked(pdid INTEGER, IgnoreSelf BOOLEAN DEFAULT false) RETURNS BOOLEAN AS $$
  BEGIN
    RETURN EXISTS(SELECT true
        FROM picndoku
        JOIN picndoku_revision
          ON  pdr_revision_id = pd_revision_id
          AND pdr_blocked_pd_id IS NOT NULL
          AND NOT (IgnoreSelf AND pdr_blocked_by IS NOT DISTINCT FROM current_user)
        WHERE pd_id = pdid);
  END $$ LANGUAGE plpgsql;
--

-- Dokument ist gesperrt? (tablename+dbrid)
CREATE OR REPLACE FUNCTION picndoku_is_blocked(tablename VARCHAR, pddbrid VARCHAR, /*dokident VARCHAR,*/ doktype VARCHAR, IgnoreSelf BOOLEAN DEFAULT false) RETURNS VARCHAR AS $$
  DECLARE DoAutoRevision     BOOLEAN;
          Revision_Duration  INTEGER;
          Revision_DoArchive BOOLEAN;
          Result             VARCHAR;
  BEGIN
    -- Dokumenttyp prüfen, ob Revisionspflicht
    SELECT dt_auto_revision, dt_auto_rev_period, dt_archive_default
        INTO DoAutoRevision, Revision_Duration, Revision_DoArchive
        FROM dokutypes
        WHERE dt_id = doktype;

    -- siehe TDokument.GetLockedInfo
    SELECT
        CASE WHEN pdr_blocked_pd_id IS NOT NULL  -- nur gesperrte Dokumente
            AND NOT (IgnoreSelf AND pdr_blocked_by IS NOT DISTINCT FROM current_user)
        THEN
            CASE WHEN pdr_checkout_path IS NULL
            THEN
                format(lang_text(17918), nameAufloesen(pdr_blocked_by), pdr_blocked_date::VARCHAR, pdr_blocked_pd_id::VARCHAR)  -- locked by %s on %s (%s)
            ELSE
                format(lang_text(17956), nameAufloesen(pdr_blocked_by), pdr_blocked_date::VARCHAR, pdr_blocked_pd_id::VARCHAR)  -- checkedout by %s on %s (%s)
            END
        ELSE
            NULL
        END
        INTO Result
        FROM picndoku
        JOIN picndoku_revision
          ON pdr_revision_id  = pd_revision_id
        ----- FIND REVISION - picndoku_is_blocked/picndoku__b_iu__revision/picndoku__a_iu__revision -----
        -- TODO : WHERE in Function/View auslagern ? (nur ein WHERE für die drei Statements)
        WHERE pd_tablename    = tablename
          AND pd_dbrid        = pddbrid
        --AND COALESCE(pd_dokident,'') = COALESCE(dokident,'')  -- Zu einem Bezugsdatensatz (also pd_dbrid) kann es verschiedene Dokumente mit verschiedenen DokIdents geben (siehe-> EK, Lieferantenanfrage)
                                          -- der DokIdent muss also zusätzlich geprüft werden. TODO: Dokident wieder mit reingeben und Prüfung anpassen.
                                          -- Das machen wir heute nicht, weil wir gerade bei LOLL sitzen und nicht 100 Änderungen am Tag vor der Abreise einspielen werden.
          AND pd_doktype      = doktype
          AND pd_dokumentfile IS NOT NULL
          AND NOT pd_deletable
        --AND pd_id           < new.pd_id
        --AND (pd_revision_id = new.pd_revision_id
        --  OR pd_revision_id     IS NULL
        --  OR new.pd_revision_id IS NULL)
          AND
          (
            ( -- Dokutype soll revisioniert werden
              DoAutoRevision
              AND picndoku.insert_date >= current_date - COALESCE(Revision_Duration, 365*10)
            )
            OR
            ( -- ICH hab das heute schonmal gedruckt, http://redmine.prodat-sql.de/issues/6473
              picndoku.insert_by       = current_user
              AND picndoku.insert_date = current_date
              AND pd_source            = 'print'
            --AND COALESCE(new.insert_by, current_user) = current_user
            )
          )
        ----- FIND REVISION END -----
        LIMIT 1;

    RETURN result;
  END $$ LANGUAGE plpgsql;
--

-- [SYNCRO-TABLE] Document, DokSeal, CustomFolder
-- TDokument.isFileLink usw. siehe TABLE dokutypes
CREATE TABLE picndoku (
  pd_id                         serial PRIMARY KEY,                                    -- [SYNCRO:NotThisFields]
  pd_tablename                  varchar(30) NOT NULL,                                  -- siehe dt_linkto
  pd_dbrid                      varchar(32) NOT NULL,                                  -- siehe dt_linkto
  pd_dokident                   varchar(100),                                          -- DokumentIdent bei mehreren gleichartigen Dokumenten (Bsp: DokumentNummer bei Einkaufsausdruck oder Passwort bei Stempel "Unterschrift")
                                                                                       -- zur Entgegennahme von DruckIdent oder BarcodeIdent um dann per Trigger das Dokument automatisiert richtig zu verarbeiten
  pd_doktype                    varchar(30) REFERENCES dokutypes ON UPDATE CASCADE,
  pd_parentnodeident            varchar(20),                                           -- dtn_nodeid oder pd_id (CustomFolder)
  pd_path                       varchar(500),                                          -- Beschreibung/Name im Baum
  pd_path_user                  varchar(100),                                          -- Beschreibung/Name im Baum (durch User überschreibbarer pd_path) http://redmine.prodat-sql.de/issues/5997
  pd_dokumentfile               varchar(750),                                          -- Dateiname (Original vom Import oder pd_id.ext bei Generierten)
  pd_blob                       LO,                                                    -- DokSeals (Stempel)
  pd_txt                        TEXT,                                                  -- Bemerkung/Hinweistext
  pd_print                      boolean NOT NULL DEFAULT false,                        -- Standarddokument (Vorschau) http://redmine.prodat-sql.de/issues/5499
  pd_source                     varchar(10),                                           -- Dateiursprung - z.B. print (wenn im Reports nichts an SetDMSSource übergeben), scan, file, camera, bi, image (wenn nichts an TFileViewerFrameTIFF übergeben) -> siehe {DMSSource:} im QuellCode
  pd_date                       date DEFAULT current_date,                             -- Aufnahme-/Erstellungs-/Druckdatum
  pd_stamp                      timestamp(0) NOT NULL DEFAULT currenttime(),           -- [SYNCRO:SyncID] ID für Syncro (pd_tablename=dokseals AND insert_by=PRODAT)
  pd_modified                   timestamp(0),                                          -- [SYNCRO:Modified] Änderungsdatum (für Syncro der Stempel)
  pd_archive                    boolean NOT NULL DEFAULT false,                        -- [SYNCRO:NotThisFields] [DMSArchive] Dokument ist archiviert
  pd_revision_id                integer REFERENCES picndoku_revision,                  -- [SYNCRO:NotThisFields] [DMSArchive] ID/Kennung für gleiche Dokumente (ist die pd_id des jeweils ersten revisionierten Dokuments)
  pd_deletable                  boolean NOT NULL DEFAULT false,                        -- Dokument "gelöscht", bzw. durch neue Version ersetzt -> selbes Dokument am selben Tag gedruckt = Vorgängerausdrucke ausblenden (pd_dbrid, pd_dokident, pd_doktype, insert_date, insert_by, current_user, pd_source=print)
  pd_volltext                   text,                                                  -- the text of the dokument for indexing/searching
  pd_volltext_status            jsonb DEFAULT '{"hint": "scheduled"}',                 -- status of the last operation that tried to calculate pd_volltext (->>hint string, ->>status boolean [optional]). success and done => null otherwise subfield hint. nonempty-jsonb with -->status = null triggers calculate pd_volltext

  pd_dmsremotefiledoktype       varchar(50),                                           -- [SYNCRO:NotThisFields] [DMSFile] aktueller Dokumenttyp im Dateisystem und somit Ordner, unter dem die Datei liegt (wie pd_doktype, außer wenn die Datei physisch noch nicht verschoben wurde, wie z.B. bei Änderungen im Trigger)
  pd_dmsremotearchiv            varchar(21) REFERENCES dokuarchiv ON UPDATE CASCADE,   -- [SYNCRO:NotThisFields] [DMSFile] alternativer Verzeichnisname (dt_da_name) für pd_dmsremotefiledoktype
  pd_dmsremotefile              varchar(250),                                          -- [SYNCRO:NotThisFields] [DMSFile] Dateiname im Dateisystem
  pd_dmshash                    varchar,                                               -- [SYNCRO:NotThisFields] [DMSFile] MD5 der Datei
  pd_dms_delayed_upload         boolean NOT NULL DEFAULT false,                        -- [SYNCRO:NotThisFields] [DMSFile] Dokument muß noch hochgeladen werden (z.B. weil der AppServer nicht erreichbar oder das Verzeichnis nicht beschreibbar war)
  pd_dms_delayed_info           text,                                                  -- [SYNCRO:NotThisFields] [DMSFile] JSON mit Info wo dieses Dokument/BLOB zu finden ist.
  pd_dmscomment                 boolean NOT NULL DEFAULT false,                        --                        [DMSFile] Annotations auf Image vorhanden (TIFF)

  pd_external_dms_id            varchar(40) DEFAULT NULL,                              -- [SYNCRO:NotThisFields] [DMS-SYNC-USER] ID im externen DMS ... z.B. ELO (Integer/BigInt/MD5/GUID/...)
  pd_external_dms_updated       timestamp(0) DEFAULT NULL,                             -- [SYNCRO:NotThisFields] [DMS-SYNC-USER] Änderungen an picndoku/recnokeyword vorhanden (wenn pd_external_dms_id=NULL, dann implizit Last-Modified)
  pd_external_dms_changed       varchar(50) DEFAULT NULL,                              -- [SYNCRO:NotThisFields] [DMS-SYNC-USER] Was wurde geändert. (file, annotation, recinfo{picndoku}, keyword)

  -- System (tables__generate_missing_fields)
  dbrid                         varchar(32) NOT NULL DEFAULT nextval('db_id_seq'),
  insert_by                     varchar(32),
  insert_date                   date,
  modified_by                   varchar(32),
  modified_date                 timestamp(0)
 );

CREATE OR REPLACE FUNCTION TDMS.picndoku__pdf__volltext__todo(_p picndoku) RETURNS bool
  AS $$
    SELECT (coalesce(_p.pd_dokumentfile, '') ilike '%.PDF' AND _p.pd_dms_delayed_info IS NULL AND _p.pd_volltext IS null AND _p.pd_volltext_status IS NOT null AND (_p.pd_volltext_status->>'status') IS NULL) IS true
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TDMS.picndoku__tsvector__simple__like(_picndoku picndoku) RETURNS tsvector
  AS $$
    SELECT to_tsvector('simple', _picndoku.pd_volltext);
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TDMS.picndoku__tsvector__f2_input__make_prefix_tsquery(suchbegriff text) RETURNS text
  AS $$
  BEGIN
    RETURN (
      SELECT string_agg(trim(word) || ':*', ' & ')
        FROM unnest(string_to_array(suchbegriff, ' ')) AS word
       WHERE trim(word) <> ''
      );
  END $$ LANGUAGE plpgsql;


-- Indizes
    CREATE INDEX picndokuclass ON picndoku (pd_tablename, pd_dbrid);
    CREATE INDEX picndoku_pd_dbrid ON picndoku (pd_dbrid);
    CREATE INDEX picndoku_pd_dokident ON picndoku (pd_dokident) WHERE pd_dokident IS NOT NULL;
    CREATE INDEX picndoku_pd_doktype ON picndoku (pd_doktype);
    CREATE INDEX picndoku_pd_dbrid_doktype ON picndoku (pd_dbrid, pd_doktype); -- speziell für FUNCTION TDMS.Dokument__pd_id__by__pd_dbrid__pd_doktype (DMS_GetDokID)
    CREATE INDEX picndoku_tablelname_dokident ON picndoku (pd_tablename, pd_dokident);
    CREATE UNIQUE INDEX xtt3943 ON picndoku (pd_tablename, pd_dbrid) WHERE pd_print;
    CREATE INDEX picndoku_pd_dokumentfile ON picndoku (pd_dokumentfile) WHERE pd_dokumentfile IS NOT NULL;
    CREATE INDEX picndoku_pd_revision_id ON picndoku (pd_revision_id) WHERE pd_revision_id IS NOT NULL;
    CREATE INDEX picndoku_pd_dms_delayed_upload ON picndoku (pd_dms_delayed_upload, pd_id) WHERE pd_dms_delayed_upload;

    CREATE INDEX picndoku__pdf__volltext__todo ON picndoku (pd_id) WHERE TDMS.picndoku__pdf__volltext__todo(picndoku);
    CREATE INDEX picndoku__pdf_context_txt__language__like ON picndoku USING gin(TDMS.picndoku__tsvector__simple__like(picndoku)) WHERE pd_volltext IS NOT null;

--
    SELECT setval('picndoku_pd_id_seq', 1000) WHERE nextval('picndoku_pd_id_seq') < 1000;  -- keine Überschneidung zwischen pd_id und dtn_nodeid (curval kann nicht verwendet werden)

-- Trigger
    --
      CREATE OR REPLACE FUNCTION picndoku_modified() RETURNS TRIGGER AS $$
        DECLARE temp RECORD;
        BEGIN
          IF current_user <> 'syncro' THEN
            IF NOT (TSystem.Settings__Get('DMSImport-DisableTriggers-Date') = current_user) THEN
              new.pd_modified := currenttime();
            END IF;
          END IF;

          IF new.pd_external_dms_id IS NOT NULL THEN
            -- Diese Felder für die Syncro (Synchro-Modified-Date) ignorieren.
            -- z.B. eine Änderung von pd_print (StandardDocument) aktualisiert das modified_date, da es aber nicht synchronisiert wird, soll es nicht die Synchronisation veranlassen.
            --
            temp := new;
            temp.modified_by             := old.modified_by;         -- das Dokument selber hat sich nicht verändert (wenn NUR das anders)
            temp.modified_date           := old.modified_date;       --
            --
            temp.pd_parentnodeident      := old.pd_parentnodeident;  -- Änderungen an diesen Dingen sind unwichtig oder interessieren das externe DMS nicht
            temp.pd_print                := old.pd_print;            --
            temp.pd_modified             := old.pd_modified;
            temp.pd_external_dms_updated := old.pd_external_dms_updated;
            temp.pd_external_dms_changed := old.pd_external_dms_changed;
            --
            temp.pd_dmshash              := old.pd_dmshash;          -- recinfo hat sich zwar verändert, aber Dieses muß ja nicht doppelt gespeichert werden
            temp.pd_dmscomment           := old.pd_dmscomment;       --
            IF old IS DISTINCT FROM temp THEN
              new.pd_external_dms_updated := coalesce(new.pd_external_dms_updated, current_timestamp);
              new.pd_external_dms_changed := TSystem.ENUM_SetValue(new.pd_external_dms_changed, 'recinfo');
            END IF;
            IF new.pd_dmshash IS DISTINCT FROM old.pd_dmshash THEN
              new.pd_external_dms_updated := coalesce(new.pd_external_dms_updated, current_timestamp);
              new.pd_external_dms_changed := TSystem.ENUM_SetValue(new.pd_external_dms_changed, 'file');
            END IF;
            IF new.pd_dmscomment IS DISTINCT FROM old.pd_dmscomment THEN
              new.pd_external_dms_updated := coalesce(new.pd_external_dms_updated, current_timestamp);
              new.pd_external_dms_changed := TSystem.ENUM_SetValue(new.pd_external_dms_changed, 'annotation');
            END IF;
          END IF;

          RETURN new;
        END $$ LANGUAGE plpgsql;

      CREATE TRIGGER picndoku_modified
        BEFORE UPDATE
        ON picndoku
        FOR EACH ROW
        WHEN ( TSystem.dms__notify__changes() )  ---(current_user NOT IN ('ELO', 'DMS-SYNC-USER', 'syncro'))
        EXECUTE PROCEDURE picndoku_modified();
    --

    --
    CREATE OR REPLACE FUNCTION picndoku__b30_iud__indexing() RETURNS TRIGGER AS $$
      DECLARE r  RECORD;
              r1 RECORD;
              str VARCHAR;
              str1 VARCHAR;
              dochange BOOL;
              wasprint BOOL;
              v VARCHAR;
      BEGIN --Dokumentenbeschreibungen setzen
        IF tg_op = 'DELETE' THEN
            --RAISE EXCEPTION 'Y%', old.pd_id;
            RETURN old;
        END IF;

        IF new.pd_path_user = '' THEN
            new.pd_path_user := NULL;
        END IF;

        IF new.pd_dokumentfile IS NULL THEN
            RETURN new;  -- CustomFolder nicht behandeln
        END IF;
        --
        new.pd_dokident := trim( new.pd_dokident );
        --    str:=NULL;
        --    --Eigentlich obsolete, da dies alles clientseitig gemacht wird, da sonst der falsche remotdoktype ermittelt werden kann. siehe wiki
        --    --entfernen später (ds - 2013-04-18) > TDokument.pd_parentnodeidentChange
        --    IF new.pd_doktype IS NULL AND new.pd_parentnodeident IS NOT NULL AND new.pd_dokumentfile IS NOT NULL THEN--versuchen anhand des Ordners den Dokumenttyp zu finden
        --        SELECT dt_id INTO v FROM dokutypes WHERE dt_parentnodeid=new.pd_parentnodeident;--dokumenttyp suchen, welcher zu den daten passt (zB Art->Dokumenttypen mit Ident Art)
        --        IF v IS NOT NULL THEN--wenn zB ein Dokument ohne Typ in den Ordner "Zeichnung" geschoben wird, bekommt das Dokument den Typ Zeichnung da der Ordner mit dem Dokumenttyp verknüpft ist
        --            new.pd_doktype:=v;
        --        END IF;
        --    END IF;
        --

        -- Behandeln in welchem Ast im DMS Baum das Dokument liegt
         -- Default Ast aus DMS holen
        str := dt_parentnodeid FROM dokutypes WHERE dt_id = new.pd_doktype;

        -- wenn die neu gesetzt Wurzel im Baum der Standard entspricht, dann entfernen
        IF    str = new.pd_parentnodeident
           OR (
                 -- Wurzel: 0, Ausgegebene: 50, alter Scaneingang: 100
                     new.pd_parentnodeident IN ( 0, 50, 100 )
                 AND str IS NOT NULL
              )
        THEN

            new.pd_parentnodeident := null;
        END IF;

        --Dokument nochmal prüfen, falls doch noch etwas umgesetzt werden muß. zB Bestellung / Bestellung Auswärtsbearbeitung
        IF new.pd_doktype='ldsdok_bestdok' THEN
            --falls dies eine AB für eine Auswärtsbestellung ist
            str := ld_a2_id FROM ldsdok WHERE ld_dokunr=new.pd_dokident AND ld_a2_id IS NOT NULL LIMIT 1;
            IF str IS NOT NULL THEN
                new.pd_doktype:='awd';
            END IF;
        END IF;
        IF (new.pd_doktype='lifsch')OR(new.pd_doktype='quality_we') THEN
            --falls dies eine AB für eine Auswärtsbestellung ist
            str := ld_a2_id FROM wendat JOIN ldsdok ON w_lds_id=ld_id WHERE wendat.dbrid=new.pd_dbrid AND ld_a2_id IS NOT NULL LIMIT 1;
            IF str IS NOT NULL THEN
                IF (new.pd_doktype='lifsch') THEN
                    new.pd_doktype:='lifscha';
                END IF;
                IF (new.pd_doktype='quality_we') THEN
                    new.pd_doktype:='quality_weaw';
                END IF;
            END IF;
        END IF;
        --PD_DOKIDENT aus Daten füllen
        IF new.pd_dokident IS NULL THEN
            IF new.pd_tablename = 'wendat' THEN
                new.pd_dokident:= w_lfsnr FROM wendat WHERE dbrid = new.pd_dbrid;
            END IF;
            IF new.pd_doktype = 'gbstg' THEN
                new.pd_dokident:= beld_dokunr FROM belegdokument WHERE dbrid = new.pd_dbrid;
            END IF;
        END IF;
        --
        str:=NULL;
        IF new.pd_doktype IS NOT NULL AND new.pd_dokumentfile IS NOT NULL THEN
            -- Konfigurationen des Dokumenttyps aus Stammdaten holen (TextNr usw)
            SELECT *
              INTO r1
              FROM dokutypes
             WHERE dt_id = new.pd_doktype;

            -- Der Dokumenttyp hat einen festen Bezug (zB Zeichnung zu Artikel) wurde aber über den Scaneingang zugewiesen und nicht über die Oberfläche, die den Objektbezug Artikel kennt
            IF      r1.dt_linkto IS NOT NULL
               AND (   new.pd_tablename IS NULL
                    OR new.pd_tablename='scaneingang'
                    )
            THEN
                new.pd_tablename := r1.dt_linkto;
            END IF;

            --
            IF current_user = 'root' THEN
                RAISE NOTICE 'linkto:%',r1.dt_linkto;
                RAISE NOTICE 'pd_dokident:%',new.pd_dokident;
            END IF;
            --wir markieren Artikelzeichnung als Standardokument, wenn es noch keines gibt
            IF (new.pd_doktype = 'zeichnung') THEN
                IF NOT EXISTS(SELECT true FROM picndoku WHERE pd_print AND (pd_tablename = new.pd_tablename) AND (pd_dbrid = new.pd_dbrid)) THEN -- Es gibt noch kein Standard-Dokument
                    new.pd_print := TRUE;
                END IF;
            END IF;

            -- wir holen die dbrid: das Dokument wurde nicht konkret zugewiesen. In der Config ist aber ein Standard hinterlegt, wie das Dokument über die pd_dokident zugewiesen werden kann
            -- Dies tritt beim Scannen auf. zB ist im ABK Barcoder der Ident "ab_ix" drin. Dann wird hier über das "dt_dbridsql" diese Id verbunden und die Verknüpfung gesetzt
            IF     (   coalesce(new.pd_dbrid, '0')  = '0'
                    OR coalesce(new.pd_dbrid, 'DV') = 'DV'
                    )
               AND (r1.dt_dbridsql || new.pd_dokident) IS NOT NULL
            THEN
                IF current_user = 'root' THEN
                    RAISE NOTICE '(r1.dt_dbridsql || new.pd_dokident):%', (r1.dt_dbridsql || new.pd_dokident);
                END IF;
                BEGIN
                    str := new.pd_dbrid;

                    -- holt dbrid anhand des SQL, was in DMS-Einstellungen steht.
                    EXECUTE (r1.dt_dbridsql || quote_literal(new.pd_dokident))
                       INTO new.pd_dbrid;

                    new.pd_dbrid := coalesce(new.pd_dbrid, str, '0');
                EXCEPTION
                    WHEN others THEN null;
                END;
            END IF;
            --CAPTION: wir holen die caption: aus dt_txtnr, wenn angegeben zzgl einem Fallabhängigen zusatz
            str := new.pd_path;
            IF (TG_OP = 'INSERT' OR new.pd_path IS NULL)
               AND r1.dt_txtnr IS NOT NULL
            THEN
                str := lang_text(r1.dt_txtnr);
                -- Standard-Caption für pd_tablename
                IF    new.pd_tablename = 'art' THEN
                    str := str || ' ' || coalesce( (SELECT ak_nr FROM art WHERE dbrid = new.pd_dbrid), '');
                ELSE
                    str := str || coalesce(' ' || new.pd_dokident, '');
                END IF;
                --
                str := str || coalesce(' (' || new.pd_path || ')', '');
            END IF;
            --
            IF new.pd_doktype = 'bestblief' then--Auftragsbestätigung, dokident hält die ldsdok dbrid, daher müssen wir die Überschrift etwas anders machen
                SELECT coalesce(ld_abnr, r_descr, ld_auftg) || ' ~ ' || ld_kn
                  INTO str
                  FROM ldsdok
                       -- es gibt den Kreisfall, das die ABNr als Keyword im Dokument angelegt wird. Dann wird das Dokument der Bestellung zugewiesen. In dem Fall würde erst der After Trigger der Keywords die Bestellung aktualisieren mit dem neuen Keyword
                  LEFT JOIN recnokeyword ON r_kategorie = 'lds_abnr' AND r_dbrid = new.dbrid
                 WHERE ldsdok.ld_id = new.pd_dokident
                 ;

            ELSIF (new.pd_doktype IN ('ldsdok_bestdok', 'awd') ) THEN --Auftragsbestätigung, dokident hält die ldsdok dbrid, daher müssen wir die Überschrift etwas anders machen
                SELECT ld_dokunr || ' ~ ' || coalesce(ad_fa1, ad_krz)
                  INTO str
                  FROM ldsdok JOIN adk ON ad_krz = ld_kn
                 WHERE ld_dokunr = new.pd_dokident LIMIT 1;

            ELSIF new.pd_tablename = 'abk' THEN
                IF new.pd_doktype = 'abk' THEN
                   SELECT new.pd_dokident || ':' || ab_ap_nr || ' ~ ' || coalesce(ab_ap_bem, ak_bez)
                     INTO str
                     FROM abk
                     LEFT JOIN art ON ak_nr = ab_ap_nr
                    WHERE abk.dbrid = new.pd_dbrid;

                ELSIF new.pd_doktype LIKE 'picture.ab2%' THEN
                    -- "AG 10 : KS" -> AG aus dt_txtnr
                   SELECT a2_ab_ix || ' ' || lang_text(r1.dt_txtnr) || ' '  || a2_n || ' : ' || a2_ks
                     INTO str
                     FROM ab2
                    WHERE a2_id = new.pd_dokident
                    ;

                END IF;
            ELSIF new.pd_tablename = 'wendat' THEN
                SELECT w_aknr, w_l_krz, w_lds_id, w_lfsnr, w_lgort, w_lgchnr, w_q_nr
                  INTO r
                  FROM wendat
                 WHERE dbrid = new.pd_dbrid;

                IF new.pd_doktype IN ('lifsch', 'lifscha', 'quality_we', 'quality_weaw', 'undefined_we', 'Formone', 'we_messprot', 'quality_cal') THEN
                    IF (r.w_l_krz||' ~ '||r.w_lfsnr) IS NOT NULL THEN
                        str:=(r.w_l_krz||' ~ '||r.w_lfsnr);
                    END IF;
                END IF;

                -- Reklamationsdokument
                IF (new.pd_doktype='quality_we_rekla') AND (r.w_q_nr IS NOT NULL) THEN
                    SELECT ag_lkn, ag_nr, ag_pos, ag_aknr INTO r1 FROM wendat JOIN qab ON q_nr=w_q_nr JOIN lifsch ON l_nr=q_l_nr JOIN auftg ON ag_id=l_ag_id WHERE wendat.dbrid=new.pd_dbrid;
                    str:=r1.ag_lkn||' ~ '||r1.ag_nr||'|'||r1.ag_pos||', '||r1.ag_aknr;
                END IF;

            ELSIF new.pd_doktype = 'werech' THEN --Eingangsrechnung
                SELECT DISTINCT
                       beld_dokunr, beld_krzrechnung
                  INTO r
                  FROM eingrechdokument
                 WHERE dbrid = new.pd_dbrid;

                IF (r.beld_krzrechnung || ' ~ ' || r.beld_dokunr) IS NOT NULL THEN
                    str := (r.beld_krzrechnung || ' ~ ' || r.beld_dokunr);
                END IF;

            ELSIF new.pd_doktype IN ('lfs', 'lfsbe') OR new.pd_doktype LIKE 'lfslds_%' /*lfslds_be*/ THEN -- Lieferschein #9896 lfsbe kann Anfang 2019 entfernt werden
                SELECT DISTINCT
                       beld_dokunr, beld_krzlieferung
                  INTO r
                  FROM belegdokument
                 WHERE dbrid = new.pd_dbrid;
                IF (r.beld_krzlieferung || ' ~ ' || r.beld_dokunr) IS NOT NULL THEN
                    str := (   r.beld_krzlieferung
                            || ' ~ '
                            || r.beld_dokunr
                            || IfThen( new.pd_source <> 'print'
                                      ,' (' || lang_text(904) || ')'
                                      , ''
                                      )
                            );
                END IF;

            ELSIF new.pd_doktype = 'gbstg' THEN --Gelangensbstg
                SELECT DISTINCT
                       beld_dokunr, beld_krzlieferung
                  INTO r
                  FROM belegdokument
                 WHERE dbrid = new.pd_dbrid;
                IF (r.beld_krzlieferung || ' ~ ' || r.beld_dokunr) IS NOT NULL THEN
                    str := (r.beld_krzlieferung || ' ~ ' || r.beld_dokunr || ' GBSTG');
                END IF;

            --Loll: http://redmine.prodat-sql.de/issues/4801
            ELSIF new.pd_doktype = 'sauskft_lief' THEN
                SELECT lang_text(29199) /*'Selbstauskunft*/ ||': '||ad_krz INTO str FROM adk WHERE adk.dbrid = new.pd_dbrid;
            ELSIF new.pd_doktype = 'gehmverbrg_lief' THEN
                SELECT lang_text(29200) /*'Geheimhaltgsvereinbg*/ || ': '|| ad_krz INTO str FROM adk WHERE adk.dbrid = new.pd_dbrid;
            ELSIF new.pd_doktype = 'bdk' THEN
                SELECT ag_lkn || ' ' || coalesce(ag_bda || ' ~ ', '') || ag_nr || '.' || ag_pos INTO str FROM auftg JOIN art ON ak_nr = ag_aknr WHERE ag_id = new.pd_dokident::integer;
            ELSIF new.pd_doktype = 'znrk' THEN
                SELECT ag_aknr INTO str FROM auftg JOIN art ON ak_nr = ag_aknr WHERE ag_id = new.pd_dokident::integer;
            ELSIF new.pd_doktype IN ('auftg_dok', 'aufadok', 'aufedok') then
                SELECT ag_lkn || ' |' || ag_nr || ' ~ ' || new.pd_dokident, ag_astat
                  INTO str, str1
                  FROM auftg
                 WHERE ag_dokunr = new.pd_dokident::integer;
                IF str1 = 'A' THEN
                    new.pd_doktype := 'aufadok';
                END IF;
                IF str1 = 'E' THEN
                    new.pd_doktype := 'aufedok';
                END IF;
            ELSIF new.pd_doktype = 'bestanf' THEN
                str :=    coalesce(lang_text(r1.dt_txtnr) || ' ', '')
                       || coalesce( (SELECT aLief_anf_nr || ' ~ ' || aLief_lkn || ' (' || new.pd_stamp::date::varchar || ')'
                                       FROM anflief
                                      WHERE anflief.dbrid = new.pd_dokident
                                     )
                                   , '(' || new.pd_stamp::varchar || ')'
                                  );
            ELSIF new.pd_doktype = 'anglief' THEN
                str :=       coalesce(aLief_angNr, aLief_anf_nr)
                             || ' ~ '
                             || aLief_lkn
                        FROM anflief
                        JOIN anfrage ON anf_nr = aLief_anf_nr
                         AND anfrage.dbrid = new.pd_dbrid
                       WHERE aLief_id = new.pd_dokident
                       LIMIT 1;
            ELSIF new.pd_doktype = 'airblk' THEN
                str := new.pd_dokident || ' (' || new.pd_stamp::varchar || ')';
            END IF;
        END IF;
        new.pd_path := coalesce(str, new.pd_path, '?');
        --
        IF tg_op = 'INSERT' AND new.pd_dmsremotefiledoktype IS NULL AND new.pd_dokumentfile IS NOT NULL THEN
            -- Kopie aus TDokument.DMSArchiveIdent (Parameter=Default)
            new.pd_dmsremotefiledoktype := new.pd_doktype; -- das wird erstmal der pfad unter welchem das dokument abgelegt ist
            new.pd_dmsremotearchiv      := (SELECT NullIf(IfThen(new.pd_archive, dt_da_name_archive, dt_da_name), '') FROM dokutypes WHERE dt_id = new.pd_dmsremotefiledoktype);
        END IF;
        --
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER picndoku__b30_iud__indexing
        BEFORE INSERT OR UPDATE OR DELETE
        ON picndoku
        FOR EACH ROW
        WHEN ( TSystem.dms__notify__changes() )  ---(current_user NOT IN ('ELO', 'DMS-SYNC-USER', 'syncro'))
        EXECUTE PROCEDURE picndoku__b30_iud__indexing();
    --

    --
    CREATE OR REPLACE FUNCTION picndoku__a91_iud__access_check() RETURNS TRIGGER AS $$
      DECLARE UPD BOOL;
      BEGIN
        IF TG_OP = 'INSERT' OR TG_OP = 'UPDATE' THEN
          IF new.pd_dokumentfile IS NULL THEN
            RETURN new;  -- CustomFolder nicht behandeln
          END IF;
        END IF;
        IF TG_OP = 'DELETE' THEN
          IF old.pd_dokumentfile IS NULL THEN
            RETURN old;  -- CustomFolder nicht behandeln
          END IF;
        END IF;

        -- PreviewChecks: TDokument._BeforePost, TFormDokments.LoadDocument, TFormReport.ExportDokument
        UPD := FALSE;
        IF TG_OP = 'UPDATE' THEN
          UPD := new.pd_doktype IS DISTINCT FROM old.pd_doktype OR new.pd_archive <> old.pd_archive
              OR new.pd_path    IS DISTINCT FROM old.pd_path    OR new.pd_stamp   <> old.pd_stamp;
        END IF;
        IF TG_OP = 'INSERT' OR UPD THEN
          IF (picndoku_adding_forbidden(new.pd_doktype, new.pd_archive)).result THEN
            raise '%', (picndoku_adding_forbidden(new.pd_doktype, new.pd_archive)).text;
          END IF;
        END IF;
        IF TG_OP = 'DELETE' OR UPD THEN
          IF (picndoku_editing_forbidden(old.pd_id)).result THEN
            raise '%', (picndoku_editing_forbidden(old.pd_id)).text;
          END IF;
        END IF;

        IF TG_OP = 'DELETE' THEN
          RETURN old;
        ELSE
          RETURN new;
        END IF;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER picndoku__a91_iud__access_check
        AFTER INSERT OR UPDATE OR DELETE
        ON picndoku
        FOR EACH ROW
        EXECUTE PROCEDURE picndoku__a91_iud__access_check();
    --

    -- Dokument revisionieren (mit alten Dokument-Versionen verknüpfen) -> nur ich selber (verlinke Dokumente im After-Trigger)
    CREATE OR REPLACE FUNCTION picndoku__b50_iu__revision() RETURNS TRIGGER AS $$
      DECLARE DoAutoRevision     BOOLEAN;
              Revision_Duration  INTEGER;
              Revision_DoArchive BOOLEAN;
              Revision_pd_id     INTEGER;
              Revision_rev_id    INTEGER;
      BEGIN
        IF new.pd_dokumentfile IS NULL THEN
            RETURN new;  -- CustomFolder nicht behandeln
        END IF;

        -- Dokumenttyp prüfen, ob Revisionspflicht
        SELECT dt_auto_revision, dt_auto_rev_period, dt_archive_default
          INTO DoAutoRevision, Revision_Duration, Revision_DoArchive
          FROM dokutypes
          WHERE dt_id = new.pd_doktype;

        -- neues Dokument immer archivieren
        IF Revision_DoArchive THEN
            new.pd_archive := true;
        END IF;

        IF new.pd_revision_id IS NULL THEN
            IF TSystem.Settings__Get('DMSImport-DisableTriggers-Revision') = current_user THEN
                -- Dokumente beim Import nicht revisionieren
                -- viele Dokumente auf einmal ->
                RETURN new;
            END IF;

            IF TG_OP = 'UPDATE' THEN
                IF old.pd_revision_id IS NOT NULL THEN
                    -- beim Löschen der RevisionsID nicht gleich wieder neu eintragen
                    RETURN new;
                END IF;
            END IF;

            -- zu verlinkende Revision/Dokumente suchen
            SELECT pd_id, pd_revision_id
              INTO Revision_pd_id, Revision_rev_id
              FROM picndoku
              ----- FIND REVISION - picndoku_is_blocked/picndoku__b_iu__revision/picndoku__a_iu__revision -----
              -- TODO : WHERE in Function/View auslagern ? (nur ein WHERE für die drei Statements)
              WHERE pd_tablename    = new.pd_tablename
                AND pd_dbrid        = new.pd_dbrid
                AND COALESCE(pd_dokident,'') = COALESCE(new.pd_dokident,'') -- Zu einem Bezugsdatensatz (also pd_dbrid) kann es verschiedene Dokumente mit verschiedenen DokIdents geben (siehe-> EK, Lieferantenanfrage)
                AND pd_doktype      = new.pd_doktype
                AND pd_dokumentfile IS NOT NULL
                AND NOT pd_deletable
                AND pd_id           < new.pd_id
                AND (pd_revision_id = new.pd_revision_id
                  OR pd_revision_id     IS NULL
                  OR new.pd_revision_id IS NULL)
                AND
                (
                  ( -- Dokutype soll revisioniert werden
                    DoAutoRevision
                    AND picndoku.insert_date >= current_date - COALESCE(Revision_Duration, 365*10)
                  )
                  OR
                  ( -- ICH hab das heute schonmal gedruckt, http://redmine.prodat-sql.de/issues/6473
                    picndoku.insert_by       = current_user
                    AND picndoku.insert_date = current_date
                    AND pd_source            = 'print'
                    AND COALESCE(new.insert_by, current_user) = current_user
                  )
                )
              ----- FIND REVISION END -----
              ORDER BY pd_revision_id IS NOT NULL DESC, pd_deletable, pd_id DESC
              LIMIT 1;

            -- Revision mit mir verknüpfen und vorher eventuell anlegen
            IF Revision_pd_id IS NOT NULL THEN
                -- wenn noch nicht, dann jetzt Revision erstellen
                IF Revision_rev_id IS NULL THEN
                    --INSERT INTO picndoku_revision (pdr_revision_id)
                    --  VALUE (Revision_pd_id);
                    INSERT INTO picndoku_revision (pdr_revision_id)
                      SELECT Revision_pd_id
                      WHERE NOT exists(SELECT * FROM picndoku_revision WHERE pdr_revision_id = Revision_pd_id);
                    Revision_rev_id := Revision_pd_id;
                END IF;
                new.pd_revision_id := Revision_rev_id;
            END IF;
        END IF;

        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER picndoku__b50_iu__revision
        BEFORE INSERT OR UPDATE
        ON picndoku
        FOR EACH ROW
        WHEN ( TSystem.dms__notify__changes() )  ---(current_user NOT IN ('ELO', 'DMS-SYNC-USER', 'syncro'))
        EXECUTE PROCEDURE picndoku__b50_iu__revision();
    --

    -- Dokument revisionieren (mit alten Dokument-Versionen verknüpfen) -> nur verlinke Dokumente (ich selber im Before-Trigger)
    CREATE OR REPLACE FUNCTION picndoku__a50_iu__revision() RETURNS TRIGGER AS $$
      DECLARE DoAutoRevision    BOOLEAN;
              Revision_Duration INTEGER;
              Revision_DoHide   BOOLEAN;
              ShowHint          BOOLEAN;
      BEGIN
        IF new.pd_dokumentfile IS NULL THEN
            RETURN new;  -- CustomFolder nicht behandeln
        END IF;

        -- Dokument revisionieren (mit alten Dokument-Versionen verknüpfen) -> Änderungen am Dokutyp nur davor
        IF new.pd_revision_id IS NOT NULL THEN
            IF TSystem.Settings__Get('DMSImport-DisableTriggers-Revision') = current_user THEN
                -- Dokumente beim Import nicht revisionieren
                -- viele Dokumente auf einmal ->
                RETURN new;
            END IF;

            -- Dokumenttyp prüfen, ob Revisionspflicht
            SELECT dt_auto_revision, dt_auto_rev_period, dt_archive_hideold
              INTO DoAutoRevision, Revision_Duration, Revision_DoHide
              FROM dokutypes
              WHERE dt_id = new.pd_doktype;
            -- andere/alte dokumente verknüpfen und Sichtbarkeit anpassen (selbes WHERE beim SELECT in picndoku__b_iu_revision und picndoku_is_blocked)
            UPDATE picndoku
              SET pd_revision_id = new.pd_revision_id,
                  pd_deletable   = (pd_deletable  -- war schon versteckt
                    OR (
                      (
                        Revision_DoHide  -- soll durch Doktyp versteck werden
                        OR ( -- wird versteckt, weil ich es heute schonmal gedruckt hatte
                          insert_by       = current_user
                          AND insert_date = current_date
                          AND pd_source   = 'print'
                        )
                      )
                      AND NOT new.pd_deletable)
                    )
              ----- FIND REVISION - picndoku_is_blocked/picndoku__b_iu__revision/picndoku__a_iu__revision -----
              -- TODO : WHERE in Function/View auslagern ? (nur ein WHERE für die drei Statements)
              WHERE pd_tablename    = new.pd_tablename
                AND pd_dbrid        = new.pd_dbrid
                AND COALESCE(pd_dokident,'') = COALESCE(new.pd_dokident,'')  -- Zu einem Bezugsdatensatz (also pd_dbrid) kann es verschiedene Dokumente mit verschiedenen DokIdents geben (siehe-> EK, Lieferantenanfrage)
                AND pd_doktype      = new.pd_doktype
                AND pd_dokumentfile IS NOT NULL
                AND NOT pd_deletable
                AND pd_id           < new.pd_id
                AND (pd_revision_id = new.pd_revision_id
                  OR pd_revision_id     IS NULL
                  OR new.pd_revision_id IS NULL)
                AND
                (
                  ( -- Dokutype soll revisioniert werden
                    DoAutoRevision
                    AND picndoku.insert_date >= current_date - COALESCE(Revision_Duration, 365*10)
                  )
                  OR
                  ( -- ICH hab das heute schonmal gedruckt, http://redmine.prodat-sql.de/issues/6473
                    picndoku.insert_by       = current_user
                    AND picndoku.insert_date = current_date
                    AND pd_source            = 'print'
                    AND COALESCE(new.insert_by, current_user) = current_user
                  )
                )
              ----- FIND REVISION END -----
                -- eigenen Datensatz ausschließen und alle Datensätze, welche nicht verändert werden
                -- Löst sonst mehrfache rekursive UPDATEs bei vorherrigen Dokumenten aus, auch wenn da nichts verändert wird.
                -- TODO : Vergleichswerte in LATERAL-JOIN auslagern und zusammen mit den SET-Zuweisungen an dieser einen Stelle zusammenfassen
                AND pd_id IS DISTINCT FROM new.pd_id
                AND (pd_revision_id IS DISTINCT FROM new.pd_revision_id
                  OR pd_deletable IS DISTINCT FROM (pd_deletable  -- war schon versteckt
                    OR (
                      (
                        Revision_DoHide  -- soll durch Doktyp versteck werden
                        OR ( -- wird versteckt, weil ich es heute schonmal gedruckt hatte
                          insert_by       = current_user
                          AND insert_date = current_date
                          AND pd_source   = 'print'
                          AND COALESCE(new.insert_by, current_user) = current_user
                        )
                      )
                      AND NOT new.pd_deletable))
                );
            IF FOUND THEN
                -- Bestehendes Dokument überschrieben: Es gab bereits eine Dokumentenausgabe unter dieser ID. Um eine Doppelablage zu vermeiden, wird die vorige Ausgabe revisioniert und ausgeblendet.
                PERFORM PRODAT_HINT(lang_text(21245));
            END IF;
        END IF;
            --
        -- alte Revisions-Kopfdaten entfernen / gesperrte Revision verschieben
        IF TG_OP = 'UPDATE' THEN
            IF old.pd_revision_id IS NOT NULL AND old.pd_revision_id IS DISTINCT FROM new.pd_revision_id THEN
                --                -- Sperre auf neue Revision verschieben
                --                IF new.pd_id = pdr_blocked_pd_id FROM picndoku_revision WHERE pdr_revision_id = pd_revision_id THEN

                -- grübel
                --                    UPDATE picndoku_revision self
                --                       SET self.pdr_blocked_pd_id = source.prd
                --                    FROM picndoku_revision source
                --                    WHERE self.
                --                      AND source.

                -- erst ab Postgres 9.5
                --                    UPDATE picndoku_revision
                --                      SET      (pdr_blocked_pd_id, pdr_blocked_date, pdr_blocked_by,
                --                                pdr_checkout_path, pdr_checkout_ask_user)
                --                      = (SELECT pdr_blocked_pd_id, pdr_blocked_date, pdr_blocked_by,
                --                                pdr_checkout_path, pdr_checkout_ask_user
                --                         FROM   picndoku_revision
                --                         WHERE  pdr_revision_id = old.pd_revision_id)
                --                      WHERE     pdr_revision_id = new.pd_revision_id;
                --                    --
                --                    UPDATE picndoku_revision
                --                      SET pdr_blocked_pd_id   = NULL,
                --                        pdr_blocked_date      = NULL,
                --                        pdr_blocked_by        = NULL,
                --                        pdr_checkout_path     = NULL,
                --                        pdr_checkout_ask_user = NULL
                --                      WHERE pdr_revision_id = old.pd_revision_id;
                --                END IF;
                --
                -- alte Revisions-Kopfdaten entfernen
                IF NOT exists(SELECT true FROM picndoku WHERE pd_revision_id = old.pd_revision_id AND pd_id <> new.pd_id) THEN
                    DELETE FROM picndoku_revision WHERE pdr_revision_id = old.pd_revision_id;
                END IF;
            END IF;
        END IF;
        --
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER picndoku__a50_iu__revision
        AFTER INSERT OR UPDATE
        ON picndoku
        FOR EACH ROW
        WHEN ( TSystem.dms__notify__changes() )  ---(current_user NOT IN ('ELO', 'DMS-SYNC-USER', 'syncro'))
        EXECUTE PROCEDURE picndoku__a50_iu__revision();
    --

    -- Dokument revisionieren
    CREATE OR REPLACE FUNCTION picndoku__a50_d__revision() RETURNS TRIGGER AS $$
      BEGIN
        IF old.pd_dokumentfile IS NULL THEN
            RETURN new;  -- CustomFolder nicht behandeln
        END IF;

        -- alte Revisions-Kopfdaten entfernen
        IF old.pd_revision_id IS NOT NULL THEN
            -- Sperre auf Revision bleibt erhalten (in F2s und Assistent wird alternativ gegen die pd_id eines bestehenden Dokuments gejoint)
            --UPDATE picndoku_revision
            --  SET pdr_blocked_pd_id   = NULL,
            --    pdr_blocked_date      = NULL,
            --    pdr_blocked_by        = NULL,
            --    pdr_checkout_path     = NULL,
            --    pdr_checkout_ask_user = NULL
            --  WHERE pdr_revision_id   = old.pd_revision_id
            --    AND pdr_blocked_pd_id = old.pd_id;
            --
            IF NOT exists(SELECT true FROM picndoku WHERE pd_revision_id = old.pd_revision_id AND pd_id <> old.pd_id) THEN
                DELETE FROM picndoku_revision WHERE pdr_revision_id = old.pd_revision_id;
            END IF;
        END IF;
        --
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER picndoku__a50_d__revision
        AFTER DELETE
        ON picndoku
        FOR EACH ROW
        EXECUTE PROCEDURE picndoku__a50_d__revision();
    --

    -- siehe "M Beleg.sql"
      --CREATE TRIGGER picndoku__a60_iud__custombeleg
      --  AFTER INSERT OR UPDATE OR DELETE
      --  ON picndoku
      --  FOR EACH ROW
      --  EXECUTE PROCEDURE picndoku__a_iud__custombeleg();
    --
--

-- Änderungslog der picndoku
-- [trigger] INSERT   pd_tablename pd_dbrid pd_dokident pd_doktype pd_path     Dokument der Revisionierung zugeführt
-- [trigger] REMOVE   pd_tablename pd_dbrid pd_dokident pd_doktype pd_path     Dokument aus der Revisionierung entfernt
-- [trigger] DELETE   pd_tablename pd_dbrid pd_dokident pd_doktype pd_path     Dokument gelöscht
-- [trigger] PARENT   pd_tablename pd_dbrid pd_dokident                        Zuordnung wurde geändert (pd_tablename/pd_dbrid/pd_dokident)
-- [trigger] RENAME   pd_doktype pd_path                                       pd_path geändert
-- [trigger] MOVE     pd_doktype pd_path                                       pd_doktype geändert
-- [client]  COPY     pd_id                                                    Dokument ist eine Kopie von
-- [client]  EDIT     "add page 2", "edit page 2" oder "remove page 2"         Dokumentinhalt geändert
-- [client]  STEMP    "add dss_bez" oder "remove dss_bez"                      Stempel hinzugefügt oder geändert
CREATE TABLE picndoku_log
  (pdg_pd_id     INTEGER,   -- keine REFERENCE auf picndoku, da diese Daten auch nach einem Löschen noch vorhanden bleiben sollen
   pdg_rev_id    INTEGER,   -- keine REFERENCE auf picndoku, da diese Daten auch nach einem Löschen noch vorhanden bleiben sollen
   pdg_type      VARCHAR,   -- Art des LogEintrags (INSERT, EDIT, REMOVE, ...)
   pdg_info      TEXT,      -- Inhalt der Änderung
   insert_time   TIMESTAMP(0) DEFAULT current_timestamp  -- später an alle Tabellen und über table_modified/DBRID befüllen
  );

  CREATE INDEX picndoku_log__pdg_pd_id  ON picndoku_log (pdg_pd_id);  -- DROP INDEX public.picndokuid;
  CREATE INDEX picndoku_log__pdg_rev_id ON picndoku_log (pdg_rev_id); -- DROP INDEX public.picndokurevision;
  CREATE INDEX picndoku_log__deleted    ON picndoku_log (pdg_rev_id) WHERE pdg_type IN ('DELETE', 'REMOVE'); -- DROP INDEX public.picndokudeleted;

  --
  CREATE OR REPLACE FUNCTION picndoku__a90_iud__log() RETURNS TRIGGER AS $$
    DECLARE
      val RECORD;
    BEGIN
      IF TG_OP = 'DELETE' THEN
        val := old;
      ELSE
        val := new;
      END IF;

      -- RevisionsIDs aktualisieren
      IF TG_OP = 'UPDATE' AND old.pd_revision_id IS DISTINCT FROM new.pd_revision_id AND new.pd_revision_id IS NOT NULL THEN
        UPDATE picndoku_log
          SET pdg_rev_id = new.pd_revision_id
          WHERE pdg_pd_id = new.pd_id
            AND pdg_rev_id IS DISTINCT FROM new.pd_revision_id;
      END IF;

      -- Nur loggen, wenn Dokument in einer Revisionierung ist, bzw. das grade aktiviert wird.
      IF (TG_OP <> 'DELETE')  -- Löschungen immer loggen
          AND NOT (TG_OP IN ('UPDATE', 'DELETE') AND (old.pd_archive OR old.pd_revision_id IS NOT NULL))
          AND NOT (TG_OP IN ('INSERT', 'UPDATE') AND (new.pd_archive OR new.pd_revision_id IS NOT NULL)) THEN
        RETURN val;
      END IF;

      IF TG_OP = 'UPDATE' THEN
        --IF NOT new.pd_archive OR new.pd_revision_id IS NULL THEN
        IF (NOT new.pd_archive OR new.pd_revision_id IS NULL) AND NOT (NOT old.pd_archive OR old.pd_revision_id IS NULL) THEN
          INSERT INTO picndoku_log (pdg_pd_id, pdg_rev_id, pdg_type, pdg_info) VALUES (val.pd_id, val.pd_revision_id,
            'REMOVE', array_to_string(ARRAY[val.pd_tablename, val.pd_dbrid, val.pd_dokident, val.pd_doktype, val.pd_dmsremotearchiv, val.pd_path], ' ', '-'));
        END IF;
        IF old.pd_tablename IS DISTINCT FROM new.pd_tablename OR old.pd_dbrid IS DISTINCT FROM new.pd_dbrid OR old.pd_dokident IS DISTINCT FROM new.pd_dokident THEN
          INSERT INTO picndoku_log (pdg_pd_id, pdg_rev_id, pdg_type, pdg_info) VALUES (val.pd_id, val.pd_revision_id,
            'PARENT', array_to_string(ARRAY[val.pd_tablename, val.pd_dbrid, val.pd_dokident], ' ', '-'));
        END IF;
        IF old.pd_path IS DISTINCT FROM new.pd_path THEN
          INSERT INTO picndoku_log (pdg_pd_id, pdg_rev_id, pdg_type, pdg_info) VALUES (val.pd_id, val.pd_revision_id,
            'RENAME', array_to_string(ARRAY[val.pd_doktype, val.pd_dmsremotearchiv, val.pd_path], ' ', '-'));
        END IF;
        IF old.pd_doktype IS DISTINCT FROM new.pd_doktype OR old.pd_dmsremotearchiv IS DISTINCT FROM new.pd_dmsremotearchiv THEN
          INSERT INTO picndoku_log (pdg_pd_id, pdg_rev_id, pdg_type, pdg_info) VALUES (val.pd_id, val.pd_revision_id,
            'MOVE', array_to_string(ARRAY[val.pd_doktype, val.pd_dmsremotearchiv, val.pd_path], ' ', '-'));
        END IF;
      ELSE --IF (TG_OP IN ('INSERT', 'DELETE') THEN
        INSERT INTO picndoku_log (pdg_pd_id, pdg_rev_id, pdg_type, pdg_info) VALUES (val.pd_id, val.pd_revision_id,
          TG_OP, array_to_string(ARRAY[val.pd_tablename, val.pd_dbrid, val.pd_dokident, val.pd_doktype, val.pd_dmsremotearchiv, val.pd_path], ' ', '-'));
      END IF;

      RETURN val;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER picndoku__a90_iud__log
      AFTER INSERT OR UPDATE OR DELETE
      ON picndoku
      FOR EACH ROW
      EXECUTE PROCEDURE picndoku__a90_iud__log();
  --
--

-- [SYNCRO-TABLE] SQL-Scripts zum Ausführen beim Ändern von Stempeln
-- TODO dss_bez = UNIQUE
CREATE TABLE doksealsql
 (dss_id                SERIAL PRIMARY KEY,                                     -- [SYNCRO:NotThisFields]
  dss_stamp             TIMESTAMP(0) NOT NULL DEFAULT currenttime() UNIQUE,     -- [SYNCRO:SyncID] ID für Sync
  dss_bez               VARCHAR(50),                                            -- Name
  dss_dt_id             VARCHAR(30) NOT NULL REFERENCES dokutypes ON UPDATE CASCADE ON DELETE CASCADE,   -- Script hängt am DokumentTyp dt_id (z.B. Stempel "Fehler" bei Rechnung)
  dss_pd_id             INTEGER NOT NULL REFERENCES picndoku ON UPDATE CASCADE ON DELETE CASCADE,        -- [SYNCRO:TranslateToLocal] Bild dieses Stempels (pd_tablename=dokseals)
  dss_deletesql         TEXT,                                                   -- Script für Löschen
  dss_insertsql         TEXT,                                                   -- Script für Einfügen
  dss_txt               TEXT                                                    -- Bemmerkung, was machst das Script eigentlich
  -- System (tables__generate_missing_fields)
  --modified_date       TIMESTAMP(0)                                            -- [SYNCRO:Modified]
 );


--KEYWORD FÜR DMS SYSTEM > normale KeyWordSearch in XX Functions TSystem_Recno
CREATE OR REPLACE FUNCTION CreateRecNoKeyword(tablename VARCHAR, value INTEGER, ddbrid VARCHAR) RETURNS VOID AS $$
    BEGIN
     IF ddbrid IS NOT NULL AND NOT CheckRecNoKeyword(tablename, value, ddbrid) THEN
            INSERT INTO recnokeyword (r_tablename, r_kategorie, r_descr, r_dbrid) VALUES ('picndoku', tablename, value, ddbrid);
     END IF;
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION CreateRecNoKeyword(tablename VARCHAR, value VARCHAR, ddbrid VARCHAR) RETURNS VOID AS $$
    BEGIN
     IF ddbrid IS NOT NULL AND NOT CheckRecNoKeyword(tablename, value, ddbrid) THEN
            INSERT INTO recnokeyword (r_tablename, r_kategorie, r_descr, r_dbrid) VALUES ('picndoku', tablename, value, ddbrid);
     END IF;
     RETURN;
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION CheckRecNoKeyword(tablename VARCHAR, value INTEGER /*DEFAULT NULL*/, ddbrid VARCHAR DEFAULT NULL) RETURNS BOOL AS $$
    BEGIN
      RETURN EXISTS(SELECT true FROM recnokeyword WHERE r_tablename='picndoku' AND r_kategorie=tablename
        AND (value IS NULL OR r_descr=value)
        AND (ddbrid IS NULL OR r_dbrid=ddbrid));
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION CheckRecNoKeyword(tablename VARCHAR, value VARCHAR /*DEFAULT NULL*/, ddbrid VARCHAR DEFAULT NULL) RETURNS BOOL AS $$
    BEGIN
      RETURN EXISTS(SELECT true FROM recnokeyword WHERE r_tablename='picndoku' AND r_kategorie=tablename
        AND (value IS NULL OR r_descr=value)
        AND (ddbrid IS NULL OR r_dbrid=ddbrid));
    END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION DeleteRecNoKeyword(tablename VARCHAR, value VARCHAR, ddbrid VARCHAR DEFAULT NULL) RETURNS VOID AS $$
    BEGIN
      DELETE FROM recnokeyword WHERE r_tablename='picndoku' AND r_kategorie=tablename AND r_descr=value
        AND (r_dbrid=ddbrid OR ddbrid IS NULL);
     RETURN;
    END $$ LANGUAGE plpgsql;


-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Dokumentenmanagemenet_-_DMS
CREATE OR REPLACE FUNCTION picndoku__a30_iud__indexing() RETURNS TRIGGER AS $$
  DECLARE r             record;
          r1            record;
          r2            record;
          str           varchar(100);
          str1          varchar(100);
          _table_schema varchar(100);
          _value        varchar(100);
          _dbrid        varchar(100);
          _descr        varchar(100);
          _rck_column   varchar(100);
          _rck_mapto    varchar(100);
  BEGIN
    IF TG_OP = 'DELETE' THEN
        RETURN old;
    ELSE
        IF new.pd_dokumentfile IS NULL THEN
            RETURN new;  -- CustomFolder nicht behandeln
        END IF;

        -- Standardschlüsselwort zur Tabelle falls definiert!
        SELECT rck_column, rck_mapto
          INTO _rck_column, _rck_mapto
          FROM recnocommentkategorie
         WHERE rck_id = new.pd_tablename;

        IF _rck_column IS NOT NULL THEN

            SELECT string_agg(schemaname, ';') AS tschema, count(*) AS count
              INTO r
              FROM pg_tables
             WHERE tablename = new.pd_tablename
                   -- Systemschema, welches nur Defaults und Codes, aber nie Daten enthält/enthalten darf ausschliessen. dort gibt es mit der vererbung evtl doppelte namen
               AND schemaname NOT IN ('tsystem_wawi', 'z_99_drop', 'x_950_import', 'x_900_export');

            -- table has to be unique
            IF r.count > 1 THEN
               RAISE EXCEPTION 'picndoku__a30_iud__indexing: table "%" is not unique. existing in more than one schema? : "%"'
                               ,new.pd_tablename, r.tschema;
            END IF;

            _table_schema := r.tschema;

            EXECUTE ('SELECT ' || _rck_column || ' FROM ' || concat_ws('.', _table_schema, new.pd_tablename) || ' WHERE dbrid = ' || quote_literal(new.pd_dbrid) ) INTO _value;

            IF _rck_mapto IS NOT NULL THEN -- entweder den allgemeinen Standardschlüssel
                PERFORM CreateRecNoKeyword(_rck_mapto, _value, new.dbrid);
            ELSE -- oder über pd_tablename
                PERFORM CreateRecNoKeyword(new.pd_tablename, _value, new.dbrid);
                --Drucken ins DMS. pd_dokident=Keyword für Tabelle
                BEGIN
                    EXECUTE ('SELECT ' || _rck_column || ' FROM ' || concat_ws('.', _table_schema, new.pd_tablename) || ' WHERE ' || _rck_column || '=' || quote_literal(new.pd_dokident)) INTO _value; --wenn nicht existiert, null und createkeyword fängt ab
                    PERFORM CreateRecNoKeyword(new.pd_tablename, _value, new.dbrid);
                EXCEPTION
                    WHEN others THEN null;
                END;
            END IF;
        END IF;

        --Falls in der letzten Stunde das gleiche Dokument bereits ausgegeben, dann jetzt überschreiben da neue Version
        --DELETE FROM picndoku WHERE pd_dbrid=new.pd_dbrid AND pd_tablename=new.pd_table AND pd_doktype=new.pd_doktype AND COALESCE(pd_dokident,'')=COALESCE(new.pd_dokident,'') AND
        --SELECT currenttime()-CAST('5 hour' AS interval);
        --KeyWordSearch hinzufügen; Verlinkungen hinzufügen
        --wareneingang : scannen
        IF (new.pd_tablename = 'wendat') THEN

            -- daran hängt der Lieferschein initial
            SELECT w_l_krz, w_lfsnr
              INTO r2
              FROM wendat
             WHERE dbrid = new.pd_dbrid;

            -- alle weitere Wareneingänge mit dieser Lieferschein/Adressbezug, die im Nachgang für den gleichen LFS noch dazukamen
            FOR r IN SELECT w_wen, w_aknr, w_l_krz, w_lds_id, w_lfsnr, w_lgort, w_lgchnr, w_q_nr, dbrid
                       FROM wendat
                      WHERE dbrid = new.pd_dbrid
                         OR w_wen IN (SELECT w_wen
                                        FROM wendat w1
                                       WHERE w1.w_lfsnr = r2.w_lfsnr
                                         AND w1.w_l_krz = r2.w_l_krz
                                      )
            LOOP
                IF     new.pd_doktype IN ('quality_weaw',
                                          'quality_we',
                                          'quality_we_rekla',
                                          'Formone',
                                          'we_messprot',
                                          'quality_cal'
                                          )
                   AND r.dbrid <> new.pd_dbrid
                THEN
                    CONTINUE; -- nur die Einträge aus der aktuellen w_wen, ansonsten überspringen.
                END IF;

                --alle Positionen des Lieferscheins durchlaufen
                PERFORM CreateRecNoKeyword('wendat', r.w_wen, new.dbrid);
                PERFORM CreateRecNoKeyword('art', r.w_aknr, new.dbrid);
                PERFORM CreateRecNoKeyword('adk', r.w_l_krz, new.dbrid);
                --PERFORM CreateRecNoKeyword('rechnr', r.beld_dokunr, new.dbrid);
                PERFORM CreateRecNoKeyword('chnr', r.w_lgchnr, new.dbrid);
                PERFORM CreateRecNoKeyword('lifsch', r.w_lfsnr, new.dbrid);

                --ACHTUNG; SIEHE wendat__b_iu, bei mehreren Lagerzugängen auf eine Lieferscheinnummer
                IF r.w_lds_id IS NOT NULL THEN--Einkauf
                    SELECT ld_code, ld_auftg, ld_kn, ld_dokunr, ld_abnr, ldsdoktxt.dbrid INTO r1 FROM ldsdok LEFT OUTER JOIN ldsdoktxt ON ldt_code=ld_code AND ldt_auftg=ld_auftg WHERE ld_id=r.w_lds_id;
                    PERFORM CreateRecNoKeyword('ldsdoktxt', r1.ld_auftg, new.dbrid);
                    PERFORM CreateRecNoKeyword('lds_abnr', r1.ld_abnr, new.dbrid);

                    --Link in Datensatz Bestellung
                    SELECT dbrid INTO _dbrid FROM ldsdoktxt WHERE ldt_code=r1.ld_code AND ldt_auftg=r1.ld_auftg;
                    PERFORM CreatePicnDokuLink(new.pd_id, 'ldsdoktxt', _dbrid);

                    --Lieferschein Nummer zum Einkauf hinzufügen. dazu dokument der bestellung suchen
                    SELECT dbrid INTO _dbrid FROM picndoku WHERE pd_tablename='ldsdoktxt' AND pd_dokident=r1.ld_dokunr AND pd_doktype='ldsdok_bestdok';
                    PERFORM CreateRecNoKeyword('lifsch', r.w_lfsnr, _dbrid);

                    --dem Auftragsbestätigungsdokument die Lieferscheinnummer als Schlüsselwort hinzufügen
                    SELECT picndoku.dbrid INTO _dbrid FROM picndoku JOIN recnokeyword ON r_dbrid=picndoku.dbrid WHERE pd_tablename='ldsdoktxt' AND pd_dbrid=r1.dbrid AND pd_doktype='bestblief' AND r_descr=r1.ld_abnr;
                    PERFORM CreateRecNoKeyword('lifsch', r.w_lfsnr, _dbrid);
                END IF;
            END LOOP;

            --Link für Dokumentenmanagement damit der Bearbeiter das gescannte Dokument im DMS-Modul für die Freigabestruktur sieht
            --dbrid 0 = virtueller Ordner im DMS
            IF     r.w_lgort IN ('ZLQ',
                                 'QAB',
                                 'ZEUGNIS FEHLT','QS'
                                 )
               AND new.pd_doktype IN ('lifsch', 'lifscha',
                                      'quality_we',
                                      'undefined_we',
                                      'Formone',
                                      'we_messprot',
                                      'quality_cal'
                                      )
            THEN --Link QS, nur wenn Lieferschein, nicht wenn Rechnung
                PERFORM CreatePicnDokuLink(new.pd_id, 'qs', '0'); -- siehe kommentierung über IF
            END IF;

            --Auswärtslieferschein und Auswärts-Qualitätsdokument
            IF    (new.pd_doktype = 'lifscha')
               OR (new.pd_doktype = 'quality_weaw')
               OR (new.pd_doktype = 'undefined_we')
            THEN
                --im folgender der JOIN auf ab2 nur, damit bei doppelter Lieferscheinnummer Lieferant auch das richtige gesucht wird
                FOR r1 IN SELECT DISTINCT ldsdokmain.ld_abk AS mabix, a2_ab_ix, ldsfert.ld_auftg, ag_nr, ag_lkn, ldsfert.ld_aknr, wendat.dbrid
                            FROM wendat  JOIN ldsdok ldsap ON w_lds_id=ldsap.ld_id
                                         JOIN ab2 ON a2_id=ldsap.ld_a2_id
                                         JOIN ldsdok ldsfert ON ldsfert.ld_abk=a2_ab_ix
                                    LEFT JOIN ldsdok ldsdokmain ON ldsdokmain.ld_abk=tplanterm.abk_main_abk(a2_ab_ix) -- auch Nacharbeitsaufträge
                                    LEFT JOIN auftg ON ag_id = ldsdokmain.ld_ag_id
                           WHERE wendat.dbrid = new.pd_dbrid
                              OR w_wen IN (SELECT w_wen
                                             FROM wendat w1
                                            WHERE w1.w_lfsnr = r2.w_lfsnr
                                              AND w1.w_l_krz=r2.w_l_krz
                                          )
                LOOP
                    IF     new.pd_doktype = 'quality_weaw'
                       AND r1.dbrid <> new.pd_dbrid
                    THEN --nur beim Lieferschein alle Artikel verschlagworten. Ein AuswärtsQS-Dokument erhält nur den Artikel, an welchen das Dokument gescannt wird, als Schlagwort http://redmine.prodat-sql.de/issues/1898
                        CONTINUE;
                    END IF;

                    PERFORM CreateRecNoKeyword('abk', r1.mabix, new.dbrid);
                    PERFORM CreateRecNoKeyword('abk', r1.a2_ab_ix, new.dbrid);
                    PERFORM CreateRecNoKeyword('art', r1.ld_aknr, new.dbrid);
                    PERFORM CreateRecNoKeyword('ldsdoktxt', r1.ld_auftg, new.dbrid);
                    PERFORM CreateRecNoKeyword('auftgtxt', r1.ag_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('adk', r1.ag_lkn, new.dbrid);
                END LOOP;
            END IF;
            -- Reklamationsdokumente (Scannen: Lieferschein, Qualitätsdokumente, Reklamation)
            IF     new.pd_doktype IN ('quality_we_rekla',
                                       'quality_we',
                                       'lifsch',
                                       'Formone',
                                       'we_messprot',
                                       'quality_cal'
                                       )
               AND r.w_q_nr IS NOT NULL
            THEN
                FOR r1 IN SELECT q_nr, ag_dokunr, ag_nr, ag_bda, ag_aknr, ag_lkn, ag_an_nr, beld_dokunr
                            FROM wendat
                                 JOIN qab              ON q_nr             = w_q_nr
                            LEFT JOIN lifsch           ON l_nr             = q_l_nr
                            LEFT JOIN auftg            ON ag_id            = l_ag_id
                            LEFT JOIN lieferschein_pos ON belp_id          = l_belp_id
                            LEFT JOIN lieferschein     ON belp_dokument_id = beld_id
                           WHERE wendat.dbrid = new.pd_dbrid
                LOOP
                    PERFORM CreateRecNoKeyword('qab', r1.q_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('auftgdokutxt', r1.ag_dokunr, new.dbrid);
                    PERFORM CreateRecNoKeyword('auftgtxt', r1.ag_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('auf_bda', r1.ag_bda, new.dbrid);
                    PERFORM CreateRecNoKeyword('art', r1.ag_aknr, new.dbrid);-- evlt. redundant, s.o.
                    PERFORM CreateRecNoKeyword('adk', r1.ag_lkn, new.dbrid);-- evlt. redundant. s.o.
                    PERFORM CreateRecNoKeyword('anl', r1.ag_an_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('lifsch', r1.beld_dokunr, new.dbrid); -- Lieferschein Warenausgang, vgl. Lieferschein Wareneingang der Reklamation (s.o.)
                END LOOP;
                -- Verlinkung für QAB, Verfügbare Dokumente (rechts)
                PERFORM CreatePicnDokuLink(new.pd_id, 'qab', (SELECT dbrid FROM qab WHERE q_nr = r.w_q_nr));
            END IF;
        END IF;--wendat

        -- Belegdokument Scannen
        IF (new.pd_tablename = 'eingrechdokument') THEN

            -- Über Rechnungspositionen laufen und Schlagwörter aktualisieren
            FOR r IN SELECT DISTINCT beld_dokunr, beld_krzlieferung, beld_krzrechnung, beld_refbeleg, belp_aknr, belp_referenz, belp_ab_ix, belp_projektnummer,
                                     w_wen, w_lfsnr, w_lgchnr, ld_a2_id, ld_auftg, vtp_vtr_nr
                       FROM eingrechdokument
                       LEFT JOIN belegpos    ON belp_dokument_id = beld_id
                       LEFT JOIN wendat      ON belp_w_wen       = w_wen
                       LEFT JOIN ldsdok      ON belp_ld_id       = ld_id
                       LEFT JOIN vertrag_pos ON vtp_id           = ld_vtp_id
                      WHERE eingrechdokument.dbrid = new.pd_dbrid
                        AND belp_belegtyp = 'ERG'
            LOOP --Eingangsrechnung, über alle Positionen laufen ...
                PERFORM CreateRecNoKeyword('rechnr', r.beld_dokunr, new.dbrid);
                PERFORM CreateRecNoKeyword('adk', r.beld_krzlieferung, new.dbrid);
                PERFORM CreateRecNoKeyword('adk', r.beld_krzrechnung, new.dbrid);
                PERFORM CreateRecNoKeyword('rechnr', r.beld_refbeleg, new.dbrid);
                -- belp_referenz?
                PERFORM CreateRecNoKeyword('art', r.belp_aknr, new.dbrid);
                PERFORM CreateRecNoKeyword('abk', r.belp_ab_ix, new.dbrid);
                PERFORM CreateRecNoKeyword('anl', r.belp_projektnummer, new.dbrid);
                PERFORM CreateRecNoKeyword('wendat', r.w_wen, new.dbrid);
                PERFORM CreateRecNoKeyword('lifsch', r.w_lfsnr, new.dbrid);
                PERFORM CreateRecNoKeyword('chnr', r.w_lgchnr, new.dbrid);
                PERFORM CreateRecNoKeyword('ldsdoktxt',r.ld_auftg,new.dbrid);
                PERFORM CreateRecNoKeyword('vertrag', r.vtp_vtr_nr, new.dbrid);
                IF r.ld_a2_id IS NOT NULL THEN
                    PERFORM CreateRecNoKeyword('art', (tabk.abk__fertdata__by__a2_id(r.ld_a2_id)).fertaknr, new.dbrid); -- op_n der ASK am AG evtl. der gleiche wie r1.ld_aknr
                    FOR r1 IN SELECT DISTINCT ldsdok.ld_auftg, ldsdok.ld_abk, ldsdok.ld_aknr, ag_nr, ag_lkn
                              FROM ab2 JOIN ldsdok ON ldsdok.ld_abk=a2_ab_ix
                                       LEFT JOIN ldsdok ldsdokmain ON ldsdokmain.ld_abk=tplanterm.abk_main_abk(a2_ab_ix) -- auch Nacharbeitsaufträge
                                       LEFT JOIN auftg ON ag_id = ldsdokmain.ld_ag_id
                              WHERE a2_id=r.ld_a2_id
                    LOOP
                        PERFORM CreateRecNoKeyword('art', r1.ld_aknr, new.dbrid);
                        PERFORM CreateRecNoKeyword('abk', r1.ld_abk, new.dbrid);
                        PERFORM CreateRecNoKeyword('adk', r1.ag_lkn, new.dbrid);
                        PERFORM CreateRecNoKeyword('ldsdoktxt', r1.ld_auftg, new.dbrid);
                        PERFORM CreateRecNoKeyword('auftgtxt', r1.ag_nr, new.dbrid);
                    END LOOP;
                END IF;
            END LOOP;

            -- Gescannte Eingangsrechnungen mit den Bestelldokumenten dazu verknüpfen
            FOR r1 IN SELECT DISTINCT picndoku.dbrid, beld_dokunr
                      FROM eingrechdokument
                        JOIN belegpos  ON belp_dokument_id=beld_id
                        JOIN ldsdok    ON belp_ld_id = ld_id
                        JOIN ldsdoktxt ON ld_code = ldt_code AND ld_auftg = ldt_auftg
                        JOIN picndoku  ON pd_dbrid = ldsdoktxt.dbrid
                      WHERE eingrechdokument.dbrid=new.pd_dbrid AND belp_belegtyp = 'ERG' AND pd_doktype = 'ldsdok_bestdok'
            LOOP
                PERFORM CreateRecnoKeyword('rechnr', r1.beld_dokunr, r1.dbrid);
            END LOOP;

            -- Gescannte Eingangsrechnungen mit den Lieferschein(e) dazu verknüpfen
            FOR r1 IN SELECT DISTINCT picndoku.dbrid, beld_dokunr
                      FROM eingrechdokument
                        JOIN belegpos ON belp_dokument_id=beld_id
                        JOIN wendat   ON belp_w_wen=w_wen
                        JOIN picndoku ON pd_dbrid = wendat.dbrid
                      WHERE eingrechdokument.dbrid=new.pd_dbrid AND belp_belegtyp = 'ERG' AND pd_doktype = 'lifsch'
            LOOP
                PERFORM CreateRecnoKeyword('rechnr', r1.beld_dokunr, r1.dbrid);
            END LOOP;

            --Link für Dokumentenmanagement damit der Bearbeiter das gescannte Dokument im DMS-Modul für die Freigabestruktur sieht
            --dbrid 0 = virtueller Ordner im DMS
            PERFORM CreatePicnDokuLink(new.pd_id, 'controlling', '0');
        END IF;

        -- Anfragen
        IF (new.pd_tablename = 'anfrage') THEN
            -- Ausdruck der Anfrageliste
            IF (new.pd_doktype = 'bestanf') THEN
                FOR r IN SELECT DISTINCT aart_ak_nr, aLief_lkn, anf_nr, anf_an_nr
                           FROM anfart
                                JOIN anfrage ON anf_nr = aArt_anf_nr
                                JOIN anflief ON aLief_anf_nr = anf_nr
                          WHERE anfrage.dbrid = new.pd_dbrid
                            AND anflief.dbrid = new.pd_dokident
                LOOP
                    PERFORM CreateRecNoKeyword('art', r.aart_ak_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('adk', r.aLief_lkn, new.dbrid);
                    PERFORM CreateRecNoKeyword('anl', r.anf_an_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('anfrage', r.anf_nr, new.dbrid);
                END LOOP;
            END IF;

            -- Angebotsdokumente bzgl. Anfrage einscannen
            IF (new.pd_doktype = 'anglief') THEN
                FOR r IN SELECT DISTINCT aart_ak_nr, aLief_lkn, anf_nr, anf_an_nr, aLief_angNr
                           FROM anfart
                                JOIN anfrage ON anf_nr = aArt_anf_nr
                           LEFT JOIN anflief ON aLief_anf_nr = anf_nr AND aLief_id = new.pd_dokident
                          WHERE anfrage.dbrid = new.pd_dbrid
                LOOP
                    PERFORM CreateRecNoKeyword('art', r.aart_ak_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('adk', r.aLief_lkn, new.dbrid); -- wird nicht verknüpft, wenn keine Angebotsnummer vergeben
                    PERFORM CreateRecNoKeyword('anflief', r.aLief_angNr, new.dbrid);
                    PERFORM CreateRecNoKeyword('anl', r.anf_an_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('anfrage', r.anf_nr, new.dbrid);
                END LOOP;
            END IF;
        END IF;

        -- Einkauf: Bestellung oder Auswärtsvergabe drucken, Auftragsbestätigung des Lieferant erfassen
        IF (new.pd_tablename = 'ldsdoktxt') THEN --Anhängen aus drucken oder Bestellbestätigung
            -- #11068, 16018 Verlinkung automatisch erstellen
            -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Anwendungsfall_Einkauf-BestBLief
            -- Ein Vorhandensein von new.pd_dokident UNTER ldsdoktxt ist grundsätzlich immer eine Positionszuordnung
            SELECT dbrid, ld_auftg, ld_id INTO r FROM ldsdok WHERE ld_id = new.pd_dokident;
            PERFORM CreatePicnDokuLink(new.pd_id, 'ldsdok', r.dbrid::varchar, new.pd_dokident);
            PERFORM CreateRecNoKeyword('ldsdoktxt', r.ld_auftg, new.dbrid);

            IF    (new.pd_doktype = 'ldsdok_bestdok')
               OR (new.pd_doktype = 'awd')
               OR (new.pd_doktype = 'ldsdok_bestdok_mahn')
            THEN --Bestellung, Dokument ausdrucken
                FOR r IN SELECT DISTINCT ld_kn, ld_auftg, ld_aknr, ld_a2_id, ld_an_nr, vtp_vtr_nr, ld_q_nr, ld_dokunr
                           FROM ldsdok
                           LEFT JOIN vertrag_pos ON vtp_id = ld_vtp_id
                          WHERE new.pd_dokident = ld_dokunr
                LOOP -- muss ohne ldsdoktxt.dbrid = new.pd_dbrid sein, sonst werden andere, auf diesem Dokument zusammengeführte Bestellungen nicht erfasst
                    PERFORM CreateRecNoKeyword('art', r.ld_aknr, new.dbrid);
                    PERFORM CreateRecNoKeyword('adk', r.ld_kn, new.dbrid);
                    PERFORM CreateRecNoKeyword('ldsdoktxt', r.ld_auftg, new.dbrid);
                    PERFORM CreateRecNoKeyword('ldsdokdokutxt', r.ld_dokunr, new.dbrid);
                    PERFORM CreateRecNoKeyword('anl', r.ld_an_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('vertrag', r.vtp_vtr_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('qab',r.ld_q_nr,new.dbrid);          --Nur bei Reklamationsbestellung

                    IF r.ld_a2_id IS NOT NULL THEN
                       -- op_n der ASK am AG evtl. der gleiche wie r1.ld_aknr
                        PERFORM CreateRecNoKeyword('art', (tabk.abk__fertdata__by__a2_id(r.ld_a2_id)).fertaknr, new.dbrid);

                        FOR r1 IN SELECT DISTINCT ldsdok.ld_auftg, a2_ab_ix, ldsdok.ld_aknr, ag_nr, ag_lkn
                                    FROM ab2
                                         -- Verknüpfung zu Produktionsauftrag - oder bei Auswärtsbearbeitungen auf Reklamationen (dann ist die Auswärtsbestellung )
                                         JOIN ldsdok ON ldsdok.ld_a2_id = a2_id
                                    LEFT JOIN ldsdok ldsdokmain ON ldsdokmain.ld_abk = tplanterm.abk_main_abk(a2_ab_ix) -- auch Nacharbeitsaufträge
                                    LEFT JOIN auftg ON ag_id = ldsdokmain.ld_ag_id
                                   WHERE a2_id = r.ld_a2_id
                        LOOP
                            PERFORM CreateRecNoKeyword('art', r1.ld_aknr, new.dbrid);
                            PERFORM CreateRecNoKeyword('abk', r1.a2_ab_ix, new.dbrid);
                            PERFORM CreateRecNoKeyword('adk', r1.ag_lkn, new.dbrid);
                            PERFORM CreateRecNoKeyword('ldsdoktxt', r1.ld_auftg, new.dbrid);
                            PERFORM CreateRecNoKeyword('auftgtxt', r1.ag_nr, new.dbrid);
                        END LOOP;
                    END IF;
                END LOOP; --alle Artikel
            END IF;
            --
            -- Auftragsbestätigung des Lieferant erfassen
            IF new.pd_doktype IN (  'bestblief',
                                    'q_messprot' )
            THEN
                --
                SELECT r_descr INTO _descr
                  FROM recnokeyword
                 WHERE r_dbrid = new.dbrid
                   AND r_kategorie = 'lds_abnr'
                 ORDER BY r_id
                  DESC LIMIT 1; --siehe unten: Eintragen ABNr. Bei mehreren Dokumenten nur das aktuelleste nehmen.
                --
                FOR r IN SELECT DISTINCT dbrid, ld_id, ld_kn, ld_auftg, ld_aknr, ld_abnr, ld_dokunr, ld_an_nr, ld_a2_id, ld_q_nr
                           FROM ldsdok
                          WHERE ld_id = new.pd_dokident::integer
                                -- wenn 2 unterschiedliche Bestellungen auf einem Dokument sind (zB bei Auswärts). Wir suchen für die aktuelle id das Dokument und innerhalb vom Dokument die gleiche ABNr
                                   -- eigentlich etwas unglücklich, da das dokument über die ldsdoktxt dennoch nur einer position "hauptsächlich" zugewiesen ist. nur über die verlinkung kommt es dann zur anderen position
                                   -- theoretisch könnte das dokument besser der ldsdokdokutxt zugewiesen sein, da es ohne dokument prinzpiell keine Bestellung und keine Bestellbestätigung gibt (außer wieder bei email bestellungen), daher ....
                             OR ld_id IN (SELECT l1.ld_id
                                            FROM ldsdok l1, ldsdok l2
                                           WHERE Equals(l1.ld_dokunr, l2.ld_dokunr) -- Equals: kann da sein - oder nicht (null)
                                             AND l1.ld_abnr = l2.ld_abnr -- muss da sein
                                             AND l2.ld_id = new.pd_dokident::integer
                                         )
                                -- Beachte unten: ähnlich im Verkauf bei Bestelldokument Kunde (bdk)
                                --OR COALESCE(ld_abnr, '') = (SELECT COALESCE(ld2.ld_abnr, '') FROM ldsdok AS ld2 WHERE ld2.dbrid = new.pd_dokident) -- alle Positionen mit gleicher AB-Nr.
                                --DS 2017-07-25 führt dazu, das alle Positionen ohne ABNr auf einmal verschlagwortet werden. Ist auch blödsinn, da durch pd_dokident alle markierten Positionen einzeln angesprungen werden
                LOOP
                    -- auch für 'q_messprot'
                    PERFORM CreateRecNoKeyword( 'art', r.ld_aknr, new.dbrid );

                    IF new.pd_doktype = 'bestblief' THEN

                        PERFORM CreateRecNoKeyword( 'adk', r.ld_kn, new.dbrid );
                        PERFORM CreateRecNoKeyword( 'lds_abnr', r.ld_abnr, new.dbrid );
                        PERFORM CreateRecNoKeyword( 'anl', r.ld_an_nr, new.dbrid );

                        --Nur bei Reklamationsbestellung
                        PERFORM CreateRecNoKeyword( 'qab', r.ld_q_nr, new.dbrid );
                    END IF;

                    IF r.ld_a2_id IS NOT NULL THEN

                        -- op_n der ASK am AG evtl. der gleiche wie r1.ld_aknr
                        PERFORM CreateRecNoKeyword('art', (tabk.abk__fertdata__by__a2_id(r.ld_a2_id)).fertaknr, new.dbrid);

                        FOR r1 IN SELECT DISTINCT ldsdok.ld_auftg, ldsdok.ld_abk, ldsdok.ld_aknr, ag_nr, ag_lkn
                                    FROM ab2
                                         JOIN ldsdok ON ldsdok.ld_abk = a2_ab_ix
                                         LEFT JOIN ldsdok ldsdokmain ON ldsdokmain.ld_abk = tplanterm.abk_main_abk(a2_ab_ix) -- auch Nacharbeitsaufträge
                                         LEFT JOIN auftg ON ag_id = ldsdokmain.ld_ag_id
                                   WHERE a2_id = r.ld_a2_id
                        LOOP
                            -- auch für 'q_messprot'
                            PERFORM CreateRecNoKeyword( 'art', r1.ld_aknr, new.dbrid );

                            IF new.pd_doktype = 'bestblief' THEN
                                PERFORM CreateRecNoKeyword( 'abk', r1.ld_abk, new.dbrid );
                                PERFORM CreateRecNoKeyword( 'adk', r1.ag_lkn, new.dbrid );
                                PERFORM CreateRecNoKeyword( 'ldsdoktxt', r1.ld_auftg, new.dbrid );
                                PERFORM CreateRecNoKeyword( 'auftgtxt', r1.ag_nr, new.dbrid );
                            END IF;

                        END LOOP;
                    END IF;

                    -- die AB-Nr Lieferant zurückschreiben: > FUNCTION recnokeyword__a_iu__dmskeyword
                    --  Anwendungsfall: Dokument Scannen, verschlagworten und erst danach zum Datensatz zuweisen. Damit greift der Trigger am Schlagwort nicht
                    PERFORM teinkauf.ldsdok__ld_abnr__from__dmskeywords__update
                                        (r.ld_id,
                                         _descr,
                                         new.pd_date
                                        );

                END LOOP; --alle Artikel
            END IF;
        END IF;

        -- OPL/AVOR
        IF new.pd_tablename='opl' THEN
            SELECT op_n INTO r FROM opl WHERE opl.dbrid=new.pd_dbrid;
            PERFORM CreateRecNoKeyword('art', r.op_n, new.dbrid);
        END IF;

        -- ABK
        IF new.pd_tablename='abk' THEN
            FOR r IN SELECT DISTINCT ab_ix, mabix, ldsdok.ld_aknr, ak_nr AS ap_ak_nr, an_ak_nr, COALESCE(an_nr, ldsdok.ld_an_nr, ldsdokmain.ld_an_nr) AS an_nr, ldsdok.ld_auftg, ag_nr, ag_lkn, q_nr
                       FROM abk
                       LEFT JOIN ldsdok ON ldsdok.ld_abk = ab_ix
                       LEFT JOIN LATERAL tplanterm.abk_main_abk(ab_ix) AS mabix ON true
                       LEFT JOIN art ON ak_nr = nullif(ab_ap_nr, '') -- Artikel des Arbeitspaketes
                       LEFT JOIN anl ON an_ab_ix = ab_ix
                       LEFT JOIN ldsdok AS ldsdokmain ON ldsdokmain.ld_abk = mabix -- auch Nacharbeitsaufträge
                       LEFT JOIN auftg ON ag_id = ldsdokmain.ld_ag_id
                       LEFT JOIN qab ON q_nr = ab_keyvalue AND qab.dbrid = ab_dbrid AND q_ak_nr = ab_ap_nr
                      WHERE abk.dbrid = new.pd_dbrid
            LOOP
                PERFORM CreateRecNoKeyword('abk', r.ab_ix, new.dbrid);      -- diese ABK
                PERFORM CreateRecNoKeyword('abk', r.mabix, new.dbrid);      -- Haupt-ABK
                PERFORM CreateRecNoKeyword('art', r.ld_aknr, new.dbrid);    -- Artikel der ABK an FA
                PERFORM CreateRecNoKeyword('art', r.ap_ak_nr, new.dbrid);   -- Artikel des Arbeitspaketes
                PERFORM CreateRecNoKeyword('art', r.an_ak_nr, new.dbrid);   -- Artikel des Projekts
                PERFORM CreateRecNoKeyword('anl', r.an_nr, new.dbrid);      -- Projektnummer
                PERFORM CreateRecNoKeyword('ldsdoktxt', r.ld_auftg, new.dbrid); -- FA
                PERFORM CreateRecNoKeyword('auftgtxt', r.ag_nr, new.dbrid); -- Kundenauftrag
                PERFORM CreateRecNoKeyword('adk', r.ag_lkn, new.dbrid);     -- Kunde
                PERFORM CreateRecNoKeyword('qab', r.q_nr, new.dbrid);       -- QAB der Nacharbeits- oder Nachproduktions-Abk
            END LOOP;

            -- DokuLink und zusätzliche Keywords für Arbeitsgang-Foto 15806
            -- 15806 Bild zum Arbeitsgang
            IF new.pd_doktype LIKE 'picture.ab2%' THEN

                SELECT ab2.dbrid AS ab2_dbrid,
                       ab_ix,
                       ab_askix,
                       opl.dbrid AS opl_dbrid,
                       ab_ap_nr,
                       a2_ks
                  INTO r1
                  FROM ab2
                       JOIN abk ON a2_ab_ix = ab_ix
                  LEFT JOIN opl ON op_ix = ab_askix
                 WHERE a2_id = new.pd_dokident;

                PERFORM CreatePicnDokuLink( new.pd_id, 'ab2', r1.ab2_dbrid, new.pd_dokident );
                PERFORM CreatePicnDokuLink( new.pd_id, 'opl', r1.opl_dbrid, new.pd_dokident );

                PERFORM CreateRecNoKeyword( 'abk', r1.ab_ix, new.dbrid );
                PERFORM CreateRecNoKeyword( 'opl', r1.ab_askix, new.dbrid );
                PERFORM CreateRecNoKeyword( 'art', r1.ab_ap_nr, new.dbrid );
                PERFORM CreateRecNoKeyword( 'ksv', r1.a2_ks, new.dbrid );
            END IF;

        END IF;

        -- Rechnung
        IF new.pd_tablename = 'belkopf' THEN
            FOR r IN
                SELECT be_bnr, COALESCE(ada_ad_krz, be_rkrz) AS be_rkrz, COALESCE(bz_aknr, ag_aknr, ld_aknr) AS ak_nr, ag_nr, ld_auftg, ld_abk, bz_an_nr, vtp_vtr_nr
                  FROM belkopf
                  JOIN belzeil_grund ON bz_be_bnr = be_bnr
                  LEFT JOIN adk_adresses ON ada_krzl = be_rkrz
                  LEFT JOIN auftg ON ag_astat = 'E' AND ag_nr = bz_auftg AND ag_pos = bz_auftgpos
                  LEFT JOIN ldsdok ON ld_ag_id = ag_id
                  LEFT JOIN vertrag_pos ON vtp_id = ag_vtp_id
                 WHERE belkopf.dbrid = new.pd_dbrid
            LOOP
                PERFORM CreateRecNoKeyword('rechnr', r.be_bnr, new.dbrid); -- kann Ende 2014 gedroppt werden, jetzt über rck_mapto abgebildet!
                PERFORM CreateRecNoKeyword('adk', r.be_rkrz, new.dbrid);
                PERFORM CreateRecNoKeyword('art', r.ak_nr, new.dbrid);
                PERFORM CreateRecNoKeyword('auftgtxt', r.ag_nr, new.dbrid);
                PERFORM CreateRecNoKeyword('ldsdoktxt', r.ld_auftg, new.dbrid);
                PERFORM CreateRecNoKeyword('abk', r.ld_abk, new.dbrid);
                PERFORM CreateRecNoKeyword('anl', r.bz_an_nr, new.dbrid);
                PERFORM CreateRecNoKeyword('vertrag', r.vtp_vtr_nr, new.dbrid);
            END LOOP;--mehrere Aufträge in einer Rechnung
        END IF;

        -- Lieferschein und Gelangensbestätigung
        IF new.pd_doktype IN ('lfs', 'lfsbe', 'gbstg'/*, 'lfslds_be'*/) OR new.pd_doktype LIKE 'lfslds_%' THEN -- #9896 lfsbe kann Anfang 2019 entfernt werden

            PERFORM CreateRecNoKeyword('lifsch', new.pd_dokident, new.dbrid);

            FOR r IN SELECT ld_abk, ag_nr, belp_aknr, ld_auftg, ag_lkn, belp_krzbesteller, beld_krzlieferung, beld_krzrechnung, belp_projektnummer, belp_q_nr
                       FROM lieferschein
                       LEFT JOIN lieferschein_pos ON belp_dokument_id=beld_id
                       -- LEFT JOIN lifsch ON belp_l_nr=l_nr (LG,12/2013 - Entfernt wegen geänderter Lief.Pos <-> LagAbg Bezüge)
                       LEFT JOIN auftg  ON ag_id = belp_ag_id
                       LEFT JOIN abk ON ab_ix = ag_parentabk
                       LEFT JOIN ldsdok ON CASE WHEN new.pd_doktype LIKE 'lfslds_%' THEN
                                                     ldsdok.dbrid = ab_dbrid -- Beistellieferschein: interne Auftragspos über ag_parentabk an Bestellung
                                                ELSE
                                                     ld_ag_id = ag_id -- direktbezug
                                                END
                      WHERE lieferschein.beld_dokunr = new.pd_dokident
            LOOP
                PERFORM CreateRecNoKeyword('abk',       r.ld_abk, new.dbrid);
                PERFORM CreateRecNoKeyword('art',       r.belp_aknr, new.dbrid);
                PERFORM CreateRecNoKeyword('ldsdoktxt', r.ld_auftg, new.dbrid);
                PERFORM CreateRecNoKeyword('adk',       r.beld_krzlieferung, new.dbrid);
                PERFORM CreateRecNoKeyword('adk',       r.belp_krzbesteller, new.dbrid);
                PERFORM CreateRecNoKeyword('adk',       r.beld_krzrechnung, new.dbrid);
                -- bei Beistelliefschein ist der interne Auftrag unter der Bestellung NICHT der Kundenauftrag
                -- IF NOT new.pd_doktype LIKE 'lfslds_%' THEN
                   PERFORM CreateRecNoKeyword('auftgtxt',  r.ag_nr, new.dbrid);
                -- END IF;
                PERFORM CreateRecNoKeyword('anl',       r.belp_projektnummer, new.dbrid);
                PERFORM CreateRecNoKeyword('qab',       r.belp_q_nr, new.dbrid);
            END LOOP;
        END IF;

        -- Verkauf
        IF new.pd_tablename = 'auftgtxt' THEN
            -- #8429 Verlinkung automatisch erstellen
            -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Anwendungsfall_Verkauf-BDK
            -- Ein Vorhandensein von new.pd_dokident UNTER auftgtxt ist grundsätzlich immer eine Positionszuordnung
            SELECT dbrid, ag_nr INTO r FROM auftg WHERE ag_id = new.pd_dokident;
            PERFORM CreatePicnDokuLink(new.pd_id, 'auftg', r.dbrid::VARCHAR, new.pd_dokident);
            PERFORM CreateRecNoKeyword('auftgtxt', r.ag_nr, new.dbrid);

            IF new.pd_doktype IN ('auftg_dok', 'aufadok', 'aufedok', 'empfbstg', 'auftg_nachtrag_dok') THEN -- Angebots-/Auftragsbestätigung
                FOR r IN SELECT ag_nr, ag_aknr, ag_lkn, ag_bda, ag_dokunr, ag_an_nr, vtp_vtr_nr, ag_q_nr
                           FROM auftg LEFT JOIN vertrag_pos ON vtp_id = ag_vtp_id
                          WHERE ag_dokunr = new.pd_dokident::INTEGER
                LOOP
                    PERFORM CreateRecNoKeyword('art', r.ag_aknr, new.dbrid);
                    PERFORM CreateRecNoKeyword('auftgtxt', r.ag_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('adk', r.ag_lkn, new.dbrid);
                    PERFORM CreateRecNoKeyword('auf_bda', r.ag_bda, new.dbrid);
                    PERFORM CreateRecNoKeyword('anl', r.ag_an_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('auftgdokutxt', r.ag_dokunr, new.dbrid);
                    PERFORM CreateRecNoKeyword('vertrag', r.vtp_vtr_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('qab', r.ag_q_nr, new.dbrid);
                    IF new.pd_source IN ('scan', 'file') THEN
                        PERFORM CreateRecNoKeyword('sonstiges', 'ANGEBOTSAKTE', new.dbrid);
                    END IF;
                END LOOP;
            END IF;

            IF new.pd_doktype IN ('bdk', 'znrk') THEN
                -- auskommentiert (Fehler #7432 und #10802):
                    -- Die Bestell-Nr. des Kunden wird in der Dokumentenverwaltung eingegeben, daher ist dort ein Satz vorhanden.
                    -- SELECT r_descr INTO _descr FROM recnokeyword WHERE r_dbrid = new.dbrid AND r_kategorie = 'auf_bda'; -- manuelle Eingabe
                    -- stattdessen Lösung per #8429
                FOR r IN SELECT ag_nr, ag_aknr, ag_lkn, ag_bda, ag_q_nr
                           FROM auftg
                          WHERE ag_id = new.pd_dokident::integer
                            -- Beachte oben: ähnlich bei Bestellbestätigung Lieferant
                            -- auskommentiert (Fehler #7432 und #10802):
                                -- OR ag_bda = _descr
                                -- Funktioniert nicht, da allgemeine Begriffe in ag_bda (z.B. Mail) oder Bestell-Nr. Kunde mehrfach vergeben (versch. Kunden).
                                -- stattdessen Lösung per #8429
                LOOP -- ID über Scanner-Barcode
                    PERFORM CreateRecNoKeyword('art', r.ag_aknr, new.dbrid);
                    PERFORM CreateRecNoKeyword('auftgtxt', r.ag_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('adk', r.ag_lkn, new.dbrid);
                    PERFORM CreateRecNoKeyword('auf_bda', r.ag_bda, new.dbrid);
                    PERFORM CreateRecNoKeyword('qab', r.ag_q_nr, new.dbrid);
                END LOOP;

            END IF;

            IF new.pd_doktype = 'airblk' THEN
                FOR r IN SELECT ag_nr, ag_aknr, beld_dokunr, ag_bda, (SELECT az_kunr FROM artzuo WHERE az_pronr=ag_aknr AND az_prokrz=ag_lkn ORDER BY az_gdatum DESC LIMIT 1) AS az_kunr
                         FROM auftg JOIN lieferschein_pos ON ag_id=belp_ag_id
                                    JOIN lieferschein ON belp_dokument_id=beld_id
                         WHERE ag_nr=new.pd_dokident AND ag_astat='E'
                LOOP
                    PERFORM CreateRecNoKeyword('art', r.ag_aknr, new.dbrid);
                    PERFORM CreateRecNoKeyword('art_kunde', r.az_kunr, new.dbrid);
                    PERFORM CreateRecNoKeyword('auftgtxt', r.ag_nr, new.dbrid);
                    PERFORM CreateRecNoKeyword('lifsch', r.beld_dokunr, new.dbrid);
                    PERFORM CreateRecNoKeyword('auf_bda', r.ag_bda, new.dbrid);
                END LOOP;
            END IF;
        END IF;

        -- Dokumente am QAB
        IF new.pd_tablename='qab' THEN
            SELECT q_nr, q_w_wen, COALESCE(l_lgchnr, w_lgchnr) AS chnr, q_ab_ix, q_ak_nr, q_l_nr, ag_nr, COALESCE(ag_lkn, ld_kn) AS adk, ld_auftg, COALESCE(TBeleg.GetDokumentNrFromPos(belp_id), w_lfsnr) AS lfs
              INTO r
              FROM qab
              LEFT JOIN wendat ON w_wen=q_w_wen
              LEFT JOIN abk ON ab_ix=q_ab_ix
              LEFT JOIN lifsch ON l_nr=q_l_nr
              LEFT JOIN ldsdok ON ld_id=w_lds_id
              LEFT JOIN auftg ON ag_id=l_ag_id
              LEFT JOIN belegpos ON belp_id = l_belp_id
             WHERE qab.dbrid = new.pd_dbrid;

            PERFORM CreateRecNoKeyword('art', r.q_ak_nr, new.dbrid);
            PERFORM CreateRecNoKeyword('adk', r.adk, new.dbrid);
            PERFORM CreateRecNoKeyword('wendat', r.q_w_wen, new.dbrid);
            PERFORM CreateRecNoKeyword('chnr', r.chnr, new.dbrid);
            PERFORM CreateRecNoKeyword('lifsch', r.lfs, new.dbrid); --TODO: Anpassen
            PERFORM CreateRecNoKeyword('abk', r.q_ab_ix, new.dbrid);
            PERFORM CreateRecNoKeyword('ldsdoktxt', r.ld_auftg, new.dbrid);
            PERFORM CreateRecNoKeyword('auftgtxt', r.ag_nr, new.dbrid);
        END IF;

        -- Verträge
        IF new.pd_tablename = 'vertrag' THEN
            SELECT vtr_krz, vtr_abschluss, vtr_nr, vtr_an_nr
              INTO r
              FROM vertrag
             WHERE vertrag.dbrid=new.pd_dbrid;

            PERFORM CreateRecNoKeyword('adk', r.vtr_krz, new.dbrid);
            PERFORM CreateRecNoKeyword('date', CAST(r.vtr_abschluss AS VARCHAR(10)), new.dbrid);
            PERFORM CreateRecNoKeyword('anl', r.vtr_an_nr, new.dbrid);
            PERFORM CreateRecNoKeyword('vertrag', r.vtr_nr, new.dbrid);
        END IF;

        -- Adressdokumente
        IF new.pd_tablename = 'adk' THEN
            SELECT ad_krz INTO r FROM adk WHERE adk.dbrid=new.pd_dbrid;
            PERFORM CreateRecNoKeyword('adk', r.ad_krz, new.dbrid);
        END IF;

        -- Artikeldokumente
        IF new.pd_tablename = 'art' THEN
            SELECT ak_nr INTO r FROM art WHERE art.dbrid = new.pd_dbrid;
            PERFORM CreateRecNoKeyword('art', r.ak_nr, new.dbrid);
            -- Verschrottungsnachweis 6278
            IF new.pd_doktype = 'vschronw' THEN
                SELECT  ''::VARCHAR AS lo_txt, ''::VARCHAR AS lo_lgchnr_new, ''::VARCHAR AS lo_umbuchid  INTO r;
                PERFORM CreateRecNoKeyword('snr', r.lo_txt, new.dbrid);
                PERFORM CreateRecNoKeyword('chnr', r.lo_lgchnr_new, new.dbrid);
                PERFORM CreateRecNoKeyword('umbuchnr', r.lo_umbuchid, new.dbrid);
            END IF;
            --
        END IF;

        -- CoC
        IF new.pd_tablename = 'coc' THEN --durch Link von coc und lifsch wird dieser trigger auch bei update von lifsch ausgeführt
            --Füge zuerst Standardkeywords ein
            FOR r IN SELECT belp_aknr
                       FROM coc
                       JOIN cocpos ON cocp_coc_id=coc_id
                       JOIN lieferschein_pos ON belp_id=cocp_belp_id
                      WHERE coc_beld_dokunr = new.pd_dokident
            LOOP
                PERFORM CreateRecNoKeyword('art', r.belp_aknr, new.dbrid);
            END LOOP;

            --Erweiterung Anforderung #5164: Gleiche Schlagworte von CoC und Lieferschein
            --Hole Schlagworte aus Lieferschein und hänge an COC Schlagworte an
            FOR r IN SELECT * FROM recnokeyword
                     WHERE r_dbrid = (SELECT dbrid FROM picndoku WHERE pd_dokident=new.pd_dokident AND pd_doktype IN ('lfs') AND NOT pd_deletable ORDER BY pd_id desc LIMIT 1)
                       AND r_tablename  = 'picndoku'
                       AND r_kategorie <> 'art' --bereits durch ersten Loop
                       AND r_kategorie <> 'lifsch'
            LOOP
                PERFORM CreateRecNoKeyword(r.r_kategorie, r.r_descr, new.dbrid);
            END LOOP;
        END IF;

        -- Änderungsmanagement
        IF new.pd_tablename = 'beleg_k__artchange' THEN
           SELECT kartc_aknr_bg INTO r FROM tartikel.beleg_k__artchange WHERE dbrid = new.pd_dbrid;
           PERFORM CreateRecNoKeyword('art', r.kartc_aknr_bg, new.dbrid);
        END IF;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;
-- Dokumentverschlagwortung



  CREATE TRIGGER picndoku__a30_iud__indexing
    AFTER INSERT OR UPDATE OR DELETE
    ON picndoku
    FOR EACH ROW
    EXECUTE PROCEDURE picndoku__a30_iud__indexing();
--

-- Änderungen von Dateiinhalt und DMS-Speicherpfad sind nicht erlaubt (aktueller Doktype+Archive)
CREATE OR REPLACE FUNCTION picndoku_editing_forbidden(pdid INTEGER, OUT result BOOLEAN, OUT text VARCHAR) RETURNS RECORD AS $$
  DECLARE doktype VARCHAR;
  BEGIN
    doktype := pd_doktype FROM picndoku WHERE pd_id = pdid;
    result  := false;
    text    := NULL;

    -- Gesperrt durch Auscheckkorb
    IF picndoku_is_blocked(pdid, True)
        AND NOT (TSystem.roles__user__group__is_in(current_user::VARCHAR, 'SYS.Administratoren')
              OR TSystem.roles__user__group__is_in(current_user::VARCHAR, 'SYS.Dokumente-Admin')) THEN
      result := true;
      text   := concat(lang_text(17924), ' (', pdid, ' ', doktype, ')');  -- Dokument darf nicht geändert oder gelöscht werden
      RETURN;
    END IF;

    -- Schreibgeschütztes Laufwerk
    IF exists(
        SELECT true
        FROM picndoku
        JOIN dokutypes
          ON dt_id = pd_doktype
        WHERE pd_archive
          AND dt_write_once
          AND pd_id = pdid) THEN
      result := true;
      text   := concat(lang_text(17924), ' (', pdid, ' ', doktype, ')');  -- Dokument darf nicht geändert oder gelöscht werden
      RETURN;
    END IF;

    -- Verboten durch Benutzerrechte (noch nicht implementiert)
    --IF exists(SELECT ... FROM rule/loginrole/rolepermissions/userroles) THEN  http://redmine.prodat-sql.de/issues/5049
    --  result := true;
    --  text   := concat(lang_text(17924), ' (', pdid, ' ', doktype, ')');  -- Dokument darf nicht geändert oder gelöscht werden
    --  RETURN;
    --END IF;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- hinzufügen von Dokumenten zum DMS-Speicherpfad ist nicht erlaubt (neue Revision für bestehendes Dokument)
CREATE OR REPLACE FUNCTION picndoku_adding_forbidden(pdid INTEGER, OUT result BOOLEAN, OUT text VARCHAR) RETURNS RECORD AS $$
  DECLARE dok RECORD;
      archive BOOLEAN;
  BEGIN
    SELECT * INTO dok FROM picndoku LEFT JOIN dokutypes ON dt_id = pd_doktype WHERE pd_id = pdid;
    archive := dok.pd_archive OR (SELECT dt_archive_default FROM dokutypes WHERE dt_id = dok.pd_doktype);
    result  := false;
    text    := NULL;

    -- Gesperrt durch Auscheckkorb
    IF picndoku_is_blocked(pdid, True)
        AND NOT (TSystem.roles__user__group__is_in(current_user::VARCHAR, 'SYS.Administratoren')
              OR TSystem.roles__user__group__is_in(current_user::VARCHAR, 'SYS.Dokumente-Admin')) THEN
      result := true;
      text   := concat(lang_text(17960), ' (block ', pdid, ' ', dok.pd_doktype, ')');  -- Neue Revision nicht erlaubt
      RETURN;
    END IF;

    -- Schreibgeschütztes Laufwerk (neue Dokumente können natürlich geschrieben werden)
    --IF archive AND dok.dt_write_once THEN
    --  result := true;
    --  text   := concat(lang_text(17960), ' (read-only ', pdid, ' ', dok.pd_doktype, ')');  -- Neue Revision nicht erlaubt
    --  RETURN;
    --END IF;

    -- Verboten durch Benutzerrechte (noch nicht implementiert)
    --IF exists(SELECT ... FROM rule/loginrole/rolepermissions/userroles) THEN  http://redmine.prodat-sql.de/issues/5049
    --  result := true;
    --  text   := concat(lang_text(17960), ' (role ', pdid, ' ', dok.pd_doktype, ')');  -- Neue Revision nicht erlaubt
    --  RETURN;
    --END IF;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- hinzufügen von Dokumenten zum DMS-Speicherpfad ist nicht erlaubt (bestimmter Doktype, z.B. neuer Datei oder Verschieben in anderen Doktype)
CREATE OR REPLACE FUNCTION picndoku_adding_forbidden(doktype VARCHAR, archive BOOLEAN, OUT result BOOLEAN, OUT text VARCHAR) RETURNS RECORD AS $$
  BEGIN
    archive := archive OR (SELECT dt_archive_default FROM dokutypes WHERE dt_id = doktype);
    result  := false;
    text    := NULL;

    -- Gesperrt durch Auscheckkorb (noch nicht implementiert : in neuster Revision suchen : siehe picndoku__a_iu__revision > FIND REVISION)
--    IF picndoku_is_blocked(pdid, True)  -- oder IF picndoku_is_blocked(tablename, pddbrid, doktype, True)
--        AND NOT (TSystem.roles__user__group__is_in(current_user::VARCHAR, 'SYS.Administratoren')
--              OR TSystem.roles__user__group__is_in(current_user::VARCHAR, 'SYS.Dokumente-Admin')) THEN
--      result := true;
--      text   := concat(lang_text(17924), ' (block ', pdid, ' ', doktype, ')');  -- Dokument darf nicht geändert oder gelöscht werden
--    END IF;

    -- Schreibgeschütztes Laufwerk (neue Dokumente können natürlich geschrieben werden)
    --IF archive AND dt_write_once THEN
    --  result := true;
    --  text   := concat(lang_text(17960), ' (read-only ', doktype, ')');  -- Neue Revision nicht erlaubt
    --  RETURN;
    --END IF;

    -- Verboten durch Benutzerrechte (noch nicht implementiert)
    --IF exists(SELECT ... FROM rule/loginrole/rolepermissions/userroles) THEN  -- http://redmine.prodat-sql.de/issues/5049
    --  result := true;
    --  text   := concat(lang_text(17923), ' (role ', doktype, ')');  -- Keine Berechtigung für dieses Verzeichnis
    --END IF;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--


-- Parameter, die an einem Schlüsselwort (Auftrag, Lieferschein etc) hängen, updaten
CREATE OR REPLACE FUNCTION picndoku__a40_iud__set_recno() RETURNS TRIGGER AS $$
 DECLARE rdbrid VARCHAR;
  BEGIN
    IF TG_OP = 'DELETE' THEN
          RETURN old;
    END IF;
    IF new.pd_dokumentfile IS NULL THEN
        RETURN new;  -- CustomFolder nicht behandeln
    END IF;

    IF TG_OP='UPDATE' THEN
      --Begin Gelangensbestaetigung
      IF ( TSystem.Settings__GetBool('LFSAutoRecnoGelangensbestaetigung') AND new.pd_doktype='gbstg' ) THEN
        rdbrid=(SELECT lieferschein.dbrid FROM lieferschein WHERE lieferschein.beld_dokunr=new.pd_dokident);
        PERFORM TRecnoParam.Set('System.Gelangensbestätigung', rdbrid, True);
      END IF; --END Gelangensbestaetigung
    END IF; --END UPDATE
    --
    IF TG_OP='INSERT' THEN --Selbstauskunft
        IF ( TSystem.Settings__GetBool('EINK_sauskft_lief') AND new.pd_doktype='sauskft_lief' ) THEN
           rdbrid=(SELECT adk.dbrid FROM adk WHERE adk.dbrid=new.pd_dbrid );
           PERFORM TRecnoParam.Set('Lieferant.Selbstauskunft', rdbrid, True);
        END IF; --END Selbstauskunft
        --
        IF ( TSystem.Settings__GetBool('EINK_gehmverbrg_lief') AND new.pd_doktype='gehmverbrg_lief' ) THEN
           rdbrid=(SELECT adk.dbrid FROM adk WHERE adk.dbrid=new.pd_dbrid );
           PERFORM TRecnoParam.Set('Lieferant.Selbstauskunft', rdbrid, True);
        END IF; --END Geheimhaltungsvereinbarung
        --
    END IF; --END INSERT
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER picndoku__a40_iud__set_recno
    AFTER INSERT OR UPDATE OR DELETE
    ON picndoku
    FOR EACH ROW
    EXECUTE PROCEDURE picndoku__a40_iud__set_recno();
--
-- Langfristiges Ziel:
-- DMS: r_kategorie SYS.DMS
-- PrintSettings: Sys.Printing
-- KWS: Sys.KWS
-- ?
-- Freie / Datensatzparameter: r_kategorie SYS.PARAMETER
--
-- Jetzt:
-- DMS: r_kategorie 'tabellename' UND NICHT NULL UND NICHT INternal System usage UND NICHT 'SYS.%'
-- PrintSettings, KWS: internalSystemusage
-- Gibts noch was mit internalsystemusage?
-- Freie / Datensatzparameter: r_kategorie SYS.PARAMETER


-- Alt, kann weg
CREATE TABLE picndokupages
 (pdp_id        SERIAL PRIMARY KEY,
  pdp_pd_id     INTEGER NOT NULL REFERENCES picndoku ON DELETE CASCADE,
  pdp_pageno    INTEGER,
  pdp_blob      LO,
  pdp_blobprv   LO,
  pdp_cmmnt     LO
 );


-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Picndoku
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Dokumentenmanagement_-_DMS
CREATE TABLE picndokulink
 (pdl_id                SERIAL PRIMARY KEY,
  pdl_pd_id             INTEGER NOT NULL REFERENCES picndoku ON DELETE CASCADE,
  pdl_tablename         VARCHAR(30) NOT NULL,
  pdl_dbrid             VARCHAR(32) NOT NULL,
  pdl_neu               BOOL NOT NULL DEFAULT TRUE,--neues Dokument, noch nicht angenommen
  pdl_checked           BOOL NOT NULL DEFAULT FALSE,--Dokument geprüft
  pdl_revert            BOOL NOT NULL DEFAULT FALSE,--Dokument abgewiesen, Prüfung endete mit Fehler
  pdl_comment           VARCHAR(100),
  pdl_txt               TEXT
 );

 CREATE INDEX picndokulink_pdl_dbrid ON picndokulink (pdl_dbrid);
 CREATE INDEX picndokulink_pdl_pd_id ON picndokulink (pdl_pd_id);
 CREATE INDEX picndokulink_pdl_search ON picndokulink (pdl_tablename, pdl_dbrid);
 CREATE INDEX picndokulink_pdl_comment ON picndokulink (pdl_comment) WHERE pdl_comment IS NOT NULL;
 CREATE INDEX picndokulink_pdl_docheck ON picndokulink (pdl_tablename) WHERE NOT pdl_checked;  --noch nicht abgeschlossene Dokumente in dieser Abteilung
 CREATE INDEX picndokulink_pdl_tablename ON picndokulink (pdl_tablename);

 CREATE OR REPLACE FUNCTION picndokulink__b_i() RETURNS TRIGGER AS $$
  BEGIN
   IF EXISTS(SELECT true FROM picndokulink WHERE pdl_pd_id=new.pdl_pd_id AND pdl_dbrid=new.pdl_dbrid AND pdl_tablename=new.pdl_tablename) THEN
         RETURN null;--doppelte Einträge verwerfen
   ELSE
         RETURN new;
   END IF;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER picndokulink__b_i
   BEFORE INSERT
   ON picndokulink
   FOR EACH ROW
   EXECUTE PROCEDURE picndokulink__b_i();
--

-- Hilfsfunktion: Verbindung des APPS prüfen
CREATE OR REPLACE FUNCTION tsystem.apps_connection__get(
    IN uri         varchar,
    IN auth_header varchar
  )
  RETURNS varchar
  AS $$
  DECLARE
    result varchar;
  BEGIN

    SELECT content
      INTO result
      FROM tsystem.http_request(
             ( 'GET', uri, ARRAY[ http_header( 'Authorization', auth_header ) ], null, null )::http_request
           );
    RETURN result::JSON -> 'result' ->> 0;

    EXCEPTION WHEN OTHERS THEN
      PERFORM TSystem.LogError(sqlerrm);
      RETURN format('APPS-Response: %s | SQL-Error: %s', result, sqlerrm);

  END $$ LANGUAGE plpgsql;


-- Workaround, da Zugriff vom Delphi aus vereinzelt per DBRID als Integer erfolgt ( TDokument.CreateDokuLink )
CREATE OR REPLACE FUNCTION CreatePicnDokuLink(pdid INTEGER, tablename VARCHAR, tdbrid INTEGER, _comment VARCHAR DEFAULT NULL) RETURNS VOID AS $$
BEGIN
  PERFORM CreatePicnDokuLink(pdid, tablename::VARCHAR, tdbrid::VARCHAR, _comment::VARCHAR);
  RETURN;
END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION CreatePicnDokuLink(pdid INTEGER, tablename VARCHAR, tdbrid VARCHAR, _comment VARCHAR DEFAULT NULL) RETURNS VOID AS $$
BEGIN
  IF tdbrid IS NOT NULL THEN
    INSERT INTO picndokulink (pdl_pd_id, pdl_tablename, pdl_dbrid, pdl_comment)
                      SELECT pdid,      tablename,     tdbrid,    _comment
                      WHERE NOT EXISTS (SELECT true FROM picndokulink
                                        WHERE
                                          pdl_pd_id     = pdid
                                          AND pdl_tablename = tablename
                                          AND pdl_dbrid     = tdbrid
                                          AND pdl_comment   = _comment);
  END IF;
  RETURN;
END $$ LANGUAGE plpgsql;
--

-- tablename/tdbrid=NULL > lösche alle Verlinkungen dieses Dokuments
-- pdid=NULL > lösche alle Verlinkungen an diesem Datensatz
CREATE OR REPLACE FUNCTION DeletePicnDokuLink(pdid INTEGER, tablename VARCHAR, tdbrid VARCHAR) RETURNS VOID AS $$
 BEGIN
  DELETE FROM picndokulink WHERE (pdid IS NULL OR pdl_pd_id = pdid)
    AND (tablename IS NULL OR pdl_tablename = tablename) AND (tdbrid IS NULL OR pdl_dbrid = tdbrid);
  RETURN;
 END $$ LANGUAGE plpgsql;
--

-- Dokument mit anderem Datensatz verlinken
-- pdid kann NULL sein -> alle Dokumente verschieben
CREATE OR REPLACE FUNCTION MovePicnDokuLink(pdid INTEGER, tablename VARCHAR, tdbrid_old VARCHAR, tdbrid_new VARCHAR) RETURNS VOID AS $$
 BEGIN
  UPDATE picndokulink SET pdl_dbrid = tdbrid_new WHERE (pdid IS NULL OR pdl_pd_id = pdid)
    AND pdl_tablename = tablename AND pdl_dbrid = tdbrid_old;
  RETURN;
 END $$ LANGUAGE plpgsql;
--

-- Dokument-Sperren und Checkouts freigeben/löschen
CREATE OR REPLACE PROCEDURE picndoku__lock_or_checkout__remove(_Username VARCHAR = NULL, _pdid INTEGER = NULL, _Days INTEGER = NULL, _InclDelayedUploads BOOLEAN = False)
  AS $$
    -- alte Sperren löschen
    -- (nun unnötige picndoku_revision-Datensätze werden anschließend in DailyDBFunctions.DMS.SperrenBereinigen bereinigt)

    UPDATE picndoku_revision
    SET pdr_blocked_pd_id = NULL, pdr_blocked_date = NULL, pdr_blocked_by = NULL, pdr_checkout_path = NULL
    WHERE (pdr_blocked_date IS NOT NULL)
      AND (pdr_blocked_date <= current_date - coalesce(_Days, 90)
        OR _pdid IS NOT NULL)  -- Datum ignorieren, wenn explitit ein Dokument
      AND (_Username IS NULL OR pdr_blocked_by = _Username)
      AND (_pdid IS NULL OR pdr_blocked_pd_id = _pdid
        OR exists(SELECT True FROM picndoku WHERE pd_revision_id = pdr_revision_id AND pd_id = _pdid));
  $$ LANGUAGE SQL;
--

-- Abteilungstabelle für Dokumentverwaltung
CREATE TABLE dokabteilungen
 (dabt_name             VARCHAR(30) PRIMARY KEY,
  dabt_tablename        VARCHAR(30) NOT NULL,
  dabt_pos              INTEGER
 );

-- Liste aller Dokumentenbäume
CREATE TABLE dokutrees
 (dtl_id          SERIAL PRIMARY KEY,
  dtl_description VARCHAR(50) NOT NULL UNIQUE,
  dtl_tablename   VARCHAR(30) NULL UNIQUE
 );

-- Knoten(Verzeichnisse) der Bäume
CREATE TABLE dokutreenodes
 (dtn_id          SERIAL PRIMARY KEY,
  dtn_dtl_id      INTEGER NOT NULL REFERENCES dokutrees ON UPDATE CASCADE ON DELETE CASCADE,
  dtn_nodeid      INTEGER NOT NULL,
  dtn_parentid    INTEGER REFERENCES dokutreenodes ON UPDATE CASCADE ON DELETE CASCADE,
  dtn_position    INTEGER,
  dtn_caption     VARCHAR(50) NOT NULL,
  dtn_image       INTEGER NOT NULL DEFAULT 151,
  UNIQUE (dtn_dtl_id, dtn_nodeid),
  CHECK  (dtn_nodeid < 1000)  -- keine Überschneidung zwischen pd_id und dtn_nodeid
 );

    CREATE OR REPLACE FUNCTION dokutrees_getid(tablename VARCHAR) RETURNS INTEGER AS $$
      SELECT dtl_id FROM dokutrees WHERE dtl_tablename = $1 OR dtl_tablename IS NULL ORDER BY dtl_tablename IS NULL LIMIT 1
    $$ LANGUAGE SQL IMMUTABLE;

-- Pfad zu einem Verzeichnis im Dokumentenbaum (inkl. CustomFolders)
-- "UNION" im "UNION ALL (SELECT" nicht möglich, darum erst UNION und dann der JOIN auf die "temp"
-- EPgError: recursive reference to query "temp" must not appear more than once
CREATE OR REPLACE FUNCTION dokutrees_getpath_cf(tablename VARCHAR, parentnodeident VARCHAR, show_unknown BOOLEAN DEFAULT True) RETURNS VARCHAR(250) AS $$
  WITH RECURSIVE temp (n, id, parentid, nodeid, caption, position) AS (
    (SELECT DISTINCT 0, dtn_id, dtn_parentid, dtn_nodeid, IfThen(dtn_nodeid <> 0, dtn_caption, '') AS dtn_caption, dtn_position  --"Wurzel" ohne Namen
       FROM dokutreenodes
       JOIN dokutrees ON dtl_id = dokutrees_getid($1)
       WHERE dtn_dtl_id = dtl_id
         AND dtn_nodeid = $2
     UNION
     SELECT 0, -pd_id, dtn_id, pd_id, COALESCE(pd_path_user, pd_path), 0
       FROM picndoku
       LEFT JOIN dokutrees ON dtl_id = dokutrees_getid($1)
       LEFT JOIN dokutreenodes ON dtn_dtl_id = dtl_id
       WHERE pd_dokumentfile IS NULL
         AND dtn_nodeid = pd_parentnodeident
         AND pd_id = $2
     ORDER BY dtn_position, dtn_caption
     LIMIT 1)  -- ORDER BY und LIMIT da aktuell in einigen Dokumentenbäumen dtn_nodeid doppelt/mehrfach drin stehen
    UNION ALL
    (SELECT DISTINCT n+1, dtn_id, dtn_parentid, dtn_nodeid, dtn_caption, dtn_position
       FROM
         (SELECT dtn_id, dtn_parentid, dtn_nodeid, dtn_caption, dtn_position
            FROM dokutreenodes
            JOIN dokutrees ON dtl_id = dokutrees_getid($1)
            WHERE dtn_dtl_id = dtl_id
              AND dtn_nodeid <> 0  -- "Wurzel" weglassen (nur oben drin, falls direkt ausgewählt)
          UNION
          SELECT -pd_id, dtn_id, pd_id, COALESCE(pd_path_user, pd_path), 0
            FROM picndoku
            LEFT JOIN dokutrees ON dtl_id = dokutrees_getid($1)
            LEFT JOIN dokutreenodes ON dtn_dtl_id = dtl_id
            WHERE pd_dokumentfile IS NULL
              AND dtn_nodeid = pd_parentnodeident) AS temp2
       JOIN temp ON parentid = dtn_id
       WHERE n < 32 AND nodeid IS NOT NULL  -- Ende oder zu lang (Endlosschleife?)
     ORDER BY dtn_position, dtn_caption
     LIMIT 1)  -- ORDER BY und LIMIT da aktuell in einigen Dokumentenbäumen dtn_nodeid doppelt/mehrfach drin stehen
  --) SELECT * FROM temp  -- für Debugging
  ) SELECT COALESCE(array_to_string(array_agg(caption), ' » ')::VARCHAR(250), IfThen($3, '* ' || $2, NULL))
    FROM (SELECT * FROM temp ORDER BY n DESC) AS temp
 $$ LANGUAGE SQL STABLE;
--

-- Pfad zu einem Verzeichnis im Dokumentenbaum (ohne CustomFolders)
CREATE OR REPLACE FUNCTION dokutrees_getpath(tablename VARCHAR, parentnodeident VARCHAR, show_unknown BOOLEAN DEFAULT True) RETURNS VARCHAR(250) AS $$
  WITH RECURSIVE temp (n, id, parentid, nodeid, caption, position) AS (
    (SELECT DISTINCT 0, dtn_id, dtn_parentid, dtn_nodeid, IfThen(dtn_nodeid <> 0, dtn_caption, '') AS dtn_caption, dtn_position  --"Wurzel" ohne Namen
     FROM dokutreenodes
     JOIN dokutrees ON dtl_id = dokutrees_getid($1)
     WHERE dtn_dtl_id = dtl_id
       AND dtn_nodeid = $2
     ORDER BY dtn_position, dtn_caption
     LIMIT 1)  -- ORDER BY und LIMIT da aktuell in einigen Dokumentenbäumen dtn_nodeid doppelt/mehrfach drin stehen
    UNION ALL
    (SELECT DISTINCT n+1, dtn_id, dtn_parentid, dtn_nodeid, dtn_caption, dtn_position
     FROM dokutreenodes
     JOIN dokutrees ON dtl_id = dokutrees_getid($1)
     JOIN temp ON parentid = dtn_id
     WHERE dtn_dtl_id = dtl_id
       AND dtn_nodeid <> 0     -- "Wurzel" weglassen (nur oben drin, falls direkt ausgewählt)
       AND nodeid IS NOT NULL  -- Ende
       AND n < 32              -- zu lang (Endlosschleife?)
     ORDER BY dtn_position, dtn_caption
     LIMIT 1)  -- ORDER BY und LIMIT da aktuell in einigen Dokumentenbäumen dtn_nodeid doppelt/mehrfach drin stehen
  ) SELECT COALESCE(array_to_string(array_agg(caption), ' » ')::VARCHAR(250),
      (CASE WHEN $2 LIKE '-%' THEN dokutrees_getpath_cf($1, $2, False) ELSE NULL END),  -- $2::INT < 0   für CustomFolder nochmal in der "schlimmen" Version dieser Funktion schauen
      (CASE WHEN $3 THEN '* ' || $2 ELSE NULL END))  -- show_unknown
    FROM (SELECT * FROM temp ORDER BY n DESC) AS temp
 $$ LANGUAGE SQL STABLE;
--

-- Caption eines Verzeichnisses im Dokumentenbaum
CREATE OR REPLACE FUNCTION dokutrees_getcaption(tablename VARCHAR, parentnodeident VARCHAR) RETURNS VARCHAR(50) AS $$
    SELECT coalesce(
      (SELECT dtn_caption FROM dokutreenodes WHERE dtn_dtl_id = dokutrees_getid($1) AND dtn_nodeid = $2 LIMIT 1),  -- LIMIT da aktuell in einigen Dokumentenbäumen dtn_nodeid doppelt/mehrfach drin stehen
      (SELECT coalesce(pd_path_user, pd_path) FROM picndoku WHERE pd_dokumentfile IS NULL AND pd_id = $2)  -- Custom-Folder
    )
  $$ LANGUAGE SQL STABLE;
--


-- Luftfahrtnorm Dokumente, CAD, Musterunterlagen
    -- Alle P-Dokumente eines Artikels in einer Zeile
    CREATE OR REPLACE FUNCTION get_art_dokments__p00(
        IN artdbrid             VARCHAR,
        OUT stkldms_p00         VARCHAR, -- xtt16515 'P00 - CAD Model'
        OUT stkldms_p00_pdid    VARCHAR,
        OUT stkldms_p01         VARCHAR, -- xtt16516 'P01 - Geometry Drawing'
        OUT stkldms_p01_pdid    VARCHAR,
        OUT stkldms_p02         VARCHAR, -- xtt16517 'P02 - Single (Part) Drawing'
        OUT stkldms_p02_pdid    VARCHAR,
        OUT stkldms_p03         VARCHAR, -- xtt16518 'P03 - Lamination Plan'
        OUT stkldms_p03_pdid    VARCHAR,
        OUT stkldms_p04         VARCHAR, -- xtt16519 'P04 - Assembly Drawing'
        OUT stkldms_p04_pdid    VARCHAR,
        OUT stkldms_p05         VARCHAR, -- xtt16520 'P05 - Exploded Drawing'
        OUT stkldms_p05_pdid    VARCHAR,
        OUT stkldms_p06         VARCHAR, -- xtt16521 'P06 - Wiring Diagramm (Stromlaufplan)'
        OUT stkldms_p06_pdid    VARCHAR,
        OUT stkldms_p07         VARCHAR, -- xtt16522 'P07 - (Design) Parts List'
        OUT stkldms_p07_pdid    VARCHAR,
        OUT stkldms_p08         VARCHAR, -- xtt16523 'P08 - Electrical Component List (El. Bauteil Liste)'
        OUT stkldms_p08_pdid    VARCHAR,
        OUT stkldms_p09         VARCHAR, -- xtt16524 'P09 - Wiring List (Kabelliste)'
        OUT stkldms_p09_pdid    VARCHAR,
        OUT stkldms_p10         VARCHAR, -- xtt16525 'P10 - Specification'
        OUT stkldms_p10_pdid    VARCHAR,
        OUT stkldms_p11         VARCHAR, -- xtt16526 'P11 - Block diagram (electric, hydraulic etc.)'
        OUT stkldms_p11_pdid    VARCHAR,
        OUT stkldms_p12         VARCHAR, -- xtt16527 'P12 - Work and Quality Control Plan'
        OUT stkldms_p12_pdid    VARCHAR,
        OUT stkldms_p13         VARCHAR, -- xtt27007 'P13 - Electrical Harness Plan'
        OUT stkldms_p13_pdid    VARCHAR,
        OUT stkldms_p14         VARCHAR, -- xtt27008 'P14 - Production CAD Export'
        OUT stkldms_p14_pdid    VARCHAR
        ) AS $$
      DECLARE r RECORD;
      BEGIN
        FOR r IN
            SELECT string_agg(pd_id, '; ' ORDER BY pd_id) AS pdid, string_agg(TSystem.Extract_FileName(pd_dokumentfile), '; ' ORDER BY pd_id) AS filename, pd_doktype
            FROM picndoku
            WHERE pd_dbrid = artdbrid
              AND pd_tablename = 'art'
              AND NOT pd_deletable
              AND (pd_parentnodeident IS NULL OR pd_parentnodeident NOT IN (16, 18, 21, 140)) -- ungültige Versionen ausschließen
              AND pd_doktype ~* E'p[0-9][0-9]\\.' -- nur P-Dokumente
            GROUP BY pd_doktype
        LOOP
            IF    r.pd_doktype = 'P00.cad.model' THEN
                stkldms_p00:=       r.filename;
                stkldms_p00_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P01.geometry.drawing' THEN
                stkldms_p01:=       r.filename;
                stkldms_p01_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P02.single.drawing' THEN
                stkldms_p02:=       r.filename;
                stkldms_p02_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P03.lamination.plan' THEN
                stkldms_p03:=       r.filename;
                stkldms_p03_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P04.assembly.drawing' THEN
                stkldms_p04:=       r.filename;
                stkldms_p04_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P05.exploded.drawing' THEN
                stkldms_p05:=       r.filename;
                stkldms_p05_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P06.wiring.diagram' THEN
                stkldms_p06:=       r.filename;
                stkldms_p06_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P07.design.parts.list' THEN
                stkldms_p07:=       r.filename;
                stkldms_p07_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P08.elec.comp.list' THEN
                stkldms_p08:=       r.filename;
                stkldms_p08_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P09.wiring.list' THEN
                stkldms_p09:=       r.filename;
                stkldms_p09_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P10.specification' THEN
                stkldms_p10:=       r.filename;
                stkldms_p10_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P11.block.diagram' THEN
                stkldms_p11:=       r.filename;
                stkldms_p11_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P12.work.qual.cplan' THEN
                stkldms_p12:=       r.filename;
                stkldms_p12_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P13.electrical.harness.plan' THEN
                stkldms_p13:=       r.filename;
                stkldms_p13_pdid:=  r.pdid;
            ELSIF r.pd_doktype = 'P14.production.cad.export' THEN
                stkldms_p14:=       r.filename;
                stkldms_p14_pdid:=  r.pdid;
            END IF;
        END LOOP;

        RETURN;
      END $$ LANGUAGE plpgsql STABLE STRICT;
    --

    -- Alle P-Dokumente eines Artikels zeilenweise
    CREATE OR REPLACE FUNCTION get_art_dokments__p00_rows(IN artdbrid VARCHAR, OUT pid VARCHAR, OUT ptype VARCHAR, OUT pfilename VARCHAR) RETURNS setof RECORD AS $$
      DECLARE r RECORD;
      BEGIN
        r:= get_art_dokments__p00(artdbrid);
        IF r.stkldms_p00 IS NOT NULL THEN
            ptype:=     'P00.cad.model';
            pid:=       r.stkldms_p00_pdid;
            pfilename:= r.stkldms_p00;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p01 IS NOT NULL THEN
            ptype:=     'P01.geometry.drawing';
            pid:=       r.stkldms_p01_pdid;
            pfilename:= r.stkldms_p01;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p02 IS NOT NULL THEN
            ptype:=     'P02.single.drawing';
            pid:=       r.stkldms_p02_pdid;
            pfilename:= r.stkldms_p02;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p03 IS NOT NULL THEN
            ptype:=     'P03.lamination.plan';
            pid:=       r.stkldms_p03_pdid;
            pfilename:= r.stkldms_p03;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p04 IS NOT NULL THEN
            ptype:=     'P04.assembly.drawing';
            pid:=       r.stkldms_p04_pdid;
            pfilename:= r.stkldms_p04;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p05 IS NOT NULL THEN
            ptype:=     'P05.exploded.drawing';
            pid:=       r.stkldms_p05_pdid;
            pfilename:= r.stkldms_p05;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p06 IS NOT NULL THEN
            ptype:=     'P06.wiring.diagram';
            pid:=       r.stkldms_p06_pdid;
            pfilename:= r.stkldms_p06;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p07 IS NOT NULL THEN
            ptype:=     'P07.design.parts.list';
            pid:=       r.stkldms_p07_pdid;
            pfilename:= r.stkldms_p07;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p08 IS NOT NULL THEN
            ptype:=     'P08.elec.comp.list';
            pid:=       r.stkldms_p08_pdid;
            pfilename:= r.stkldms_p08;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p09 IS NOT NULL THEN
            ptype:=     'P09.wiring.list';
            pid:=       r.stkldms_p09_pdid;
            pfilename:= r.stkldms_p09;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p10 IS NOT NULL THEN
            ptype:=     'P10.specification';
            pid:=       r.stkldms_p10_pdid;
            pfilename:= r.stkldms_p10;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p11 IS NOT NULL THEN
            ptype:=     'P11.block.diagram';
            pid:=       r.stkldms_p11_pdid;
            pfilename:= r.stkldms_p11;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p12 IS NOT NULL  THEN
            ptype:=     'P12.work.qual.cplan';
            pid:=       r.stkldms_p12_pdid;
            pfilename:= r.stkldms_p12;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p13 IS NOT NULL  THEN
            ptype:=     'P13.electrical.harness.plan';
            pid:=       r.stkldms_p13_pdid;
            pfilename:= r.stkldms_p13;
            RETURN NEXT;
        END IF;
        IF r.stkldms_p14 IS NOT NULL  THEN
            ptype:=     'P14.production.cad.export';
            pid:=       r.stkldms_p14_pdid;
            pfilename:= r.stkldms_p14;
            RETURN NEXT;
        END IF;

        RETURN;
      END $$ LANGUAGE plpgsql STABLE STRICT;
    --
--

-- [SYNCRO-TABLE] Tabelle für Hauptmenu erzeugen
CREATE TABLE mainmenu
 (mm_id                 SERIAL PRIMARY KEY,                                  -- interne statische ID [mm_stamp statt mm_id als SyncID hilft doppelt belegte IDs zu bemerken, da sie sich nicht hochladen lassen]
  mm_stamp              TIMESTAMP(0) UNIQUE NOT NULL DEFAULT currenttime(),  -- [SYNCRO:SyncID]
  mm_modified           TIMESTAMP(0),                                        -- [SYNCRO:Modified]
  mm_description        VARCHAR(50),
  mm_textNo             INTEGER,
  mm_parent             INTEGER,
  mm_posi               SMALLINT,
  mm_action             SMALLINT,
  mm_library            VARCHAR(50),
  mm_proc               VARCHAR(50),
  mm_shorthlptxtnr      INTEGER,
    mm_picture          LO,                                                  -- [ALT 2025-07-17: wegen Kompatiblit beibehalten, zum neuen mm_image]
  mm_image              BYTEA,
  mm_inheritedrights    BOOLEAN DEFAULT TRUE,                                -- [SYNCRO:NotThisFields]
  mm_hide               BOOLEAN DEFAULT FALSE,
  mm_bde                BOOLEAN DEFAULT FALSE,
  mm_system             BOOLEAN DEFAULT FALSE,
  mm_checkrights        BOOLEAN NOT NULL DEFAULT FALSE,                      -- [SYNCRO:NotThisFields]
  mm_formclassname      VARCHAR(75),
  mm_sql                TEXT,
  mm_macro              TEXT,                                                -- [SYNCRO:NotThisFields]
  mm_config             TEXT,
  mm_kunde              VARCHAR(20)                                          -- [SYNCRO:Deleted='DELETED']
 );

 CREATE INDEX mainmenu_posi ON mainmenu (mm_posi);
 CREATE INDEX mainmenu_mm_hide ON mainmenu (mm_hide) WHERE mm_hide;
 CREATE INDEX mainmenu_mm_kunde ON mainmenu (mm_kunde) WHERE mm_kunde IS NOT null;
 CREATE INDEX mainmenu_mm_parent ON mainmenu (mm_parent) WHERE mm_parent IS NOT null;

 -- ALT 2025-07-17: für Kompatibilität zwischen altem LargeObject und neuem BYTEA (alte/neue Prodats, Syncro und in SyncDB)
 CREATE OR REPLACE FUNCTION mainmenu_oldblob() RETURNS TRIGGER AS $$
   BEGIN
     BEGIN
       IF   ( (tg_op = 'UPDATE') AND (old.mm_image IS DISTINCT FROM new.mm_image) )
         OR ( (tg_op = 'INSERT') AND (new.mm_image IS NOT NULL) )
       THEN
         new.mm_picture := lo_from_bytea(0, new.mm_image);
         IF (tg_op = 'UPDATE') AND EXISTS(SELECT true FROM pg_largeobject WHERE loid = old.mm_picture) THEN
           PERFORM lo_unlink(old.mm_picture);
         END IF;
       ELSE
         IF   ( (tg_op = 'UPDATE') AND (old.mm_picture IS DISTINCT FROM new.mm_picture) )
           OR ( (tg_op = 'INSERT') AND (new.mm_picture IS NOT NULL) )
         THEN
           new.mm_image := lo_get(new.mm_picture);
         END IF;
       END IF;
     EXCEPTION
       WHEN others THEN
         null;
     END;

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER mainmenu_oldblob
     BEFORE INSERT OR UPDATE
     ON mainmenu
     FOR EACH ROW
     EXECUTE PROCEDURE mainmenu_oldblob();
 --

 CREATE OR REPLACE FUNCTION mainmenu_modified() RETURNS TRIGGER AS $$
  DECLARE temp RECORD;
  BEGIN
    IF NOT (current_user = 'syncro') then
      IF tg_op = 'INSERT' THEN
        new.mm_modified := currenttime();
      END IF;
      IF tg_op = 'UPDATE' THEN
        -- Diese Felder für die Syncro (Synchro-Modified-Date) ignorieren.
        --
        temp := new;
        temp.modified_by        := old.modified_by;
        temp.modified_date      := old.modified_date;
        --
        temp.mm_macro           := old.mm_macro;
        temp.mm_inheritedrights := old.mm_inheritedrights;
        temp.mm_checkrights     := old.mm_checkrights;
        --
        IF old IS DISTINCT FROM temp THEN  -- eines der anderen Felder wurde verändert
          new.mm_modified := currenttime();
        END IF;
      END IF;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER mainmenu_modified
   BEFORE UPDATE
   ON mainmenu
   FOR EACH ROW
   EXECUTE PROCEDURE mainmenu_modified();

CREATE TABLE mainmenurights
 (mmr_id                SERIAL PRIMARY KEY,
  mmr_mm_id             INTEGER NOT NULL REFERENCES mainmenu ON DELETE CASCADE,
  mmr_username          VARCHAR,
  mmr_allow             BOOL DEFAULT true,
  mmr_readonly          BOOL DEFAULT false
 );

 CREATE INDEX mainmenurights__mm_id ON mainmenurights(mmr_mm_id);
 CREATE INDEX mainmenurights__mm_username ON mainmenurights(mmr_username);

 CREATE OR REPLACE FUNCTION mainmenurights__a_iud() RETURNS TRIGGER AS $$
  DECLARE mmrmmid INTEGER;
    BEGIN
     IF TG_OP = 'DELETE' THEN
            mmrmmid:=old.mmr_mm_id;
     ELSE
            mmrmmid:=new.mmr_mm_id;
            IF new.mmr_readonly THEN
                    new.mmr_allow:=True;
            END IF;
     END IF;
     UPDATE public.mainmenu SET mm_checkrights=EXISTS(SELECT true FROM mainmenurights WHERE mmr_mm_id=mmrmmid) WHERE mm_id=mmrmmid AND mm_checkrights<>EXISTS(SELECT true FROM mainmenurights WHERE mmr_mm_id=mmrmmid);
     RETURN new;
    END $$ language plpgsql;

  CREATE TRIGGER mainmenurights__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON mainmenurights
    FOR EACH ROW
    EXECUTE PROCEDURE mainmenurights__a_iud();

 CREATE UNIQUE INDEX mainmenurights_mmid_user ON mainmenurights (mmr_mm_id, mmr_username);

/*NutzerButtons*/

CREATE TABLE userbuttons
 (usrbt_id              serial PRIMARY KEY,
  usrbt_mm_id           integer,/* REFERENCES mainmenu, MenuKnopf*/
  usrbt_order           integer,
  usrbt_isseperator     bool DEFAULT FALSE,
  usrbt_user            varchar(30) DEFAULT TSystem.current_user_ll_db_usename(TRUE)
 );

/*Tabelle in der Designte Forms gespeichert ist*/

-- [SYNCRO-TABLE] RTFs
-- TODO FS 2019-06-19: warum rtf_id nicht als SERIAL PRIMARY KEY, wie im mainmenu?
CREATE TABLE runtimeforms
 (rtf_id                integer PRIMARY KEY,                                  -- interne statische ID [rtf_stamp statt rtf_id als SyncID hilft doppelt belegte IDs zu bemerken, da sie sich nicht hochladen lassen]
  rtf_stamp             timestamp(0)  UNIQUE NOT NULL DEFAULT currenttime(),  -- [SYNCRO:SyncID]
  rtf_modified          timestamp(0),                                         -- [SYNCRO:Modified]
  rtf_table             varchar(30),                                          -- [SYNCRO:Deleted='DELETED']
  rtf_txtnr             integer,
  rtf_shorthlptxtnr     integer,
  rtf_text              text,
  rtf_textdfm           text,
  rtf_script            text,                                                 -- Python3-Scripts
  rtf_blanksql          bool,
  rtf_changetext        text,
  rtf_runtimeform       bool DEFAULT FALSE,
  rtf_localmodified     bool DEFAULT FALSE,                                   -- [SYNCRO:NotThisFields]   nicht implementiert (Trigger fehlt und daher aktuell in USyncro auskommentiert)
  rtf_standard          bool DEFAULT FALSE,
  rtf_webform_sql       text,
  rtf_webform_rest      text,
  rtf_config            text
 );

 CREATE OR REPLACE FUNCTION runtimeforms_modified() RETURNS TRIGGER AS $$
    BEGIN
     IF NOT (current_user='syncro') then
            new.rtf_modified:=currenttime();
            PERFORM TSystem.Settings__Set('rtfmodified', 'T');
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;

  CREATE TRIGGER runtimeforms_modified
    BEFORE UPDATE
    ON runtimeforms
    FOR EACH ROW
    EXECUTE PROCEDURE runtimeforms_modified();

/*F2-Datenbanken erzeugen*/

-- Lizensen für Sondermodule. Bsp: Plantafel oder BusinessIntelligence (BI)
CREATE TABLE lizenzedmodules
 (lzm_modclassname      varchar(100) PRIMARY KEY,
  lzm_auslaufdat        date
 );

CREATE TABLE DataRowState ( --(#5617)
  drs_id                serial PRIMARY KEY,
  drs_type              varchar(100),       -- 'auftg'
  drs_code              varchar(10),        -- Codierung des Status bei Rückgabe z.Bsp. 'sOffen' oder 'sDone' oder 'sStorno'
  drs_sort              integer,
  drs_filtersql         varchar(100),       -- Direktangabe eines SQL Filters
  drs_textnr            integer,             -- Überschrift des Registers z.Bsp. 'Offen' oder 'Verspätet'
  drs_defRegister       boolean DEFAULT FALSE
 );

-- [SYNCRO-TABLE] StandardF2
-- TODO : f2s_stamp entfernen und f2s_name als SyncID  -> immer wieder Probleme mit mehreren konkurrierenden UNIQUE-Feldern in der Syncro
CREATE TABLE f2standard (
  f2s_stamp             timestamp(0) UNIQUE NOT NULL DEFAULT currenttime(), -- [SYNCRO:SyncID]
  f2s_name              integer NOT NULL PRIMARY KEY,                       -- TEXT NR
  f2s_modified          timestamp(0),                                       -- [SYNCRO:Modified]
  f2s_table             varchar(50),
  f2s_StandardSuche     boolean DEFAULT false,
  f2s_regConfig         text,
  f2s_query             text,
  f2s_querysub          text,
  f2s_deleted           boolean NOT NULL DEFAULT false,
  wherescript           integer REFERENCES runtimeforms ON UPDATE CASCADE,
  f2s_drstype           varchar(100)                                        -- drs_type aus DataRowState (#5617)
);

--
CREATE OR REPLACE FUNCTION f2standard_modified() RETURNS TRIGGER AS $$
  BEGIN
    IF NOT (current_user = 'syncro') THEN
        new.f2s_modified:=currenttime();
        PERFORM TSystem.Settings__Set('f2standardmofidied', 'T');
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER f2standard_modified
    BEFORE UPDATE
    ON f2standard
    FOR EACH ROW
    EXECUTE PROCEDURE f2standard_modified();
--

-- [SYNCRO-TABLE] F2
CREATE TABLE f2poss (
  f2_id                 serial PRIMARY KEY,                                   -- [SYNCRO:NotThisFields]
  f2_stamp              timestamp(0) UNIQUE NOT NULL DEFAULT currenttime(),   -- [SYNCRO:SyncID]
  f2_loadall            boolean DEFAULT false,
  f2_standard           integer CONSTRAINT f2poss_f2standard REFERENCES f2standard ON DELETE RESTRICT ON UPDATE CASCADE,  -- f2standard.f2s_name = text0    (sollte jetzt besser "f2_standardf2" heißen)
  f2_standardsql        varchar(100) /*CONSTRAINT f2poss_f2standardsql REFERENCES systemsqlstatement (sql_name)*/,        -- nicht, weil gibt keinen UNIQUE-Index auf dieser Spalte
  f2_query              text,
  f2_querysub           text,                                                 -- subquery, zB Arbeitsgänge zur AVOR
  f2_macro              text,                                                 -- [SYNCRO:NotThisFields] kundenspezifische Makros
  -- f2_customize          text,                                              -- alt
  -- f2_uniquekey          VARCHAR,                                           -- alt
  feldname              varchar,
  modulname             varchar,
  vartxtnr              integer,                                              -- text NR
  pos                   smallint,
  f2_filter             varchar,
  runtimeforms          integer REFERENCES runtimeforms ON UPDATE CASCADE,
  fastf2                boolean DEFAULT false,
  f2_previewfield       varchar(50),
  f2_kunde              varchar(50),                                          -- [SYNCRO:Kunde] [SYNCRO ALT:Deleted='DELETED']
  f2_modified           timestamp(0) DEFAULT currenttime(),                   -- [SYNCRO:Modified]
  --syncpcsftp          boolean,                                              -- Alt
  f2_deactrtf           boolean,
  f2_simple             boolean,
  f2_dropdownmodules    text,                                                 -- Verlinkung zu Modulen
  f2_deleted            boolean DEFAULT false,                                -- [SYNCRO:Deleted]
  f2_localmodified      boolean DEFAULT false,                                -- [SYNCRO:NotThisFields]
  f2_changetext         text,                                                 -- Änderungshinweise
  f2_searchedit         varchar,                                              -- Aus diesem Editfeld soll das :SearchEd gefuellt werden
  f2_autosearch         boolean DEFAULT false,                                -- Nach dem SearchEd fuellen automatisch suchen oder Nutzerinteraktion abwarten?
  f2_standardadresss    boolean NOT NULL DEFAULT false,
  f2_groupname          varchar(100),                                         -- gruppe: lag, rechnung, etc => FieldAlias
  f2_config             text,
  f2_drstype            varchar(100)                                          -- drs_type aus DataRowState (#5617)
);

-- Indizes
  CREATE UNIQUE INDEX f2poss_fastf2 ON f2poss(modulname, feldname, fastf2) WHERE fastf2 AND NOT f2_deleted;

  CREATE INDEX f2poss_modulname_upper ON f2poss(upper(modulname));
  CREATE INDEX f2poss_modulname_upper_aeoeue ON f2poss(AEOEUE_UPPER(modulname));
  CREATE INDEX modulname ON f2poss(modulname, feldname);
--

-- DELETE rule
CREATE OR REPLACE RULE f2poss_delete AS
  ON DELETE
  TO f2poss
  WHERE current_user <> 'syncro'
  DO INSTEAD
    UPDATE f2poss SET f2_deleted = true WHERE f2_id = old.f2_id;
--

--
CREATE OR REPLACE FUNCTION f2posschange() RETURNS TRIGGER AS $$
  DECLARE temp RECORD;
  BEGIN
    IF NOT (current_user = 'syncro') THEN
        IF TG_OP = 'INSERT' THEN
            new.f2_modified := currenttime();
            new.f2_localmodified := true;
        END IF;
        IF TG_OP = 'UPDATE' THEN
            -- Diese Felder für die Syncro (Synchro-Modified-Date) ignorieren.
            -- z.B. eine Änderung von f2_macro aktualisiert das modified_date, da es aber nicht synchronisiert wird, soll es nicht die Synchronisation veranlassen.
            --
            temp := new;
            temp.modified_by   := old.modified_by;
            temp.modified_date := old.modified_date;
            --
            temp.f2_macro      := old.f2_macro;
            IF old IS DISTINCT FROM temp THEN
                new.f2_modified := currenttime();
                new.f2_localmodified := true;
            END IF;
        END IF;
    ELSE
        new.f2_localmodified := false; -- local aktualisieren durch Syncro.
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER f2posschange
    BEFORE UPDATE
    ON f2poss
    FOR EACH ROW
    EXECUTE PROCEDURE f2posschange();
--

-- [SYNCRO-TABLE] F2-RückFields
CREATE TABLE f2rck
 (f2r_id                serial PRIMARY KEY,  -- [SYNCRO:NotThisFields]
  f2r_f2_id             integer NOT NULL CONSTRAINT f2rck_f2poss REFERENCES f2poss ON UPDATE CASCADE ON DELETE CASCADE,  -- [SYNCRO:TranslateToLocal]
  f2r_f2_stamp          timestamp(0) REFERENCES f2poss (f2_stamp)                  ON UPDATE CASCADE ON DELETE CASCADE,
  f2r_pos               integer,      -- Reihenfolge der Abarbeitung
  f2r_f2rckfieldn       varchar(25),  -- Quellfeld im F2
  f2r_forcomponent      varchar(50),  -- Zielkomponente ("Name", "Self", "Self.Name", "Name.SubName")
  f2r_forfield          varchar(50)   -- Zielfeld im TDataSet/TCimQuery2/TCimClass/TServSql ("FieldName")
                                      -- ODER Methode der Zielkomponente ausführen ("Methode()" > f2r_f2rckfieldn wird nicht benötigt)
 );
---
    CREATE OR REPLACE FUNCTION f2rck__f2r_f2_stamp__b_iu() RETURNS TRIGGER
      AS $$
      BEGIN
        -- lokale f2_id übersetzen
        IF new.f2r_f2_stamp IS null THEN -- Anlage aus Delphi
           new.f2r_f2_stamp := f2_stamp FROM f2poss WHERE f2_id = new.f2r_f2_id;
        END IF;
        --
        new.f2r_f2_id := f2_id FROM f2poss WHERE f2_stamp = new.f2r_f2_stamp;
        --
        RETURN new;
      END $$ LANGUAGE plpgsql;

    CREATE TRIGGER f2rck__f2r_f2_stamp__b_iu
     BEFORE INSERT OR UPDATE
     ON f2rck
     FOR EACH ROW
     EXECUTE PROCEDURE f2rck__f2r_f2_stamp__b_iu();

    CREATE OR REPLACE FUNCTION f2rck_modified() RETURNS TRIGGER AS $$
      BEGIN
        -- wir lösen hiermit auch den AfterUpdateTrigger an F2Poss aus
        UPDATE f2poss
           SET f2_modified = currenttime()
         WHERE f2_id = new.f2r_f2_id
           AND NOT (current_user = 'syncro');

        RETURN new;
      END $$ LANGUAGE plpgsql;

    CREATE TRIGGER f2rck_modified
      BEFORE INSERT OR UPDATE
      ON f2rck
      FOR EACH ROW
      EXECUTE PROCEDURE f2rck_modified();


    CREATE OR REPLACE FUNCTION f2rck_deleted() RETURNS TRIGGER AS $$
      BEGIN
        -- wir lösen hiermit auch den AfterDeleteTrigger an F2Poss aus
        UPDATE f2poss
           SET f2_modified = currenttime()
         WHERE f2_id = new.f2r_f2_id
           AND NOT (current_user = 'syncro');

        RETURN old;
      END $$ LANGUAGE plpgsql;

    CREATE TRIGGER f2rck_deleted
      AFTER DELETE
      ON f2rck
      FOR EACH ROW
      EXECUTE PROCEDURE f2rck_deleted();


CREATE TABLE f2order
 (f2o_id                SERIAL PRIMARY KEY,
  f2o_f2_stamp          TIMESTAMP(0) REFERENCES f2poss(f2_stamp) ON DELETE CASCADE,
  f2o_pos               INTEGER,
  f2o_deact             BOOLEAN DEFAULT FALSE
 );


-- http://redmine.prodat-sql.de/issues/5903
-- Ist Auftragsbestätigung?
CREATE OR REPLACE FUNCTION auftg_is_AB(IN dokunr INTEGER) RETURNS BOOLEAN AS $$
 DECLARE r  RECORD;
  BEGIN
    SELECT ag_astat, ag_pos, ag_dokunr, ag_ldatum, atd_empdat, atd_emptxt INTO r FROM auftg JOIN auftgdokutxt ON ag_dokunr=atd_dokunr WHERE ag_dokunr=dokunr ORDER BY ag_pos LIMIT 1;
    --
    IF (r.ag_astat='E' AND r.ag_pos>0 AND r.ag_ldatum IS NOT NULL) OR (r.ag_astat='E' AND r.ag_pos=0) OR (r.ag_astat='R' AND r.ag_pos=1) THEN
      RETURN TRUE; -- AB
    END IF;

    -- Die Empfangsbest-felder sind gefüllt und Auftrag (nicht Rahmen) hat keinen best. Liefertermin
    IF ( (r.atd_empdat IS NOT NULL) OR (r.atd_emptxt <> '') ) AND (r.ag_astat='E' AND r.ag_pos>0 AND r.ag_ldatum IS NULL) THEN
      RETURN FALSE; -- Empfbstg
    END IF;

    RETURN NULL; -- Nicht Empfbstg, Nicht AB

  END $$ LANGUAGE plpgsql STABLE STRICT;
--


-- [SYNCRO-TABLE] Tabelle für Sonderfunktionen
CREATE TABLE sondfunc
 (sf_id                 SERIAL PRIMARY KEY,                                  -- [SYNCRO:NotThisFields]
  sf_stamp              TIMESTAMP(0) NOT NULL UNIQUE DEFAULT currenttime(),  -- [SYNCRO:SyncID]
  sf_modified           TIMESTAMP(0),                                        -- [SYNCRO:Modified]
  sf_sqltable           VARCHAR(50),
  sf_formclass          VARCHAR(75),
  sf_nr                 INTEGER,
  sf_imageIndex         INTEGER,
  sf_rtf                INTEGER REFERENCES runtimeforms ON UPDATE CASCADE,
  sf_txtnr              INTEGER,
  sf_hinttxtnr          INTEGER,
  sf_cond               TEXT,
  sf_emptyallowed       BOOLEAN DEFAULT False,
  sf_SQL                TEXT,
  sf_menuButton         BOOLEAN DEFAULT false,
  sf_config             TEXT
 );


    CREATE OR REPLACE FUNCTION sondfunc_modified() RETURNS TRIGGER AS $$
    BEGIN
     IF NOT (current_user='syncro') then
            new.sf_modified:=currenttime();
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER sondfunc_modified
    BEFORE INSERT OR UPDATE
    ON sondfunc
    FOR EACH ROW
    EXECUTE PROCEDURE sondfunc_modified();


-- [SYNCRO-TABLE] StandardSQL
CREATE TABLE systemsqlstatement
(sql_stamp              TIMESTAMP(0) NOT NULL PRIMARY KEY DEFAULT currenttime(),  -- [SYNCRO:SyncID]
 sql_modified           TIMESTAMP(0),                   -- [SYNCRO:Modified]
 sql_name               VARCHAR(100) NOT NULL,
 sql_descr              TEXT,                           -- Zusatzinformation
 sql_sql                TEXT,                           -- SQL Statement
 sql_sqlselect          TEXT,                           -- Select-Statement für TServersideSQL (sql_sql: SQL Statement für MATERIALIZED VIEW)
 sql_macro              TEXT,                           -- [SYNCRO:NotThisFields] kundenspezifische Makros
 sql_minver             VARCHAR(11),                    -- [SYNCRO:Version]
 sql_deleted            BOOLEAN NOT NULL DEFAULT False  -- [SYNCRO:Deleted]
 );

CREATE INDEX systemsqlstatement_name ON systemsqlstatement (sql_name);
CREATE UNIQUE INDEX systemsqlstatement_name_minver ON systemsqlstatement (sql_name, COALESCE(sql_minver, '')) WHERE NOT sql_deleted;

CREATE OR REPLACE FUNCTION systemsqlstatement_modified() RETURNS TRIGGER AS $$
  DECLARE temp RECORD;
  BEGIN
    IF current_user <> 'syncro' THEN
        IF TG_OP = 'INSERT' THEN
            new.sql_modified := currenttime();
        END IF;
        IF TG_OP = 'UPDATE' THEN
            -- Diese Felder für die Syncro (Synchro-Modified-Date) ignorieren.
            -- z.B. eine Änderung von sql_macro aktualisiert das modified_date, da es aber nicht synchronisiert wird, soll es nicht die Synchronisation veranlassen.
            --
            temp := new;
            temp.modified_by   := old.modified_by;
            temp.modified_date := old.modified_date;
            --
            temp.sql_macro     := old.sql_macro;
            IF old IS DISTINCT FROM temp THEN
                new.sql_modified := currenttime();
                --PERFORM PRODAT_TEXT(E'>UPDATEx \n' || old::VARCHAR(500) || E'\n' || temp::VARCHAR(500));
            END IF;
        END IF;
    END IF;

    -- Macro aus vorhergehenden Version kopieren, um Kundenspezifika zu erhalten.
    -- https://redmine.prodat-sql.de/issues/14285
    IF TG_OP = 'INSERT' AND new.sql_macro IS NULL THEN

        new.sql_macro := sql_macro FROM systemsqlstatement_current WHERE sql_name = new.sql_name;

        IF new.sql_macro IS NOT NULL THEN
            RAISE NOTICE 'sql_macro für % wurde in neue Statement-Version übernommen', new.sql_name;
        END IF;
    END IF;

    IF TG_OP = 'UPDATE' AND current_user <> 'syncro'
        AND new.sql_sql IS DISTINCT FROM old.sql_sql
        AND new.sql_minver IS NOT DISTINCT FROM old.sql_minver
        AND new.sql_minver IS DISTINCT FROM TSystem.Settings__Get('ProdatVersion')
    THEN
        -- StandardSQL wurde geändert. Mindestversion anpassen? ....
        PERFORM PRODAT_MESSAGE_YES_NO(replace(replace(lang_text(26063),
                                                      '%ALT%', coalesce(old.sql_minver, '')
                                                      ),
                                              '%NEU%', coalesce(TSystem.Settings__Get('ProdatVersion'), '')
                                              ),
                                      'Message.SystemSqlStatement.MinVersAnpassen.Yes',
                                      'Message.SystemSqlStatement.MinVersAnpassen.No',
                                      old.dbrid
                                      );
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER systemsqlstatement_modified
   BEFORE INSERT OR UPDATE OF sql_name, sql_descr, sql_sql, sql_sqlselect, sql_deleted
   ON systemsqlstatement
   FOR EACH ROW
   EXECUTE PROCEDURE systemsqlstatement_modified();

-- Nur aktive Statements > nicht gelöscht und nur die aktuellst mögliche Version (Filter entsprechend der Datenbank-Version)
-- TODO FS 06.03.2018 : VIEW kann weg, wenn keine "alten" Prodats 12.0.x.x bis 12.7.x.x mehr existieren
--                      ACHTUNG: TSystem.views__all__create() und TSystem.views__all__drop() anpassen.
CREATE OR REPLACE VIEW systemsqlstatement_current AS
  SELECT *
  FROM systemsqlstatement
  WHERE NOT sql_deleted
    AND NOT EXISTS(SELECT true  -- existiert eine neuere Version?
      FROM systemsqlstatement AS x
      WHERE x.sql_name = systemsqlstatement.sql_name
        AND NOT x.sql_deleted
        AND COALESCE(x.sql_minver, '') <= TSystem.Settings__Get('ProdatVersion')
        AND COALESCE(x.sql_minver, '') > COALESCE(systemsqlstatement.sql_minver, ''))
    AND COALESCE(sql_minver, '') <= TSystem.Settings__Get('ProdatVersion');
--

-- Nur aktive Statements > nicht gelöscht und nur die aktuellst mögliche Version
-- SELECT * FROM systemsqlstatement_version(:ProdatClientVersion)   -- clientseitiger AutoParam (TCimQuery2.FillSysParams)
-- SELECT * FROM systemsqlstatement_version(&ProdatClientVersion)   -- passende StandardSQL für die eigene Prodat-Programm-Version
CREATE OR REPLACE FUNCTION systemsqlstatement_version(ProdatClientVersion VARCHAR) RETURNS SETOF systemsqlstatement AS $$
  SELECT *
  FROM systemsqlstatement
  WHERE NOT sql_deleted
    AND NOT EXISTS(SELECT true  -- existiert eine neuere Version?
      FROM systemsqlstatement AS x
      WHERE x.sql_name = systemsqlstatement.sql_name
        AND NOT x.sql_deleted
        AND COALESCE(x.sql_minver, '') <= ProdatClientVersion
        AND COALESCE(x.sql_minver, '') > COALESCE(systemsqlstatement.sql_minver, ''))
    AND COALESCE(sql_minver, '') <= ProdatClientVersion
  $$ LANGUAGE sql STABLE;
--

/* FS 06.03.2018 wird schon eine Weile nirgends mehr benutzt
-- SystemSQL ausführen und einen Ergebniswert zurückgeben (erstes Feld im SQL)
    CREATE OR REPLACE FUNCTION StandardSQL_LoadInt(SqlName VARCHAR) RETURNS INTEGER AS $$
    DECLARE result INTEGER;
    BEGIN
      EXECUTE sql_sql FROM systemsqlstatement_version(TSystem.Settings__Get('ProdatVersion'))
        WHERE sql_name = SqlName INTO result;
      RETURN result;
    END $$ LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION StandardSQL_LoadInt(SqlName VARCHAR, Param INTEGER) RETURNS INTEGER AS $$
    DECLARE result INTEGER;
    BEGIN
      EXECUTE sql_sql FROM systemsqlstatement_version(TSystem.Settings__Get('ProdatVersion'))
        WHERE sql_name = SqlName USING $2 INTO result;
      RETURN result;
    END $$ LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION StandardSQL_LoadInt(SqlName VARCHAR, Param VARCHAR) RETURNS INTEGER AS $$
    DECLARE result INTEGER;
    BEGIN
      EXECUTE sql_sql FROM systemsqlstatement_version(TSystem.Settings__Get('ProdatVersion'))
        WHERE sql_name = SqlName USING $2 INTO result;
      RETURN result;
    END $$ LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION StandardSQL_LoadInt(SqlName VARCHAR, Param VARCHAR, Param2 VARCHAR) RETURNS INTEGER AS $$
    DECLARE result INTEGER;
    BEGIN
      EXECUTE sql_sql FROM systemsqlstatement_version(TSystem.Settings__Get('ProdatVersion'))
        WHERE sql_name = SqlName USING $2, $3 INTO result;
      RETURN result;
    END $$ LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION StandardSQL_LoadStr(SqlName VARCHAR) RETURNS VARCHAR AS $$
    DECLARE result VARCHAR;
    BEGIN
      EXECUTE sql_sql FROM systemsqlstatement_version(TSystem.Settings__Get('ProdatVersion'))
        WHERE sql_name = SqlName INTO result;
      RETURN result;
    END $$ LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION StandardSQL_LoadStr(SqlName VARCHAR, Param INTEGER) RETURNS VARCHAR AS $$
    DECLARE result VARCHAR;
    BEGIN
      EXECUTE sql_sql FROM systemsqlstatement_version(TSystem.Settings__Get('ProdatVersion'))
        WHERE sql_name = SqlName USING $2 INTO result;
      RETURN result;
    END $$ LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION StandardSQL_LoadStr(SqlName VARCHAR, Param VARCHAR) RETURNS VARCHAR AS $$
    DECLARE result VARCHAR;
    BEGIN
      EXECUTE sql_sql FROM systemsqlstatement_version(TSystem.Settings__Get('ProdatVersion'))
        WHERE sql_name = SqlName USING $2 INTO result;
      RETURN result;
    END $$ LANGUAGE plpgsql;

    CREATE OR REPLACE FUNCTION StandardSQL_LoadStr(SqlName VARCHAR, Param VARCHAR, Param2 VARCHAR) RETURNS VARCHAR AS $$
    DECLARE result VARCHAR;
    BEGIN
      EXECUTE sql_sql FROM systemsqlstatement_version(TSystem.Settings__Get('ProdatVersion'))
        WHERE sql_name = SqlName USING $2, $3 INTO result;
      RETURN result;
    END $$ LANGUAGE plpgsql;
*/

-- Macro-Definitionen aus einem Text Text auslesen
CREATE OR REPLACE FUNCTION TSystem.systemsqlstatement__macros__parse(
    _macros_text text
  )
  RETURNS TABLE (
    macro_name  text,
    macro_value text
  )
  AS $$
  DECLARE
    macro_lines   text[];
    current_line  text;
    i             integer := 1;
    trimmed_line  text;
    eq_position   integer;
  BEGIN

    -- Text in einzelne Zeilen aufteilen
    macro_lines := string_to_array( trim( _macros_text ), E'\n' );

    -- Schleife über alle Zeilen
    WHILE i <= array_length( macro_lines, 1 ) LOOP
      -- Zeile trimmen und prüfen, ob sie nicht leer ist
      current_line := trim( macro_lines[i] );
      IF current_line = '' THEN
          i := i + 1;
          CONTINUE;
      END IF;

      -- Prüfen, ob die Zeile ein Makro enthält (Name=Value)
      eq_position = position( '=' in current_line );
      IF eq_position > 0 THEN
        -- Makroname und Wert trennen und trimmen
        macro_name  := trim(   left( current_line, eq_position - 1 ) );
        macro_value := trim( substr( current_line, eq_position + 1 ) );

        -- Mehrzeiliges auflösen, falls vorhanden
        WHILE i < array_length( macro_lines, 1 ) AND position( '=' IN trim( macro_lines[i + 1] ) ) = 1 LOOP
          i := i + 1;
          macro_value := macro_value || E'\n' || trim( substr( macro_lines[i] , 2 ) );
        END LOOP;

        -- Makros zurückgeben
        RETURN NEXT;
      END IF;
      i := i + 1;
    END LOOP;

  END $$ LANGUAGE plpgsql IMMUTABLE STRICT PARALLEL SAFE;


-- Standard-SQL inkl. Makro-Erweiterungen ausgeben
CREATE OR REPLACE FUNCTION tsystem.systemsqlstatement__query(
    standard_sql_name varchar,
    macro             jsonb DEFAULT null  -- JSON Array mit optionalen Makro-Definitionen
  )
  RETURNS text
  AS $$
  DECLARE
    _sql_result        text;
    _macro_definitions text;
    _macro             record;
    _macro_json        jsonb;
  BEGIN
    -- Lade Standard-SQL
    SELECT sql_sql, sql_macro
      INTO _sql_result, _macro_definitions
      FROM systemsqlstatement_current
     WHERE sql_name = standard_sql_name;

    IF NOT FOUND THEN
      RAISE EXCEPTION 'Standard-SQL % not found', standard_sql_name;
    END IF;

    -- Verarbeite die Makro-Definitionen aus Standard-SQLs
    IF macro IS NOT NULL THEN
      FOR _macro_json IN ( SELECT jsonb_array_elements(macro) )
      LOOP
        _sql_result := replace( _sql_result, _macro_json ->> 'macro_name', _macro_json ->> 'macro_value' );
      END LOOP;
    END IF;

    -- Verarbeite die Makro-Definitionen aus Standard-SQLs
    FOR _macro IN ( SELECT * FROM TSystem.systemsqlstatement__macros__parse( _macro_definitions ) )
    LOOP
      _sql_result := replace( _sql_result, _macro.macro_name, _macro.macro_value );
    END LOOP;

    -- Alle verbleibenden Macros mit _auto gegen Leerstring ersetzen
    _sql_result := regexp_replace(_sql_result, '(&[A-Za-z0-9_]+_auto)', '', 'g');

    RETURN _sql_result;

  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;


-- Funktion zum Ausführen eines SQL-Statements und Rückgabe als JSON Array
CREATE OR REPLACE FUNCTION tsystem.sql_query__execute__to_jsonb_array(
    query_text text,
    param_map  jsonb DEFAULT null -- JSON-Objekt mit Parametern
  )
  RETURNS jsonb
  AS $$
  DECLARE
    final_query text;
    result      jsonb;
    key         text;
  BEGIN
    -- Wir beginnen mit dem ursprünglichen Query-Text
    final_query := query_text;

    -- Für jedes Schlüssel–Wert-Paar im JSON param_map
    -- ersetzen wir im query_text :KEY durch den passenden Wert.
    FOR key IN
        SELECT jsonb_object_keys(param_map)
    LOOP

      final_query := replace(
          final_query,
          ':' || key,                                 -- Platzhalter :KEY
          quote_literal(param_map ->> key)     -- entsprechender Wert, sicher gequotet
      );
    END LOOP;

    -- Dynamische Ausführung des zusammengesetzten SQL-Statements
    EXECUTE format(
        'SELECT jsonb_agg(to_jsonb(sub)) FROM (%s) sub',
        final_query
    )
    INTO result;

    RETURN result;

  END $$ LANGUAGE plpgsql;

-- Funktion zum Ausführen eines SQL-Statements und Rückgabe als JSON Set
CREATE OR REPLACE FUNCTION tsystem.sql_query__execute__to_jsonb_set(
    query_text text,
    param_map  jsonb DEFAULT null
  )
  RETURNS SETOF jsonb  -- <- liefert mehrere Zeilen, pro Zeile ein JSON-Objekt
  AS $$

    -- erste Funktion aufrufen und deren JSON-Array in einzelne Zeilen aufteilen.
    SELECT jsonb_array_elements(
      tsystem.sql_query__execute__to_jsonb_array( query_text, param_map )
    );

  $$ LANGUAGE sql;


-- [SYNCRO-TABLE] Merkmale und Einstellung BI-Modul
CREATE TABLE olapbisettings
 (obi_stamp             TIMESTAMP(0) NOT NULL UNIQUE DEFAULT currenttime(),  -- [SYNCRO:SyncID]
  obi_modified          TIMESTAMP(0),                   -- [SYNCRO:Modified]
  obi_id                SERIAL PRIMARY KEY,             -- [SYNCRO:NotThisFields]
  obi_name              VARCHAR(50) NOT NULL,           -- Kennung wo (z.B. Modulname)
  obi_default           BOOL NOT NULL DEFAULT False,    -- [SYNCRO:NotThisFields] Standardanzeige beim Laden
  obi_pos               INTEGER,
  obi_bez               VARCHAR(100) NOT NULL,          -- Bezeichnung z.B. "Auswertung nach XYZ"
  obi_txt               TEXT,                           -- Beschreibung
  obi_all               BOOL NOT NULL DEFAULT True,     -- Nur für mich, oder automatisch für alle
  obi_system_sync       BOOL NOT NULL DEFAULT False,    -- systemstatement von prodat-sql, anwender kanns nicht verändern (nur superadmin), wird gesynct
    obi_data            LO,                             -- [ALT 2025-07-17: wegen Kompatiblit beibehalten, zum neuen obi_config]
  obi_config            BYTEA
 );

 -- ALT 2025-07-17: für Kompatibilität zwischen altem LargeObject und neuem BYTEA (alte/neue Prodats, Syncro und in SyncDB)
 CREATE OR REPLACE FUNCTION olapbisettings_oldblob() RETURNS TRIGGER AS $$
   BEGIN
     BEGIN
       IF   ( (tg_op = 'UPDATE') AND (old.obi_config IS DISTINCT FROM new.obi_config) )
         OR ( (tg_op = 'INSERT') AND (new.obi_config IS NOT NULL) )
       THEN
         new.obi_data := lo_from_bytea(0, new.obi_config);
         IF (tg_op = 'UPDATE') AND EXISTS(SELECT true FROM pg_largeobject WHERE loid = old.obi_data) THEN
           PERFORM lo_unlink(old.obi_data);
         END IF;
       ELSE
         IF   ( (tg_op = 'UPDATE') AND (old.obi_data IS DISTINCT FROM new.obi_data) )
           OR ( (tg_op = 'INSERT') AND (new.obi_data IS NOT NULL) )
         THEN
           new.obi_config := lo_get(new.obi_data);
         END IF;
       END IF;
     EXCEPTION
       WHEN others THEN
         null;
     END;

     RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER olapbisettings_oldblob
     BEFORE INSERT OR UPDATE
     ON olapbisettings
     FOR EACH ROW
     EXECUTE PROCEDURE olapbisettings_oldblob();
 --

CREATE UNIQUE INDEX olapbisettings__obi_name__obi_default ON olapbisettings (obi_name, obi_default) WHERE obi_default;

CREATE OR REPLACE FUNCTION olapbisettings_modified() RETURNS TRIGGER AS $$
BEGIN
 IF NOT (current_user='syncro') then
        IF tg_op='INSERT' THEN
                new.obi_modified:=currenttime();
        END IF;
        IF tg_op='UPDATE' AND new.obi_default=old.obi_default THEN--obi_default wird aus der overfläche immer als einzelfeld aktualisiert
                new.obi_modified:=currenttime();
        END IF;
 END IF;
 RETURN new;
END $$ LANGUAGE plpgsql;

CREATE TRIGGER olapbisettings_modified
BEFORE INSERT OR UPDATE
ON olapbisettings
FOR EACH ROW
EXECUTE PROCEDURE olapbisettings_modified();

-- create table settings in
-- 0 Functions prodat_languages.sql
-- ausnahme


-- [SYNCRO-TABLE] dynamische Setttings
-- TODO 2019-06 : SyncID = sd_name
--                sd_id = SERIAL PRIMARY KEY [SYNCRO:NotThisFields]
--                sd_name = VARCHAR(100) statt VARCHAR
--                sd_name = NOT NULL UNIQUE   > doppelte Namen durch angehängte Leerzeichen (sd_vartxtnr=NULL) oder angehängte _Nummern (sd_vartxtnr>0) bereinigen
CREATE TABLE SettingsDyn (
  sd_id           INTEGER PRIMARY KEY CHECK (sd_id > 0),  -- [SYNCRO:SyncID]
  sd_name         VARCHAR NOT NULL,                       -- TODO [SYNCRO:SyncID]
  sd_parentid     INTEGER NOT NULL,
  sd_type         VARCHAR(20),
  sd_sort         NUMERIC(7, 2),                          -- Sortierungsreihenfolge
  sd_config       TEXT,
  sd_settingsname VARCHAR(80),
  sd_settingstype VARCHAR(20),
  sd_vartxtnr     INTEGER,
  sd_deleted      BOOLEAN DEFAULT False                   -- [SYNCRO:Deleted]
  -- System (tables__generate_missing_fields)
  --modified_date TIMESTAMP(0)                            -- [SYNCRO:Modified]
);

CREATE INDEX SettingsDyn__ini_name ON SettingsDyn(TSystem.INI_GetValue(sd_config, 'modul_settings', 'name')) WHERE NOT sd_deleted;
CREATE INDEX SettingsDyn__sd_type ON SettingsDyn(LOWER(sd_type));

-- #14895 Einstellungen Dynamisch: RULE Löschen eines Settings
CREATE OR REPLACE RULE SettingsDyn_delete AS
  ON DELETE
  TO SettingsDyn
  WHERE current_user <> 'syncro'
  DO INSTEAD
    UPDATE SettingsDyn SET sd_deleted = true WHERE sd_id = old.sd_id;


-- Nummernkreise
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Nummernkreisvergabe
-- siehe auch FUNCTION TSystem.getnumcirclenr_data
CREATE TABLE TSystem.numcircles (
  nc_ident              VARCHAR(30) NOT NULL PRIMARY KEY,
  nc_description        VARCHAR(35),
  nc_preselect          VARCHAR(555),
  nc_num                INTEGER,
  nc_num_lower_bound    INTEGER,
  nc_modulname          VARCHAR(50),
  nc_active             BOOL NOT NULL DEFAULT TRUE,
  nc_checksql           TEXT,
  nc_default            BOOL NOT NULL DEFAULT False,
  nc_num_restart        BOOL NOT NULL DEFAULT False,
  nc_num_start          integer NOT NULL DEFAULT 100,
  -- System (tables__generate_missing_fields)
  dbrid                 VARCHAR(32) NOT NULL DEFAULT nextval('db_id_seq'),
  insert_date           DATE,
  insert_by             VARCHAR(32),
  modified_by           VARCHAR(32),
  modified_date         TIMESTAMP(0)
);

--  zwecks Kompatibilität
CREATE OR REPLACE VIEW public.numcircles AS
  SELECT nc_ident, nc_description, nc_preselect, nc_num, nc_modulname,
         nc_active, nc_checksql, nc_default, nc_num_restart, nc_num_start, dbrid, insert_by, insert_date,
         modified_by, modified_date
  FROM TSystem.numcircles;
--

-- temporäre Reservierung einer Nummer
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Nummernkreisvergabe
-- siehe auch FUNCTION getnumcirclenr_data
CREATE TABLE TSystem.numcircles_reserved (
  ncr_id        SERIAL PRIMARY KEY,
  ncr_nc_ident  VARCHAR(30) NOT NULL REFERENCES TSystem.numcircles ON UPDATE CASCADE ON DELETE CASCADE,
  ncr_num       TEXT,
  ncr_time      TIMESTAMP(0)
);

/*Tabelle Währungen*/
CREATE TABLE bewa
 (wa_einh               VARCHAR(3) NOT NULL CONSTRAINT xtt4055 PRIMARY KEY,
  wa_bez                VARCHAR(30),
  wa_kurs               NUMERIC NOT NULL,
  wa_dat                DATE, --Datum der Erfassung
  wa_umre               SMALLINT NOT NULL DEFAULT 1,
  wa_rund               NUMERIC NOT NULL DEFAULT 100,
  wa_abkz               VARCHAR(4)
 );


 CREATE OR REPLACE FUNCTION bewa__a__iu_kurs() RETURNS TRIGGER AS $$  -- insert or update Kurs ...
 BEGIN
  IF TG_OP<>'INSERT' THEN
        IF new.wa_dat IS NOT DISTINCT FROM old.wa_dat THEN
           new.wa_dat:=current_date;
           RAISE NOTICE 'xtt15564';  --Das Kursdatum wird auf den heutigen Tag gesetzt;
        END IF;
        --- #19766 Währungskurs korrigieren
        UPDATE epreis   SET e_kurs    = new.wa_kurs WHERE e_waer     = new.wa_einh AND ( e_bisdatum IS NULL OR e_bisdatum >= new.wa_dat );
        UPDATE auftg    SET ag_kurs   = new.wa_kurs WHERE ag_waer    = new.wa_einh AND NOT auftg.ag_done;
        UPDATE ldsdok   SET ld_kurs   = new.wa_kurs WHERE ld_waer    = new.wa_einh AND NOT ldsdok.ld_done;
        --- Eingangsrechnung / Ausgangsrechnungdokument
        UPDATE belegpos SET belp_kurs = new.wa_kurs
            WHERE belp_waehr = new.wa_einh
              AND belp_dokument_id IN ( SELECT beld_id FROM belegdokument WHERE beld_id = belp_dokument_id AND NOT beld_definitiv );
            --- Ausgangrechnungkopf
        UPDATE belkopf  SET be_umr    = new.wa_kurs WHERE be_waco    = new.wa_einh AND NOT belkopf.be_def;
        ---
  ELSIF new.wa_dat IS NULL THEN
        new.wa_dat:=current_date;
  END IF;
  RETURN new;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER bewa__a__iu_kurs
 AFTER INSERT OR UPDATE OF wa_kurs
 ON bewa
 FOR EACH ROW
 EXECUTE PROCEDURE bewa__a__iu_kurs();


/*Tabelle Steuercodes*/
CREATE TABLE steutxt
 (steu_z                serial NOT NULL PRIMARY KEY,        -- ID
  steu_grup             smallint,                           -- ?
  steu_proz             numeric NOT NULL DEFAULT 0,         -- Prozentsatz
  steu_konto            varchar(20),                        -- Kontierung in Buchhaltung
  steu_allg1            varchar(20),                        -- Freifeld
  steu_txt              varchar(50),                        -- Bezeichnung
  steu_valid_from       date,                               -- Gültig ab
  steu_valid_to         date,                               -- Gültig bis BEACHTE DailyDBFunctions.steutxt_follower
  steu_z_follower       integer REFERENCES steutxt,         -- Am Tag nach gültig bis werden alle Stammdaten (adk1, adk2, epreis) auf diesen Steuercode umgeschrieben
  steu_buchcode         varchar(10),                        -- Umcodierung für Buchhaltungssoftware
  steu_type             varchar(1),                         -- Steuertyp. 'E' für Einkauf, 'V' für Verkauf  #7327
  steu_untdid           varchar(10)                         -- Codeliste UNTDID 5305, Verwendung u.a. für XRechnung
 );


  CREATE OR REPLACE FUNCTION steutxt__a_iud() RETURNS TRIGGER AS $$
    BEGIN
     IF NOT tg_op='INSERT' THEN
            DELETE FROM steutxtlang WHERE sl_steu_z=old.steu_z AND sl_spr_key=prodat_languages.current_lang();
     END IF;
     IF NOT tg_op='DELETE' THEN
            INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (new.steu_z, prodat_languages.current_lang(), new.steu_txt);
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;

   CREATE TRIGGER steutxt__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON steutxt
    FOR EACH ROW
    EXECUTE PROCEDURE steutxt__a_iud();

CREATE OR REPLACE FUNCTION steutxt__steu_z__valid_follower_get(IN _steutxt steutxt, IN _date date DEFAULT current_date, OUT steu_z integer, OUT steu_proz numeric)
  RETURNS record
  AS $$
  DECLARE _follower_steutxt steutxt;
  BEGIN
    steu_z := _steutxt.steu_z;
    steu_proz := _steutxt.steu_proz;
    -- wenn abgelaufen UND Nachfolgesteuercode angegeben
    IF coalesce(_steutxt.steu_valid_to, _date) < _date AND _steutxt.steu_z_follower IS NOT null THEN
        SELECT steu_follower.*
          INTO _follower_steutxt
          FROM steutxt steu_follower
         WHERE steu_follower.steu_z = _steutxt.steu_z_follower
           --AND coalesce(steu_new.steu_valid_from, _date) >= _date AND coalesce(steu_new.steu_valid_to, _date) <= _date
         ;
        IF found THEN
            steu_z := _follower_steutxt.steu_z;
            steu_proz := _follower_steutxt.steu_proz;
        END IF;
    END IF;
    steu_proz := coalesce(steu_proz, 0); -- Steuersatz Prozent leer gibt es nicht, nur Code Leer heißt unbekannt/Problem! Dann ist Prozent 0!
    RETURN;
  END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION steutxt__steu_z__valid_follower_get(IN _steu_z integer, IN _date date DEFAULT current_date, OUT steu_z integer, OUT steu_proz numeric)
  RETURNS record
  AS $$
  BEGIN
    SELECT (steutxt__steu_z__valid_follower_get(steutxt, _date)).* INTO steu_z, steu_proz FROM steutxt WHERE steutxt.steu_z = _steu_z;
    steu_proz := coalesce(steu_proz, 0); -- Steuersatz Prozent leer gibt es nicht, nur Code Leer heißt unbekannt/Problem! Dann ist Prozent 0!
    RETURN;
  END $$ LANGUAGE plpgsql;

/*Steuercodebezeichnungen in Fremdsprachen*/

CREATE TABLE steutxtlang
 (sl_id                 SERIAL NOT NULL PRIMARY KEY,
  sl_steu_z             INTEGER NOT NULL CONSTRAINT steutxtlang_steutxt REFERENCES steutxt ON UPDATE CASCADE ON DELETE CASCADE,
  sl_spr_key            VARCHAR(5) NOT NULL REFERENCES sprach,
  sl_txt                VARCHAR(50),
  sl_txt_ext            VARCHAR(50) ---- #7327?
 );

 CREATE UNIQUE INDEX sl_txt ON steutxtlang (sl_steu_z, sl_spr_key);

/*Ab- und Zuschläge*/

CREATE TABLE abzu (                                                -- VIEWFELDER
  abz_id                SERIAL PRIMARY KEY,                          --  ID des Zuschlags
  abz_type              VARCHAR(1) DEFAULT 'E',                      --  Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
  -- abz_pos           (gibt es hier nicht)                          --  Position
  -- abz_abz_id        (gibt es hier nicht, wären wir selbst)        --  ID der Vorgabe
  -- abz_parent_id     (gibt es hier nicht, keinen Parent)           --  ID des Datensatzes an dem der Zuschlag hängt
  -- abz_anzahl        (gibt es hier nicht, grundlos?)               --  Anzahl / Menge
  abz_betrag            NUMERIC,                                     --  Betrag in Währung des Parent-Datensatzes
  abz_proz              NUMERIC,                                     --  Prozentualer Zuschlag auf Basis des Parent-Betrags
  abz_canskonto         BOOLEAN NOT NULL DEFAULT TRUE,               --  Gilt Skonto für den Zuschlag?
  abz_steu              INTEGER REFERENCES steutxt,                  --  Steuercode (meist gleich Parent)
  -- abz_steuproz      (gibt es hier nicht, grundlos?)               --  Prozentsatz der Steuer
  abz_konto             VARCHAR(25),                                 --  Kontierung
  abz_visible           BOOLEAN NOT NULL DEFAULT TRUE,               --  Auf Dokument sichtbar oder nicht?
  abz_zutxt             TEXT,                                        --  Zusätzlicher Hinweistext
  abz_zutxt_rtf         TEXT,                                        --  Zusätzlicher Hinweistext (RTF)
  abz_zutxt_int         TEXT,                                        --  Interner zusatztext (erscheint nicht auf Dokumenten)
  -- abz_source_table  (gibt es hier nicht, keine Vorgänger)         --  Aus welcher Quelle wurde Abzu hierhin kopiert
  -- abz_source_dbrid  (gibt es hier nicht, keine Vorgänger)         --  Aus welchem Datensatz wurde Abzu hierhin kopiert
  abz_txt               VARCHAR(50),                                 --  Bezeichnung des Zuschlags
                                                                   -- ZUSATZFELDER
  abz_aknr_old          VARCHAR(18),                                 -- ?
  abz_inselbstko        BOOLEAN NOT NULL DEFAULT TRUE,               -- in Selbskosten
  abz_einkauf           BOOLEAN NOT NULL DEFAULT TRUE,               -- Einkaufseitig verwendet
  abz_verkauf           BOOLEAN NOT NULL DEFAULT TRUE,               -- Verkaufseitig verwendet
  --abz_matnr             VARCHAR(50),                                 -- Entfernt: Wahrscheinlich Fehlerhafter Commit aus 2014. Revision: 15096, Author: luth
  abz_ungueltig         BOOLEAN NOT NULL DEFAULT FALSE,
  CHECK (abz_proz       <> 0::numeric)
 );

  CREATE OR REPLACE FUNCTION abzu__a_iud() RETURNS TRIGGER AS $$
  BEGIN
    IF NOT tg_op='INSERT' THEN
        DELETE FROM abzutxt WHERE abzl_abz_id=old.abz_id AND abzl_spr_key=prodat_languages.current_lang();
    END IF;
    IF NOT tg_op='DELETE' THEN
        INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (new.abz_id, prodat_languages.current_lang(), new.abz_txt);
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER abzu__a_iud
  AFTER INSERT OR UPDATE OR DELETE
  ON abzu
  FOR EACH ROW
  EXECUTE PROCEDURE abzu__a_iud();

CREATE TABLE abzutxt (
    abzl_id               serial NOT NULL PRIMARY KEY,
    abzl_abz_id           integer NOT NULL REFERENCES abzu ON DELETE CASCADE,
    abzl_spr_key          varchar(5) NOT NULL REFERENCES sprach,
    abzl_txt              varchar(50)
    );

    CREATE UNIQUE INDEX xtt10558 ON abzutxt (abzl_abz_id, abzl_spr_key);

-- [SYNCRO-TABLE] Feldübersetzung
-- ACHTUNG: Bei Änderungen die Felder im Cache anpassen -> TCimDM_SysDB.CimCacheDefinition:FieldAlias (UDataModul_SysDB)
CREATE TABLE fieldalias (
    --fa_stamp            TIMESTAMP(0) PRIMARY KEY DEFAULT now(),  -- [ALT] PKEY siehe fieldalias_unique
    fa_modified           TIMESTAMP(0),          -- [SYNCRO:Modified]
    fa_fieldname          varchar(63) NOT NULL,  -- [SYNCRO:SyncID=fa_fieldname+fa_tablename]
    fa_tablename          varchar(63),           -- [SYNCRO:SyncID=fa_fieldname+fa_tablename] tabellenname bei View oder abgeleiteten tabellen, wird nur berücksichtigt wenn auch gefüllt
    fa_textno             integer,
    fa_hint               text,
    fa_linkmodules        text,                  -- Memo Einträge für F2-Modulverlinkungen für dieses Feld
    --fa_bi_displayformat varchar(20),           -- Displayformat Business Intelligence
    fa_displayformat      varchar(20),           -- 0.0000 oder 0.00 oder mit % hinten dran
    fa_editformat         varchar(20),           --
    fa_imageindex         integer,               -- Image für Tabellenheader
    fa_constraints        varchar(100),          -- [SYNCRO:Deleted='*DELETED*'] Enum/Kommasepariert: UpperCase, ReadOnly, Hidden, Visible, HideCustomize usw. (siehe F2 in den FieldAlias)
    fa_wawipos_map        varchar(63)            -- ColumName in WawiPosMapping : ag_aknr > p_aknr
    );

    -- Indizes
        -- ALTER TABLE fieldalias ADD CONSTRAINT fieldalias_pkey PRIMARY KEY(fa_fieldname, fa_tablename);
        -- PRIMARY KEY ist zwar schon UNIQUE, aber der kann kein Case-Insensitive, Coalesce und vorallem kein NULL
        CREATE UNIQUE INDEX fieldalias_unique ON fieldalias (UPPER(fa_fieldname), LOWER(COALESCE(fa_tablename,'')));
        CREATE INDEX IF NOT EXISTS fieldalias_fa_textno ON fieldalias( fa_textno );
    --

    --
    CREATE OR REPLACE FUNCTION fieldalias__b_u() RETURNS TRIGGER AS $$
      BEGIN
        IF NOT (current_user='syncro') then
            new.fa_modified:=currenttime();
        END IF;
        RETURN new;
      END $$ LANGUAGE plpgsql;

      CREATE TRIGGER fieldalias_modified
        BEFORE UPDATE
        ON fieldalias
        FOR EACH ROW
        EXECUTE PROCEDURE fieldalias__b_u();
--
-- FieldAlias : NULL wenn nicht gefunden
CREATE OR REPLACE FUNCTION TSystem.FieldAlias__GetE(fieldname VARCHAR, fieldaliastablename VARCHAR DEFAULT NULL) RETURNS VARCHAR
  AS $$
    SELECT prodat_languages.lang_text(fa_textno)
      FROM public.fieldalias
     WHERE upper(fa_fieldname) = upper(fieldname)
     ORDER BY
           coalesce(upper(fa_tablename), '') = coalesce(upper(fieldaliastablename),'') IS false -- TableName übereinstimmend zuerst -- FALSE comes first and TRUE comes last (because FALSE is treated as 0 and TRUE as 1).
     LIMIT 1;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
-- FieldAlias : FieldName wenn nicht gefunden
CREATE OR REPLACE FUNCTION TSystem.FieldAlias__Get(fieldname VARCHAR, fieldaliastablename VARCHAR DEFAULT NULL) RETURNS VARCHAR
  AS $$
    SELECT coalesce(TSystem.FieldAlias__GetE(fieldname, fieldaliastablename), coalesce(fieldaliastablename || '.', '') || fieldname);
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
--
CREATE OR REPLACE FUNCTION z_99_deprecated.GetFieldAlias(fieldname VARCHAR, fieldaliastablename VARCHAR DEFAULT NULL) RETURNS VARCHAR
  AS $$
     SELECT TSystem.FieldAlias__Get(fieldname, fieldaliastablename);
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
CREATE OR REPLACE FUNCTION z_99_deprecated.GetFieldAliasE(fieldname VARCHAR, fieldaliastablename VARCHAR DEFAULT NULL) RETURNS VARCHAR
  AS $$
     SELECT TSystem.FieldAlias__GetE(fieldname, fieldaliastablename);
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
--
--

--Bemerkungsverwaltung
CREATE TABLE belarzu
 (zu_id                 SERIAL PRIMARY KEY,
  zu_tform              VARCHAR(80), -- Modulname zur Identifikation der F2s
  zu_gruppe             VARCHAR(80), -- Gruppe, zu der sie zugeordnet werden kann
  zu_tit                VARCHAR(50) NOT NULL,
  zu_spr_key            VARCHAR(5) NOT NULL DEFAULT prodat_languages.curr_lang() REFERENCES sprach,
  zu_txt1               TEXT,
  zu_txt1_rtf           TEXT,
  zu_readonly           BOOLEAN DEFAULT false   -- wenn 'ja' - keine Änderung im zu_tit und Datensatz nicht löschen
 );

CREATE UNIQUE INDEX belarzu__zu_tit_zu_spr_key ON belarzu (zu_tit, zu_spr_key);

--- #10826 #19229
CREATE OR REPLACE FUNCTION belarzu__b_10_ud__zu_readonly() RETURNS TRIGGER AS $$
  BEGIN
    IF tg_op = 'UPDATE' THEN
        RAISE EXCEPTION 'Der Kurzname von System-Vorgabetexte dürfen nicht geändert werden. xtt29358';
    END IF;

    IF tg_op = 'DELETE' THEN
        RAISE EXCEPTION 'System-Vorgabetexte dürfen nicht gelöscht werden. xtt29359';
    END IF;
    --
    RETURN null;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER belarzu__b_10_ud__zu_readonly
  BEFORE UPDATE OF zu_tit OR DELETE
  ON public.belarzu
  FOR EACH ROW
  WHEN ( old.zu_readonly )
  EXECUTE PROCEDURE public.belarzu__b_10_ud__zu_readonly();
---

-- [SYNCRO-TABLE] EDI
CREATE TABLE edi
 (edi_name              VARCHAR(50) PRIMARY KEY,  -- [SYNCRO:SyncID]
  edi_comments          TEXT,
  edi_sql_statement     TEXT,
  edi_text              TEXT,
  edi_ds_ssign          VARCHAR(30),
  edi_ds_header         VARCHAR(30),
  edi_rowseparator      VARCHAR(10),
  edi_UTF8ToAnsi        BOOLEAN NOT NULL DEFAULT FALSE
  -- System (tables__generate_missing_fields)
  --modified_date TIMESTAMP(0)                    -- [SYNCRO:Modified]
 );

-- [SYNCRO-TABLE] Abfragegenerator
CREATE TABLE dosqluserselect
 (sus_id                TIMESTAMP(0) PRIMARY KEY DEFAULT now(),
  sus_modified          TIMESTAMP(0),              -- [SYNCRO:Modified]
  sus_name              INTEGER REFERENCES text0,  -- [SYNCRO:SyncID]
  sus_sql               TEXT
 );

    CREATE OR REPLACE FUNCTION dosqluserselect__b_u() RETURNS TRIGGER AS $$
    BEGIN
     IF NOT (current_user='syncro') then
            new.sus_modified:=currenttime();
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER dosqluserselect_modified
    BEFORE UPDATE
    ON dosqluserselect
    FOR EACH ROW
    EXECUTE PROCEDURE dosqluserselect__b_u();

/*EDI-EXPORT VON ...*/

CREATE TABLE edi_exp
 (edx_id                SERIAL PRIMARY KEY,
  edx_auftgdocnr        INTEGER,
  edx_belbnr            VARCHAR(15),
  edx_error             TEXT,
  edx_done              BOOL DEFAULT FALSE
 );

CREATE INDEX edi_exp_done ON edi_exp(edx_done) WHERE NOT edx_done;

-- edi-import aktivieren oder edi-export erstellen
CREATE TABLE edi_do_edi
 (edd_id                SERIAL PRIMARY KEY,
  edd_is_export         BOOLEAN NOT NULL DEFAULT FALSE,
  edd_edi_name          VARCHAR(50) REFERENCES edi,
  edd_path              VARCHAR(100),
  edd_filename          VARCHAR(20),
  edd_active            BOOL NOT NULL DEFAULT FALSE,
  edd_start             TIMESTAMP(0),
  edd_interval          INTEGER,
  edd_last_execute      TIMESTAMP(0),
  edd_last_state        text
 );

CREATE TABLE edi_incomming_auftg
 (edi_id                SERIAL PRIMARY KEY,
  edi_bestnr            VARCHAR(50),
  edi_bestpos           INTEGER,
  edi_aknr              VARCHAR(50),
  edi_aknrix            VARCHAR(5),
  edi_m                 NUMERIC,
  edi_vkp               NUMERIC,
  edi_zus               NUMERIC,
  edi_term              VARCHAR(10),
  edi_terml             VARCHAR(10),
  edi_dispo             VARCHAR(50),
  edi_badress           VARCHAR(100),
  edi_ladress           VARCHAR(100),
  edi_radress           VARCHAR(100),
  edi_txt               TEXT,
  edi_typ               VARCHAR(1),
  edi_filename          VARCHAR(100),
  edi_done              BOOL NOT NULL DEFAULT FALSE,
  -- Freifelder
  edi_fld1              VARCHAR(100),
  edi_fld2              VARCHAR(100),
  edi_fld3              VARCHAR(100),
  edi_fld4              VARCHAR(100),
  edi_fld5              VARCHAR(100),
  edi_fld6              VARCHAR(100),
  edi_fld7              VARCHAR(100),
  edi_fld8              VARCHAR(100),
  edi_fld9              VARCHAR(100),
  edi_fld10             VARCHAR(100),
  edi_fld11             VARCHAR(100),
  edi_fld12             VARCHAR(100),
  edi_fld13             VARCHAR(100),
  -- System (tables__generate_missing_fields)
  insert_date           DATE,
  insert_by             VARCHAR(32),
  modified_by           VARCHAR(32),
  modified_date         TIMESTAMP(0)
 );

    CREATE INDEX edi_incomming_auftg_done ON edi_incomming_auftg (edi_done) WHERE NOT edi_done;
    CREATE INDEX edi_incomming_bestnr ON edi_incomming_auftg (edi_bestnr, edi_done);


    CREATE OR REPLACE RULE edi_incomming_auftg_delete AS
        ON DELETE TO edi_incomming_auftg WHERE NOT edi_done DO INSTEAD
          --(
            UPDATE edi_incomming_auftg SET edi_done = true WHERE edi_incomming_auftg.edi_id = old.edi_id;
          --);

    -- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
    CREATE TRIGGER edi_incomming_auftg_set_modified
      BEFORE INSERT OR UPDATE
      ON edi_incomming_auftg
      FOR EACH ROW
      EXECUTE PROCEDURE table_modified();


    CREATE OR REPLACE FUNCTION edi_incomming_auftg__a_u() RETURNS TRIGGER AS $$
    DECLARE arec RECORD;
            azkunr VARCHAR;
            typ VARCHAR;
            oldedi RECORD;
    BEGIN
     IF new.edi_done AND NOT old.edi_done THEN
            SELECT * INTO arec FROM auftg WHERE ag_bda=old.edi_bestnr AND ag_pos=COALESCE(new.edi_bestpos, 1);
            SELECT az_kunr INTO azkunr FROM artzuo WHERE az_pronr=arec.ag_aknr AND az_prokrz=arec.ag_lkn;
            IF EXISTS (SELECT true FROM ediprot WHERE ep_bda=new.edi_bestnr AND COALESCE(new.edi_bestpos,0)=COALESCE(ep_bdapos,0)) THEN
                    typ:='C';--Change
            ELSE
                    typ:='O';--Order
            END IF;
            INSERT INTO ediprot (ep_typ, ep_bda, ep_bdapos, ep_pos, ep_udat, ep_aknr, ep_kart, ep_stkbn, ep_vkpn, ep_zus, ep_ldn, ep_txt) VALUES (typ, old.edi_bestnr, arec.ag_bdapos, arec.ag_pos, current_date, arec.ag_aknr, azkunr, arec.ag_stk_uf1, arec.ag_vkp_uf1, old.edi_zus, arec.ag_ldatum, old.edi_txt);
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;


    CREATE TRIGGER edi_incomming_auftg__a_u
    AFTER UPDATE
    ON edi_incomming_auftg
    FOR EACH ROW
    EXECUTE PROCEDURE edi_incomming_auftg__a_u();



CREATE TABLE ediprot
 (ep_ag_id              INTEGER,
  ep_bda                VARCHAR(40),
  ep_bdapos             INTEGER,
  ep_pos                INTEGER,
  ep_anr                VARCHAR(10),
  ep_bdat               DATE,
  ep_udat               DATE,
  ep_typ                VARCHAR(1),
  ep_aknr               VARCHAR(40),
  ep_kart               VARCHAR(40),
  ep_stkba              NUMERIC,
  ep_stkbn              NUMERIC,
  ep_vkpa               NUMERIC,
  ep_vkpn               NUMERIC,
  ep_zus                NUMERIC,
  ep_lda                DATE,
  ep_ldn                DATE,
  ep_zei                TIME(0) DEFAULT current_time,
  ep_ckn                INTEGER,
  ep_txt                TEXT
 );

CREATE INDEX ediprot_ep_bda ON ediprot(ep_bda);
CREATE INDEX ediprot_ep_ag_id ON ediprot(ep_ag_id);


CREATE TABLE msg
 (msg_id         SERIAL NOT NULL PRIMARY KEY,
  msg_snd        VARCHAR (80) NOT NULL, --Sender - Name des Benutzers der die Nachricht versendet hat
  msg_head       VARCHAR (80),   -- Header (Betreff) der Nachricht
  msg_body       TEXT,           -- Der eigentliche Text
  msg_rcvTxt     VARCHAR (1000) -- Enthält Namen aller Nutzer an die die Nachricht gesendet wurde, Zur GUI Anzeige der Empfänger benutzt
 );

CREATE TABLE msgRcv
 (msgRcv_id      SERIAL NOT NULL PRIMARY KEY,
  msgRcv_msgid   INTEGER NOT NULL REFERENCES msg ON UPDATE CASCADE ON DELETE CASCADE, -- Nachricht um die es sich handelt
  msgRcv_User    VARCHAR (80) NOT NULL, -- Name eines Nutzers der die Nachricht erhalten soll
  msgRcv_read    BOOL DEFAULT FALSE --True sobald der Nutzer die Nachricht geöffnet hat.Wird für Anzeige neuer Nachrichten benutzt
 );

CREATE INDEX msgRcv_msgRcv_read ON msgRcv(msgRcv_read);
CREATE INDEX msgRcv_msgRcv_msgid ON msgRcv(msgRcv_msgid);

/* Erstellt eine neue Nachricht:*/
-- _msg_snd: usename des Senders (pg_user)
-- _msg_head: Betreff der Nachricht
-- _msg_body: Eigentlicher Nachrichtentext
-- _msgRcv_User: 1..N-Empfänger - Arrayeintrag entspricht usename (pg_user)

CREATE OR REPLACE FUNCTION msg_SendMsg_array(_msg_snd VARCHAR, _msg_head VARCHAR, _msg_body VARCHAR, _msgRcv_User VARCHAR[]) RETURNS BOOL AS $$
    DECLARE
      _rcvTxt VARCHAR(1000) = '';
      _id INTEGER;

    BEGIN
      _id := nextval('msg_msg_id_seq');

      -- Eintrag in Msg für neue Nachricht, vorerst ohne msg_rcvTxt
      INSERT INTO msg (msg_id, msg_snd, msg_head, msg_body)
        VALUES (_id,_msg_snd, _msg_head, _msg_body);

      -- über Array der Empfänger iterieren
      FOR i IN 1..array_upper(_msgRcv_User,1) LOOP

            -- Wenn möglich statt usename den Vor- und Zunamen aus ADK verwenden
            IF i = 1 THEN
              _rcvTxt:= COALESCE(nameAufloesen(_msgRcv_User[i]), _msgRcv_User[i]);
            ELSE
              _rcvTxt:= _rcvTxt||', '|| COALESCE(nameAufloesen(_msgRcv_User[i]), _msgRcv_User[i]);
            END IF;

            -- Einträge in msgRcv vornehmen
            INSERT INTO msgRcv (msgRcv_msgid, msgRcv_User) VALUES (_id, _msgRcv_User[i]);

      END LOOP;

      -- msg_rcvTXT nachträglich einfügen
      UPDATE msg SET msg_rcvTxt = _rcvTxt WHERE msg_id = _id;

      RETURN true;
    END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION msg_SendMsg(_msg_snd VARCHAR, _msg_head VARCHAR, _msg_body VARCHAR, _msgRcv_User VARCHAR) RETURNS BOOL AS $$
    DECLARE
      _rcvTxt VARCHAR(1000) = '';
      _id INTEGER;

    BEGIN
      _id := nextval('msg_msg_id_seq');

      -- Eintrag in Msg für neue Nachricht, vorerst ohne msg_rcvTxt
      INSERT INTO msg (msg_id, msg_snd, msg_head, msg_body)
        VALUES (_id,_msg_snd, _msg_head, _msg_body);

      _rcvTxt:= COALESCE(nameAufloesen(_msgRcv_User), _msgRcv_User);

      -- Einträge in msgRcv vornehmen
      INSERT INTO msgRcv (msgRcv_msgid, msgRcv_User) VALUES (_id, _msgRcv_User);

      -- msg_rcvTXT nachträglich einfügen
      UPDATE msg SET msg_rcvTxt = _rcvTxt WHERE msg_id = _id;

      RETURN true;
    END $$ LANGUAGE plpgsql;
--

/*Versucht einen loginname (pg_user) in Vorname und Nachname aufzulösen (usename => ll_minr => adk)
  Gibt zusammengesetzen Namen "Vorname Nachname" oder usename zurück.
  Gibt NULL zurück, falls usename nicht existiert => Mitarbeiter hat kein DB Login.*/
--
CREATE OR REPLACE FUNCTION nameAufloesen(/*__by__db_usename__or__ll_minr__or__ad_krz*/
  IN _str varchar,
  IN surnamefirst boolean = false)
  RETURNS varchar
  AS $$
  DECLARE _name varchar;
  BEGIN
    IF NULLIF(_str, '') IS NULL THEN
        RETURN null;
    END IF;
    --/*

    --caching
    SELECT c_resultc
      INTO _name
      FROM tcache.function_cache
     WHERE c_funcname = 'nameAufloesen'
       AND c_param0 = _str
       AND c_param1 = surnamefirst::varchar
       AND NOT c_dirty;

    IF _name IS NOT NULL THEN
        RETURN _name;
    END IF;
    --end caching*/

    -- DS: diese Funktion ist fraglich. Dieses Verhalten, das zufällig db_login oder minr oder adresskürzel genommen werden ist fraglich. Wahrscheinlichkeit das es Überschneidung gibt ist gering, dennoch fraglich.
    --     Prinzipiell aber auch gewollt, man gibt irgendwas rein und bekommt in der suchreihenfolge halt das ergebnis
    -- ll_db_usename
       SELECT ifthen(surnamefirst, ad_name || ', ' || ad_vorn, ad_vorn || ' ' || ad_name)
         INTO _name
         FROM llv LEFT OUTER JOIN adk ON ad_krz = ll_ad_krz
        WHERE ll_db_usename = _str;
    -- ll_minr
    IF _name IS NULL THEN
       SELECT ifthen(surnamefirst, ad_name || ', ' || ad_vorn, ad_vorn || ' ' || ad_name)
         INTO _name
         FROM llv LEFT OUTER JOIN adk ON ad_krz = ll_ad_krz
        WHERE ll_minr = _str;
    END IF;

    -- ad_krz
    IF _name IS NULL THEN
       SELECT ifthen(surnamefirst, ad_name || ', ' || ad_vorn, ad_vorn || ' ' || ad_name)
         INTO _name
         FROM adk
        WHERE ad_krz = _str;
    END IF;

    _name := coalesce(_name, _str);

    --caching schreiben
    PERFORM  tcache.function_cache_setcache_2param('nameAufloesen', _str, surnamefirst::varchar, NULL, _name);
    --end caching schreiben

    RETURN _name;
  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
--

-- Versucht den Name anhand der Mitarbeiternummer zurückzugebenVersucht den Name anhand der Mitarbeiternummer zurückzugeben
CREATE OR REPLACE FUNCTION nameAufloesen(/*__by__ll_minr*/
  IN _int integer,
  IN surnamefirst boolean = false)
  RETURNS varchar(200)
  AS $$
  DECLARE _name varchar;
  BEGIN
    SELECT ifthen(surnamefirst, ad_name || ', ' || ad_vorn, ad_vorn || ' ' || ad_name)
      INTO _name
      FROM llv LEFT JOIN adk ON ad_krz=ll_ad_krz
     WHERE ll_minr = _int;

    RETURN coalesce(_name, CAST(_int AS varchar));
  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
--

-- Konfigurationsdaten für Dokumentenverwaltung ...
-- Jeder Datensatz konfiguriert Einlesen eines Dokumententypes und Anhängen an Tabelle
CREATE TABLE DokVerwaltung  --DokImport
 ( dv_id         SERIAL NOT NULL PRIMARY KEY,
   dv_showName   VARCHAR (80) NOT NULL,                 -- Name der Dokumentzuordnung Bsp: 'Artikel - Normen'
   dv_tableName  VARCHAR (80) NOT NULL,                 -- Tabelle an deren Datensätze Doks angehängt werden Bsp: 'art'
                                                        --    '*' bei neuem Import (GetFiles)
   dv_filePath   VARCHAR (200),                         -- Ordner der nach anzuhängenden Dateien durchsucht wird Bsp: 'C:\Docs\Art\'
   dv_savePath   VARCHAR (100),                         -- Dokument wird in picndoku unter diesem Parent gespeichert Bsp: 'Protokolle'
   dv_KeyFields  VARCHAR (80) NOT NULL,                 -- Bezeichner für die Parameter im Dateinamen/SqlWhere-Statement Bsp: 'Artikelnummer'
   dv_fileSchema VARCHAR (80),                          -- Schema Dateiname Bsp: 'N-[Artikelnummer].*'
   dv_sqlString  TEXT,                                  -- SQL-Klausel Bsp: 'SELECT * FROM art WHERE ak_nr =:Artikelnummer AND ak_prognr IS NOT NULL'
                                                        --   SourceSQL für neuen Import (GetFiles)
   dv_sqlUpdate  TEXT,                                  -- UpdateSQL (GetFiles)
   dv_config     TEXT,                                  -- Parameter (GetFiles)
   dv_doktype    VARCHAR (50),                          -- dokumenttyp bsp q_messprot für messprotokolle
   dv_standDok   BOOLEAN NOT NULL DEFAULT FALSE,        -- True => Dokument wird zum Standarddokument für Datensatz gemacht
   dv_aktiv      BOOLEAN NOT NULL DEFAULT FALSE,        -- Schema steht Kunden zur Verfügung (nicht-Admin) wählbar
   dv_recursive  BOOLEAN NOT NULL DEFAULT TRUE,         -- Unterverzeichnisse rekursiv prüfen (\Backup und \Imported werden ausgeschlossen)
   dv_OnlyAsLink BOOLEAN NOT NULL DEFAULT FALSE,        -- Nur in das DMS verlinken (nach verschieben in Unterordner \Imported, die Datei nicht importieren)
   dv_maxFileAge INTEGER                                -- Nur Dateien einlesen, deren Änderungsdatum maximal so lange zurück liegt (0=heute, 1=gestern, ... )
 );

 CREATE UNIQUE INDEX dokverwaltung_dv_showname_lowerindex on dokverwaltung (lower(dv_showName));
--

CREATE OR REPLACE FUNCTION namen_array_aufloesen( IN namen VARCHAR[], OUT namenlist TEXT) RETURNS TEXT AS $$
  DECLARE
      _counter INTEGER;
      _abt VARCHAR;
      _name VARCHAR;
  BEGIN

    IF namen IS NULL THEN
      RETURN;
    END IF;

    namenlist := '';

    FOR _counter IN 1..array_upper(namen,1) LOOP

      SELECT ll_abteilung
      INTO _abt
      FROM llv WHERE ll_minr = namen[_counter];

      _name := COALESCE( _abt, '') || '  ' || COALESCE( nameAufloesen( namen[_counter] ), namen[_counter] );

      IF namenlist NOT LIKE '%' || _name || '%' THEN
        namenlist := namenlist || E'\n  ' || _name;
      END IF;

    END LOOP;

    RETURN;

  END $$ LANGUAGE plpgsql;


/*Gibt das gewünschte Feld (fieldname) aus der ADK für das übergebene Login (userlogin) zurück*/
CREATE OR REPLACE FUNCTION getadk(userlogin VARCHAR, fieldname VARCHAR) RETURNS VARCHAR AS $$
    DECLARE  result VARCHAR;
    BEGIN
      IF (userlogin IS NULL) OR (userlogin = '') THEN
            RETURN '';
      END IF;

      IF (UPPER(userlogin) = 'APPS') OR (UPPER(userlogin) = 'SYNCRO') OR (UPPER(userlogin) = 'ROOT') THEN
            result := '';
      ELSE
            EXECUTE ('SELECT '|| fieldname || ' FROM llv JOIN adk ON ad_krz=ll_ad_krz WHERE ll_db_usename = ' || quote_literal(userlogin)) INTO result;
      END IF;

      RETURN result;
    END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION TSystem.getnumcircleactive(numident VARCHAR) RETURNS BOOL AS $$
  DECLARE result BOOL;
  BEGIN
    SELECT nc_active INTO result FROM TSystem.numcircles WHERE nc_ident = numident;
    RETURN COALESCE(result, false);
  END $$ LANGUAGE plpgsql VOLATILE;
--

--
CREATE OR REPLACE FUNCTION TSystem.getnumcirclenr(numident VARCHAR) RETURNS VARCHAR AS $$
  BEGIN
    RETURN (TSystem.getnumcirclenr_data(numident, false)).result;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.getnumcirclenr(numident VARCHAR, preview BOOLEAN) RETURNS VARCHAR AS $$
  BEGIN
    RETURN (TSystem.getnumcirclenr_data(numident, preview)).result;
  END $$ LANGUAGE plpgsql;
--

-- versteckte Settings für Nummernkreise
SELECT TSystem.Settings__Set('ncrtime', '2 hours'); -- INTERVAL fürs Verwerfen reservierter Nummern
/* Nummernkreise remote per dbLink aus anderer DB holen (Client-DB holt von Server-DB) #8070
    SELECT TSystem.Settings__Set('numcircles_dblink', 'host=localhost port=5432 dbname= user= password='); -- auf Client-DB: definiert Verbindung für dbLink
    SELECT TSystem.Settings__Set('numcircles_received_by_dblink', ''); -- auf Client-DB: Setting für Nummernkreise, die remote geholt werden. Mehrere Nummernkreise per ; ohne Leerzeichen getrennt.
    SELECT TSystem.Settings__Set('numcircles_accessed_by_dblink', ''); -- auf Server-DB: Setting für Nummernkreise, auf die remote zugegriffen wird. Mehrere Nummernkreise per ; ohne Leerzeichen getrennt.
*/
--

-- Erstellung von alphanumerischen Nummern je nach Nummernkreis. Features:
  -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Nummernkreisvergabe
  -- alphanumerische Maskierung per _preSelect
  -- Lückenprüfung bei Vergabe von checkSQL, bis 20 Stellen zurück
  -- Stellreservierung (z.B. für in Zahl codiertes Jahr)
  -- Temporäre Reservierung einer Nummer (wenn geholt, aber noch nicht in Zieltabelle gespeichert wurde), siehe #2120
  -- Wechselseitige Prüfung von Angebot und Auftrag bei Auftrag aus Angebot, siehe #9309.
  -- Nummernkreis remote holen (z.B. für Mehrmandanten-Systeme und globalem Nummernkreis), siehe #8070 und unter "versteckte Settings für Nummernkreise"
  -- Große Lücken nicht besetzen (Jahreswechsel), siehe #8762
CREATE OR REPLACE FUNCTION TSystem.getnumcirclenr_data(
      numident varchar,
      preview boolean,
      OUT number integer,
      OUT result varchar
  )
  RETURNS record AS $$
  DECLARE
      _received_by_dblink    boolean; -- Nummernkreis wird remote geholt. Siehe #8070 und oben bei "versteckte Settings für Nummernkreise".
      _accessed_by_dblink    boolean; -- Auf Nummernkreis wird remote zugegriffen.
      _dblink_con_settings   varchar; -- Remote-Settings
      _lower_bound           integer; -- untere Grenze zum Verhindern großer Lücken (Jahreswechsel). Siehe #8762.
                                     -- Wenn von -20 ausgehend kein Datensatz gefunden wird, gehen wir davon aus das die Nummer an dieser Position startet.
                                     -- Um dann zu vermeiden, das wenn ein Datensatz existiert wieder eine Lücke davor gefunden wird, wird lower bound eingetragen. https://ci.prodat-sql.de/sources/tests/suite/4/runner/944
      _preselect             varchar; -- SQL für Maskierung aus Nummernkreis
      _chkSQL                varchar; -- SQL für Lückenprüfung aus Nummernkreis
      _e_nicht_aus_a         boolean; -- Auftrag (E) wird nicht aus Angebot (A) erstellt. Sonst wechselseitige Prüfung der Nummerkreise. Siehe #9309.
      _num_auftg             record;  -- Daten vom jeweils anderen Auftragsnummernkreis
      _starting              integer; -- Anfang der Ermittlung der Nummer (-20 bis 50)
      _changeable_number     integer; -- Berechnung der Stellreservierung nicht unter 0
      _full_gap_check        boolean; -- Volle Lückenprüfung wird durchgeführt. Siehe #8762.
      _i                     integer;
      _last_result           varchar; -- Ergebnis des vorherigen Durchlaufs im LOOP
      _keyfound              boolean; -- Nummer ist in Zieltabelle vergeben (per _chkSQL).
      _syntaxerror           varchar; -- Fehlerausgabe für _chkSQL
      _any_keyfound          boolean; -- Prüfung großer Lücken (Jahreswechsel). Es wurde wenigstens ein Match bei Lückenprüfung gefunden. Siehe #8762.
      _first_result_set      record;  -- Prüfung großer Lücken (Jahreswechsel). Erster Ergebnis der Lückenprüfung. Siehe #8762.
      _new_lower_bound       integer; -- untere Grenze (inkl., mindestens 1), um große Lücken nicht zu besetzen (Jahreswechsel). Siehe #8762.
      _num_add               integer; -- Dieser Wert wird der Nummer hinzuaddiert (neg. ist Lücke).
  BEGIN
      IF numident IS NULL THEN RETURN; END IF;

      _any_keyfound := false;
      SELECT NULL::varchar AS result, NULL::integer AS num_add INTO _first_result_set;

      -- Lösche verfallene Reservierungen
      DELETE FROM TSystem.numcircles_reserved WHERE ncr_nc_ident = numident AND ncr_time < currenttime() - TSystem.Settings__Get('ncrtime')::INTERVAL;

      -- Remote Nummernkreise #8070
          -- Definierte Remote-Nummernkreise
          _received_by_dblink := coalesce(numident = ANY(regexp_split_to_array(TSystem.Settings__Get('numcircles_received_by_dblink'),';')), false); -- Nummernkreis wird per dbLink remote geholt. Im Setting sind entspr. Nummernkreise (per ; getrennt) verzeichnet.
          _accessed_by_dblink := coalesce(numident = ANY(regexp_split_to_array(TSystem.Settings__Get('numcircles_accessed_by_dblink'),';')), false); -- Auf Nummernkreis wird remote per dbLink zugegriffen.

          IF _received_by_dblink AND _accessed_by_dblink THEN -- Nummernkreis wird gleichzeitig remote geholt und aufgerufen.
              -- Sollte der dbLink auf die remote DB zurück zeigen, haben wir eine Endlosschleife.
              -- Keine Verbindungsketten sondern nur direkte Verbindungen auf den Remote-Nummerkreis erlaubt.
              RAISE EXCEPTION 'ERROR:  Possible infinite loop detected. Numcircle remote settings in conflict.';
           END IF;

          IF _received_by_dblink THEN -- Nummernkreis remote holen
              BEGIN
                  _dblink_con_settings := TSystem.Settings__Get('numcircles_dblink'); -- per Setting definierte Verbindung für dbLink
                  IF _dblink_con_settings iLIKE '%' || current_database() || ' %' THEN -- verwendet gleiche DB
                      RAISE EXCEPTION 'ERROR:  Possible infinite loop detected. Numcircle remote connection uses same DB.';
                  END IF;
                  IF _dblink_con_settings NOT ILIKE '%application_name=%' THEN
                      _dblink_con_settings := _dblink_con_settings || ' application_name=' || quote_literal('PRODAT-ERP-numcircles_dblink');
                  END IF;

                  -- Verbindung aufbauen
                  PERFORM dblink_connect('numcircles_remote', _dblink_con_settings);

                  -- Nummer und Ergebnis holen
                  SELECT number_ext, result_ext INTO number, result -- Alles wird per Funktionsaufruf im Remote-System gemacht, s.u..
                  FROM dblink('numcircles_remote', 'SELECT number, result FROM getnumcirclenr_data(' || quote_literal(numident) || ', ' || preview::varchar || ')') AS t1(number_ext integer, result_ext varchar);

                  -- Hier müßte _chkSQL implementiert werden an dieser Stelle, damit die Remote geholte Nummer (welche Remote auch geprüft wurde auf Konsitenz = manuelle Vergabe der gleichen Nr) auch "hier/lokal" auf Konsistenz geprüft wird!

                  -- Verbindung trennen
                  PERFORM dblink_disconnect('numcircles_remote');

                  RETURN; -- und raus
              EXCEPTION WHEN OTHERS THEN
                  IF 'numcircles_remote' = ANY(dblink_get_connections()) THEN -- bestehende Verbindung ggf. erst beenden
                      PERFORM dblink_disconnect('numcircles_remote');
                  END IF;

                  RAISE EXCEPTION '%', SQLERRM; -- eigentlichen Fehler werfen
              END;
           END IF;
      --

      -- Sonst: Nummernkreis aus eigener DB holen
      SELECT nc_num, GREATEST(nc_num_lower_bound, 1), nc_preselect, nc_checksql
        INTO number, _lower_bound, _preselect, _chkSQL
        FROM TSystem.numcircles
       WHERE nc_ident = numident AND nc_active; -- aktuelle Nummer holen
      --
      /*-- auskommentiert DS 2023-01-05 > #19262;
        -- wir sind IM Remote (Gornau holt in Limburg die Nummer). In Limburg, was das führende System ist MUSS somit auch die Prüfung stattfinden, das die Nummer auch noch nicht vergeben wurde!
      IF _accessed_by_dblink THEN -- Auf Nummernkreis wird remote per dbLink zugegriffen. #8070
         _chkSQL := NULL; -- CheckSQL/Rückwärtsprüfung dafür nicht implementiert.
      END IF;
      --*/
      --
      IF numident IN ('aauftg', 'eauftg') THEN -- Sonderbehandlung Auftragsnummernkreise #9309
          _e_nicht_aus_a := TSystem.Settings__GetBool('KeineAuftragsnummerAusAngebot');
          IF NOT _e_nicht_aus_a THEN -- Wenn Angebot zu Auftrag aus Angebotsnummer (nicht aus eigener Auftragsnummer)
              -- Daten der jeweils anderen Nummernkreises holen und Felder im Record initialisieren.
              SELECT nc_ident, nc_preselect, nc_checksql, NULL::varchar AS result, NULL::varchar AS syntaxerror INTO _num_auftg FROM TSystem.numcircles WHERE nc_ident IN ('aauftg', 'eauftg') AND nc_active AND nc_ident <> numident;

              -- Lösche verfallene Reservierungen des anderen Auftragsnummernkreises.
              DELETE FROM TSystem.numcircles_reserved WHERE ncr_nc_ident = _num_auftg.nc_ident AND ncr_time < currenttime() - TSystem.Settings__Get('ncrtime')::INTERVAL;
          END IF;
      END IF;
      --
      --
      BEGIN -- EXCEPTION WHEN
          IF number IS NOT NULL THEN -- wir haben einen Nummernkreis erhalten, nun prüfen wir, ob es einen Vorsatz vor der Nummer gibt
              IF _chkSQL IS NULL THEN -- Rückwärtsprüfung ist nur dann möglich, wenn wir ein CheckStatement haben
                  _starting := 1;
              ELSE
                  _starting := -20; -- ACHTUNG unten wird auch auf -20 geprüft um festzustellen, das eine vollständige Lückenprüfung passiert ist.

                  IF number + _starting < LEAST(_lower_bound, number + 1) THEN -- Unterschreitung der unteren Grenze (inkl.) verhindern.
                     _starting := LEAST(_lower_bound, number + 1) - number;    -- Mind. bei number + _starting = _lower_bound anfangen.
                                                                             -- Nummer an Grenze kann erneut auf Lücke geprüft werden (die Nummer war vergeben).
                                                                             -- Nummer unterhalb der Grenze (per Hand gesetzt oder unreserved) bekommt _starting = 1.
                  END IF;
                  --
                  IF number + _starting <= 0 THEN -- Nummern kleiner gleich 0 verhindern.
                      _starting := 1 - number;    -- Mind. bei number + _starting = 1 anfangen.
                  END IF;

                  -- Stellenreservierung
                      -- 5 Stellen, 1. Stelle reservieren; 6 Stellen, 1-2; 7 Stellen, 1-3, 8 und mehr Stellen, 1-4
                      -- 12345 => 1; 123456 => 12; 1234567 => 123; 12345678 => 1234. Alles andere ist der änderbare Teil und definiert _starting.
                      -- Anwendungsfall: Jahr in Nummer codiert (20180123). Bei Jahreswechsel auf (händisch) 20190000 darf Lückenprüfung nicht unter 0 (20189999) kommen.
                  IF length(number) > 4 THEN -- erst ab 5 Stellen
                      _changeable_number := (number % (10^(GREATEST((length(number) - 4), 4)))::integer); -- änderbarer Teil hinter der 4. Stelle (20180123 => 123)
                      IF _changeable_number + _starting <= 0 THEN -- negative Nummern verhindern
                          _starting := 1 - _changeable_number;    -- Start entspr. setzen
                      END IF;
                  END IF;
              END IF;
              --
              _full_gap_check:= _starting < 0; -- Volle Lückenprüfung wird durchgeführt. Nummer an Grenze (Fall 0) kann ausgegeben werden (die Nummer war vergeben).
              --
              FOR _i IN _starting..50 LOOP

                  _num_add := _i; -- Merken falls aus LOOP gesprungen wird.
                  _keyfound := false;

                  -- In Result steht die Nummer gem NUmmernkreis
                  EXECUTE 'SELECT ' || REPLACE(coalesce(_preselect, 'NC_NUM'), 'NC_NUM', number + _num_add) INTO result;  -- Austausch von Platzhalte NC_NUM mit hochzählender Nummer.
                                                                                                                        -- Erzeugung des alphanumerischen Ergebnisses. Das _preselect enthält SQL-Funktionen.

                  -- RAISE NOTICE 'Loop:%; SQL: "%"; Result: %', _i, 'SELECT ' || REPLACE(coalesce(_preselect, 'NC_NUM'), 'NC_NUM', number + _num_add), result;

                  -- Neuer Durchlauf ändert nix, dann Nummer zurücksetzen und raus aus LOOP (statischer Nummerkreis bzw. per SQL im _preselect).
                  IF _last_result = result THEN _num_add := _num_add - 1; EXIT; END IF;
                  _last_result := result;

                  -- Prüfung Zieltabelle mit Syntax-Exceptio n
                  IF _chkSQL IS NOT NULL THEN -- nur bei _chkSQL
                      IF _syntaxerror IS NULL THEN -- Exception nur einmal im LOOP ausgeben.
                          BEGIN -- EXCEPTION WHEN
                              EXECUTE('SELECT EXISTS(' || replace(UPPER(_chkSQL), ':MYNEWCHECKNUMBER', quote_literal(result)) || ')' ) INTO _keyfound; -- Match

                              -- RAISE NOTICE '_chkSQL: "%"; Result: %', 'SELECT EXISTS(' || replace(UPPER(_chkSQL), ':MYNEWCHECKNUMBER', quote_literal(result)) || ')', _keyfound;

                          EXCEPTION WHEN OTHERS THEN
                              _syntaxerror := langtext(16175) || E'\n\n' || 'Nummernkreis: ' || numident || E'\n' || 'CheckSQL: ' || _chkSQL;
                              PERFORM PRODAT_ERROR(_syntaxerror);
                              CONTINUE; -- Skip, nächste Nummer
                          END;
                      ELSIF _i < 1 THEN -- Bei Syntaxfehlern Lückenprüfung bis zu positiven Nummern überspringen, sonst werden alte Nummern ausgegeben.
                          CONTINUE; -- Skip, nächste Nummer
                      END IF;
                  END IF;
                  --
                  IF _keyfound THEN -- Nummer ist in Zieltabelle vergeben
                      IF _full_gap_check AND _i < 1 THEN -- Bei voller Lückenprüfung und innerhalb der Lücken
                          _any_keyfound := true; -- Volle Lückenprüfung erfolgreich, da wenigstens ein Match gefunden wurde.
                          IF _first_result_set IS NOT NULL THEN EXIT; END IF; -- Voriges Ergebnis bei Lücke ist vorhanden und gültig (durch Match), dann raus aus LOOP.
                      END IF;
                      --
                      DELETE FROM TSystem.numcircles_reserved WHERE ncr_nc_ident = numident AND ncr_num = result AND NOT preview;

                      -- RAISE NOTICE '_keyfound: %; _full_gap_check: %', result, _full_gap_check;

                      CONTINUE; -- Skip, nächste Nummer
                  ELSIF EXISTS(SELECT true FROM TSystem.numcircles_reserved WHERE ncr_nc_ident = numident AND ncr_num = result) THEN -- Nummer ist reserviert

                      -- RAISE NOTICE 'EXISTS numcircles_reserved: %', result;

                      CONTINUE; -- Skip, nächste Nummer
                  ELSE
                      IF numident IN ('aauftg', 'eauftg') AND NOT _e_nicht_aus_a THEN -- Sonderbehandlung Auftragsnummernkreise #9309. Wenn Angebot zu Auftrag aus Angebotsnummer (nicht aus eigener Auftragsnummer).
                                                                                     -- soll der jeweils andere Auftragsnummernkreis (RECORD _num_auftg) geprüft werden.
                          EXECUTE 'SELECT ' || REPLACE(coalesce(_num_auftg.nc_preselect, 'NC_NUM'), 'NC_NUM', number + _num_add) INTO _num_auftg.result; -- anderen Nummerkreis neu zusammensetzen entspr. der Maskierung mit aktueller Nummer.

                          IF _num_auftg.nc_checksql IS NOT NULL THEN -- Hiermit wird auf Vorhandensein von Daten des anderen Auftragsnummernkreises geprüft.
                              IF _num_auftg.syntaxerror IS NULL THEN -- Exception nur einmal im LOOP ausgeben.
                                  BEGIN
                                      EXECUTE('SELECT EXISTS(' || replace(UPPER(_num_auftg.nc_checksql), ':MYNEWCHECKNUMBER', quote_literal(_num_auftg.result)) || ')' ) INTO _keyfound; -- Match
                                  EXCEPTION WHEN OTHERS THEN
                                      _num_auftg.syntaxerror:= langtext(16175) || E'\n\n' || 'Nummernkreis: ' || _num_auftg.nc_ident || E'\n' || 'CheckSQL: ' || _num_auftg.nc_checksql;
                                      PERFORM PRODAT_ERROR(_num_auftg.syntaxerror);
                                      CONTINUE; -- Skip, nächste Nummer
                                  END;
                              ELSIF _i < 1 THEN -- Bei Syntaxfehlern Lückenprüfung bis zu positiven Nummern überspringen, sonst werden alte Nummern ausgegeben (_i kann im LOOP nicht geändert werden).
                                  CONTINUE; -- Skip, nächste Nummer
                              END IF;
                          END IF;
                          --
                          IF _keyfound THEN
                              IF _full_gap_check AND _i < 1 THEN -- Bei voller Lückenprüfung und innerhalb der Lücken
                                 _any_keyfound := true; -- Volle Lückenprüfung erfolgreich, da wenigstens ein Match gefunden wurde.
                                 IF _first_result_set IS NOT NULL THEN EXIT; END IF; -- Voriges Ergebnis bei Lücke ist vorhanden und gültig (durch Match), dann raus aus LOOP.
                              END IF;

                              DELETE FROM TSystem.numcircles_reserved WHERE ncr_nc_ident = _num_auftg.nc_ident AND ncr_num = _num_auftg.result AND NOT preview;
                              CONTINUE; -- Skip, nächste Nummer
                          ELSIF EXISTS(SELECT true FROM TSystem.numcircles_reserved WHERE ncr_nc_ident = _num_auftg.nc_ident AND ncr_num = _num_auftg.result) THEN -- Nummer des jeweils anderen Auftragsnummernkreises ist reserviert.
                              CONTINUE; -- Skip, nächste Nummer
                          END IF;
                      END IF;

                      -- Jetzt haben wir definitiv ein Ergebnis.

                      -- RAISE NOTICE '%,%, %', _full_gap_check , _any_keyfound, _starting ;

                      IF (_full_gap_check AND NOT _any_keyfound) THEN -- (Noch) kein Match bei voller Lückenprüfung gefunden.

                          IF _i < 1 THEN -- Ergebnis innerhalb der Lückensuche
                              IF _first_result_set IS NULL THEN  -- Erstes Ergebnis merken. Das wollen wir vielleicht ausgeben.
                                 _first_result_set.result := result;
                                 _first_result_set.num_add := _num_add;
                              END IF;

                              -- RAISE NOTICE '_full_gap_check AND NOT _any_keyfound. _i: % _first_result_set.result: %; _first_result_set._num_add: %', _i, _first_result_set.result, _first_result_set._num_add;

                              CONTINUE; -- Skip, nächste Nummer. Weiter nach Matches suchen.
                          ELSIF _starting = -20 THEN  -- Immer noch kein Match nach durchgeführter Lückenprüfung gefunden.
                                -- Dann gehen wir davon aus, dass Lückenprüfung zu weit zurück geht (Jahreswechsel).
                                -- Ab hier gibts kein CONTINUE mehr. Ergebnis steht fest.
                              _new_lower_bound := number + 1;  -- Damit müssen wir neue untere Grenze (inkl.) für Lückenprüfung festlegen.
                              _first_result_set.result := NULL;
                              _first_result_set.num_add := NULL;  -- Erstes Ergebnis verwerfen. Wir geben kein Ergebnis aus Lückenprüfung aus.
                          END IF;
                      END IF;
                      --
                      EXIT; -- mit Ergebnis raus aus LOOP
                    END IF;
              END LOOP;
              --
              result  := coalesce(_first_result_set.result , result);
              _num_add := coalesce(_first_result_set.num_add, _num_add);

              -- RAISE NOTICE '%,%, %', _new_lower_bound, _num_add, number;
              --
              IF NOT preview THEN -- Wenn kein Preview des Nummernkreises, dann Ergebnis reservieren und Nummerkreis hochzählen
                  INSERT INTO TSystem.numcircles_reserved(ncr_nc_ident, ncr_num, ncr_time) SELECT numident, result, currenttime(); -- Reservierung für aktuellen Nummer anlegen.
                  --
                  IF _num_add < 0 THEN -- Anwenderhinweis auf Lücke. Fall (_num_add = 0): Bei gerade verworfenen Datensätzen nicht ausgeben (aktuelle nc_num = number + 0)
                      PERFORM PRODAT_HINT(langtext(16176) || E'\n' || result); -- Lücke gefunden und gewählt.
                  ELSIF _num_add > 0 THEN  -- keine Lücke, also Nummernkreis aktualisieren
                      UPDATE TSystem.numcircles SET
                             nc_num = number + _num_add,
                             nc_num_lower_bound = COALESCE(_new_lower_bound, _lower_bound)
                      WHERE nc_active
                            AND (   nc_ident = numident
                             OR CASE WHEN numident IN ('aauftg', 'eauftg') AND NOT _e_nicht_aus_a THEN -- Sonderbehandlung Auftragsnummernkreise #9309. Wenn Angebot zu Auftrag aus Angebotsnummer (nicht aus eigener Auftragsnummer).
                                              nc_ident IN ('aauftg', 'eauftg')                                     -- Bei Anlage beide Nummern identisch hochzählen.
                                     ELSE false
                                END
                            );
                  END IF;
              END IF;
              --
              RETURN; -- und raus
           END IF;

      EXCEPTION WHEN OTHERS THEN
          result := 'ERROR';
          PERFORM TSystem.LogError(
            sqlerrm
          );
          RETURN;
      END;

      RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;

--

-- Abbruch der Nummernverwendung. Damit ggf. Zurücksetzen der Nummer und aus Reservierung raus.
CREATE OR REPLACE FUNCTION TSystem.num_unreserve(numident VARCHAR, num VARCHAR) RETURNS BOOLEAN AS $$
  DECLARE current_num   VARCHAR;
          found_remote  BOOLEAN;
  BEGIN
    -- Remote-Nummernkreise #8070
    IF COALESCE(numident = ANY(regexp_split_to_array(TSystem.Settings__Get('numcircles_received_by_dblink'),';')), false) THEN -- Nummernkreis wird per dbLink remote geholt.
        BEGIN
            -- Verbindung aufbauen
            PERFORM dblink_connect('numcircles_remote', TSystem.Settings__Get('numcircles_dblink'));

            -- Nummer auf remote-DB zurücksetzen
            SELECT num_unreserve_ext INTO found_remote -- Alles wird per Funktionsaufruf im Remote-System gemacht, s.u..
            FROM dblink('numcircles_remote', 'SELECT num_unreserve(' || quote_literal(numident) || ', ' || quote_literal(num) || ')') AS t1(num_unreserve_ext BOOLEAN);

            -- Verbindung trennen
            PERFORM dblink_disconnect('numcircles_remote');

            RETURN found_remote; -- und raus
        EXCEPTION WHEN OTHERS THEN
            IF 'numcircles_remote' = ANY(dblink_get_connections()) THEN -- bestehende Verbindung ggf. erst beenden
                PERFORM dblink_disconnect('numcircles_remote');
            END IF;

            RAISE EXCEPTION '%', SQLERRM; -- eigentlichen Fehler werfen
        END;
    END IF;

    -- Sonst: Nummernkreis aus eigener DB zurücksetzen
    EXECUTE 'SELECT ' || COALESCE((SELECT replace(COALESCE(nc_preselect, 'NC_NUM'), 'NC_NUM', nc_num) FROM TSystem.numcircles WHERE nc_ident = numident AND nc_active), '0') INTO current_num; -- aktuelle Nummer

    IF num = current_num THEN -- Wenn die reservierte Nummer gleich der aktuellen Nummernkreis-Nummer ist,
        UPDATE TSystem.numcircles SET
          nc_num = nc_num - 1 -- dann um 1 zurücksetzen.
        WHERE nc_ident = numident
          AND nc_active;
    END IF;

    DELETE FROM TSystem.numcircles_reserved WHERE ncr_nc_ident = numident AND ncr_num = num;

    RETURN FOUND; -- und raus
  END $$ LANGUAGE plpgsql VOLATILE;
--


/*      Bedingte Ausführung von SQL-Statements als Workaround. Gibt False zurück, wenn Bedingung false
        war oder eine (ignorierte) Exception auftrat.
        Bsp: SELECT ConditionalExecute('ldsdok_tmp_exist','DROP TABLE test; DROP TABLE test2;',TRUE);
        Ist das Bool-Setting 'ldsdok_tmp_exist' wahr, werden Tabellen test und test2 gedroppt.          */
CREATE OR REPLACE FUNCTION ConditionalExecute(_boolExpression BOOLEAN, _sqlStatements VARCHAR, _ignoreExceptions BOOLEAN) RETURNS bool AS $$
    BEGIN
      --Ausdruck ist war? Statement ausführen
      If _boolExpression THEN
        IF _ignoreExceptions THEN
          --Ausführen, evtl. Fehler abfangen und ignorieren
          BEGIN
            EXECUTE _sqlStatements;
          EXCEPTION
            WHEN OTHERS THEN
            BEGIN
              RETURN false;
            END;
          END;
          -- Ausführen und fehler werfen
        ELSE
          EXECUTE _sqlStatements;
        END IF;

        RETURN True;
      ELSE
        RETURN False;
      END IF;
    END$$LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION ConditionalExecute(_boolSettingName VARCHAR, _sqlStatements VARCHAR, _ignoreExceptions BOOLEAN) RETURNS bool AS $$
    BEGIN
     RETURN ConditionalExecute(TSystem.Settings__GetBool(_boolSettingName), _sqlStatements,_ignoreExceptions);
    END$$LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION ConditionalExecuteVarChar(_boolExpression BOOLEAN, _sqlStatements VARCHAR, _ignoreExceptions BOOLEAN) RETURNS VARCHAR AS $$
    DECLARE result VARCHAR;
    BEGIN
      --Ausdruck ist war? Statement ausführen
      If _boolExpression THEN
        IF _ignoreExceptions THEN
          --Ausführen, evtl. Fehler abfangen und ignorieren
          BEGIN
            EXECUTE _sqlStatements INTO result;
          EXCEPTION
            WHEN OTHERS THEN
            BEGIN
              RETURN 'ERROR';
            END;
          END;
          -- Ausführen und fehler werfen
        ELSE
          EXECUTE _sqlStatements INTO result;
        END IF;

        RETURN Result;
      ELSE
        RETURN NULL;
      END IF;
    END$$LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION ConditionalExecuteNumeric(_boolExpression BOOLEAN, _sqlStatements VARCHAR, _ignoreExceptions BOOLEAN) RETURNS NUMERIC AS $$
    DECLARE result VARCHAR;
    BEGIN
      --Ausdruck ist war? Statement ausführen
      If _boolExpression THEN
        IF _ignoreExceptions THEN
          --Ausführen, evtl. Fehler abfangen und ignorieren
          BEGIN
            EXECUTE _sqlStatements INTO result;
          EXCEPTION
            WHEN OTHERS THEN
            BEGIN
              RETURN '-1';
            END;
          END;
          -- Ausführen und fehler werfen
        ELSE
          EXECUTE _sqlStatements INTO result;
        END IF;

        RETURN Result;
      ELSE
        RETURN NULL;
      END IF;
    END$$LANGUAGE plpgsql;


--Bankverbindungen ... Eingelesen aus Bankleitzahlen-Datei Dt. Bundesbank
CREATE TABLE bank
 (bk_id         SERIAL PRIMARY KEY,
  bk_blz        VARCHAR(8),
  bk_bez        VARCHAR(60),
  bk_plz        VARCHAR(5),
  bk_ort        VARCHAR(40),
  bk_bic        VARCHAR(11),
  bk_kurzbez    VARCHAR(30),
  bk_gueltig    BOOLEAN NOT NULL DEFAULT TRUE   --Veraltete nicht loeschen, aber markieren
 );

--die darf es nur jeweils einmal geben
CREATE UNIQUE INDEX bank_blz  ON bank  (bk_blz);


--Funktion zur Erstellung von Sequencen da dies in DevArt bugs verursacht.
--Achtung: Sequence gilt bei CREATE als nicht ausgeführt und gibt Startwert zurück. Bei SETVAL gilt sie als ausgeführt und gibt erstes Inkrement zurück.
--
CREATE OR REPLACE FUNCTION CreateSeqWithValue(seqname VARCHAR, startv INTEGER, incv INTEGER, tmp BOOL DEFAULT FALSE) RETURNS VOID AS $$
    BEGIN
     IF tmp THEN
            EXECUTE 'CREATE TEMP SEQUENCE '|| seqname ||' INCREMENT BY '|| incv ||' START WITH '||startv;
     ELSE
            EXECUTE 'CREATE SEQUENCE '|| seqname ||' INCREMENT BY '|| incv ||' START WITH '||startv;
     END IF;
     RETURN;
    END $$ LANGUAGE plpgsql;


------- Benutzerrechte nach der llv (l bde.sql) einfügen --------
------- Benutzerrechte in Z0 role-system.sql
-- Wenn Tabellen beim Prodat-Login noch nicht existieren, dann wird in TDM1.DataBase1AfterConnect "Z0 role-system.sql" geladen und ausgeführt.

-- [SYNCRO-TABLE] DBUpdates
CREATE TABLE dbupdates
 (
  upd_id        varchar(30) NOT NULL DEFAULT currenttime()::VARCHAR PRIMARY KEY,  -- [SYNCRO:SyncID] ID des Updates
  upd_parent    varchar(30),              -- parent (Baumstruktur)
  upd_minver    varchar(11),              -- [SYNCRO:Version] Mindest-Programmversion
  upd_kunde     varchar(20),              -- [SYNCRO:Kunde]
  upd_donedat   timestamp(0),             -- [SYNCRO:NotThisFields] update eingespielt am
  upd_bez       varchar(150) NOT NULL,    -- betreff/bezeichnung
  upd_txt       text,
  upd_sql       text,
  upd_projekt   varchar(100),
  upd_noerr     boolean NOT NULL DEFAULT false,
  upd_sperr     boolean NOT NULL DEFAULT false,
  -- System (tables__generate_missing_fields)
  dbrid         varchar(32) NOT NULL DEFAULT nextval('db_id_seq'),
  insert_date   date,
  insert_by     varchar(32),
  modified_by   varchar(32),
  modified_date timestamp(0)              -- [SYNCRO:Modified]
 );

 CREATE INDEX ON dbupdates USING gist ( dbrid gist_trgm_ops );
 CREATE INDEX ON dbupdates USING gist ( upd_bez gist_trgm_ops );
 CREATE INDEX ON dbupdates USING gist ( upd_id gist_trgm_ops );
 CREATE INDEX ON dbupdates USING gist ( upd_projekt gist_trgm_ops );
 CREATE INDEX ON dbupdates (upd_donedat);

 -- gist index for upd_sql gets to big and fails with
 -- ERROR:  index row requires 8304 bytes, maximum size is 8191
 CREATE INDEX ON dbupdates USING gin  ( upd_sql gin_trgm_ops );

 CREATE INDEX dbupdates__donedat ON dbupdates ( upd_parent );

-- Triggerfunktion fürs automatisches Schließen der DB-Updates nach Version
CREATE OR REPLACE FUNCTION dbupdates__b_i() RETURNS TRIGGER AS $$
  BEGIN
    IF EXISTS(SELECT true FROM settings WHERE s_vari = 'DBU_date_for_auto_done') THEN
        IF new.upd_id::DATE <= TSystem.Settings__Get('DBU_date_for_auto_done')::DATE THEN
            new.upd_donedat := '2000-01-01';
            new.upd_txt := E'[DBU-AUTO-DONE]\n' || COALESCE(new.upd_txt, '');
        END IF;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER dbupdates__b_i BEFORE INSERT ON dbupdates FOR EACH ROW EXECUTE PROCEDURE dbupdates__b_i();


  CREATE OR REPLACE FUNCTION dbupdates__filtered__nodes__upd_ids__get() RETURNS SETOF VARCHAR AS $$
      WITH _nodes AS (
            SELECT upd_id FROM dbupdates
             WHERE upd_donedat >= current_timestamp - '90 days'::INTERVAL
                OR upd_donedat IS NULL
                OR coalesce(modified_date, insert_date::TIMESTAMP) >= current_timestamp - '90 days'::INTERVAL
                OR upd_sperr
           ),
           _parents AS (
            WITH RECURSIVE _tree AS (
                  SELECT a.upd_id, a.upd_parent, a.upd_bez, a.upd_donedat, a.modified_date, a.insert_date, a.upd_sperr, 0 AS depth FROM dbupdates a WHERE upd_id IN (SELECT upd_id FROM _nodes)
                  UNION
                  SELECT a.upd_id, a.upd_parent, a.upd_bez, a.upd_donedat, a.modified_date, a.insert_date, a.upd_sperr, depth - 1 FROM dbupdates a JOIN _tree p ON a.upd_id = p.upd_parent
            )
            SELECT upd_id FROM _tree
             WHERE depth < 0
             ORDER BY depth
           )
           SELECT * FROM _nodes
           UNION
           SELECT * FROM _parents
  $$ LANGUAGE SQL;

-- Funktion ermittelt zu einem DBU alle Funktionen die durch das DBU erstellet/geändert werden
CREATE OR REPLACE FUNCTION TSystem.dbu__created_functions__get(
    sql_text varchar
  )
  RETURNS varchar[]
  AS $$
    -- Extrahiere die Funktionsnamen aus dem Statement
    SELECT array_agg( matches[1] )
      FROM (
            SELECT regexp_matches(
                     sql_text,
                     E'CREATE(?:\\s+OR\\s+REPLACE)?\\s+FUNCTION\\s+((?:[a-zA-Z_][a-zA-Z0-9_]*\\.)?[a-zA-Z_][a-zA-Z0-9_]*)',
                     'gi'
                   ) AS matches
           ) AS sub
  $$ LANGUAGE sql IMMUTABLE STRICT;

-- Funktion ermittelt zu einem DBU mit welchem anderen DBU die betroffenen Funktionen letztmalig erstellt/geändert wurden
CREATE OR REPLACE FUNCTION TSystem.dbu__created_functions_history__get(
    _upd_id varchar
  )
  RETURNS TABLE (
    functions            varchar,
    upd_minver_own       varchar,
    upd_minver_dbupdates varchar,
    upd_id               varchar,
    upd_sql              text
  ) AS $$

  WITH dbus AS (
    SELECT functions,
           own_dbu.upd_minver   AS upd_minver_own,
           dbupdates.upd_minver AS upd_minver_dbupdates,
           dbupdates.upd_id,
           dbupdates.upd_sql,
           ROW_NUMBER() OVER ( PARTITION BY functions ORDER BY dbupdates.upd_minver DESC ) AS row_number
      FROM dbupdates AS own_dbu
      JOIN UNNEST( TSystem.dbu__created_functions__get( own_dbu.upd_sql ) ) AS functions ON TRUE
      LEFT JOIN dbupdates ON functions = ANY( TSystem.dbu__created_functions__get( dbupdates.upd_sql ) )
                         AND dbupdates.upd_id <> own_dbu.upd_id
     WHERE own_dbu.upd_id = _upd_id
  )
  SELECT functions,
         upd_minver_own,
         upd_minver_dbupdates,
         upd_id,
         upd_sql
    FROM dbus
   WHERE row_number = 1;

  $$ LANGUAGE sql STABLE STRICT;

-- Standard Termin Tabelle
CREATE TABLE sysdat(
  dat_id                SERIAL PRIMARY KEY,
  dat_altdat_for_dat_id INTEGER,      --ich bin eine Alternative für den Termin ...
  dat_tablename         VARCHAR(30),  -- table Ursprungsdatensatz
  dat_pkey              VARCHAR(100), -- Eintrag Ursprungsdatensatz
  dat_type_id           VARCHAR(20),  -- Termintyp, Enum (Schulung, Email, Wiedervorlage) enthält ID
  dat_subject           VARCHAR(100), --Gegenstand
  dat_begin             TIMESTAMP,    -- Zeitraum von
  dat_end               TIMESTAMP,    -- Zeitraum bis
  dat_location          VARCHAR(100), -- Ort, Wo findet der Termin statt
  dat_status_id         VARCHAR(20)   -- Status, Enum (ungeplant, in Planung, laufend, abgeschlossen) enthält ID
 );

-- Standard Tabelle für Teilnehmer
CREATE TABLE llv_members(
  llm_id SERIAL PRIMARY KEY,
  llm_parent_dbrid VARCHAR(100), -- ID Ursprungsdatensatz
  llm_tablename VARCHAR(30), -- table Ursprungsdatensatz: Wiederverwendung Teilnehmerliste auch für andere Stellen im System
  llm_minr INTEGER NOT NULL, --X TABLECONSTRAINTS: REFERENCES llv ON UPDATE CASCADE ON DELETE CASCADE, -- Mitarbeiternummer
  llm_role_id VARCHAR(20), -- Teilnehmerrolle Enum (Benötigter Teilnehmer, Optionaler Teilnehmer, Leiter, Organisator)
  llm_status_id VARCHAR(20) -- Teilnehmerstatus Enum (Zugesagt, Abgelehnt)
 );

 -- Legt beim Insert die Default-Parameter für Schulungsplanung-Teilnehmer an
 CREATE TRIGGER llv_members__a_i__create_autoparams
  AFTER INSERT
  ON llv_members
  FOR EACH ROW
  EXECUTE PROCEDURE TRecnoParam.CreateAutoParams();

 CREATE OR REPLACE FUNCTION sysdat__a_d() RETURNS trigger AS $$
 BEGIN
    DELETE FROM llv_members WHERE llm_parent_dbrid = old.dbrid;
    RETURN null;
 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER sysdat__a_d
  AFTER DELETE
   ON sysdat
  FOR EACH ROW
  EXECUTE PROCEDURE sysdat__a_d();
--


/* ------------------------ NACHGESETZTE TECHPLAN FUNKTIONALITÄT ----------------------------

* Die Funktionen erlauben es DB-Funktionen zu erstellen, in der Tabelle DBFunction zu registrieren und nach Änderungen zu updaten.
Angedacht war, als wir Techplan angefangen haben, die Struktur auch für kundenspezifische Funktionen und ähnliches zu nutzen und die
per Synchronisation verwaltbar zu machen. Daher stammen die generischen Namen "DBFunction" und die wurden nicht "TechplanFunctions" benannt.
Da Richardt für das CI-System ähnliche Strukturen erstellt hat, die wahrscheinich mittlerweile weiter sind, wäre zu überlegen die
generischen Namen hier gegen Techplan-irgendwas auszutauschen oder beides, wenn das CI-System in die Richtung weiterentwickelt wird,
später mal zusammenzuführen. */



CREATE OR REPLACE FUNCTION TSystem.DBFunction_GetHashes(
  IN functionOID        INTEGER,
  OUT fSchema           VARCHAR,
  OUT fName             VARCHAR,
  OUT signature_hash    TEXT,
  OUT function_hash     TEXT
  ) RETURNS RECORD AS $$
 BEGIN

   IF TSystem.postgresqlVersion() < 110 THEN
     SELECT n.nspname,                                           -- Schema
            p.proname,                                           -- Name
            md5( COALESCE( (n.nspname||'.'||p.proname ),'')      -- HASH über Signature mittels Schema + Name
              || COALESCE( pg_get_function_arguments(p.oid),'')  -- ... dann Name + Typ aller Ein- / Ausgabeparameter der Funktion
              || COALESCE( pg_get_function_result(p.oid),'')     -- ... und Typ des Funktionsergebnis
            ) AS signature_hash,
           md5( pg_get_functiondef(p.oid)) AS function_hash      -- HASH über den gesamten Text der Funktion, wie von PGAdmin ausgelesen
     INTO fSchema, fName, signature_hash, function_hash
     FROM pg_catalog.pg_proc p LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace
     WHERE p.oid = functionOID
       AND n.nspname <> 'pg_catalog'
       AND n.nspname <> 'information_schema'
       AND NOT p.proisagg;
   ELSE
     SELECT n.nspname,                                           -- Schema
            p.proname,                                           -- Name
            md5( COALESCE( (n.nspname||'.'||p.proname ),'')      -- HASH über Signature mittels Schema + Name
              || COALESCE( pg_get_function_arguments(p.oid),'')  -- ... dann Name + Typ aller Ein- / Ausgabeparameter der Funktion
              || COALESCE( pg_get_function_result(p.oid),'')     -- ... und Typ des Funktionsergebnis
            ) AS signature_hash,
           md5( pg_get_functiondef(p.oid)) AS function_hash      -- HASH über den gesamten Text der Funktion, wie von PGAdmin ausgelesen
     INTO fSchema, fName, signature_hash, function_hash
     FROM pg_catalog.pg_proc p LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace
     WHERE p.oid = functionOID
       AND n.nspname <> 'pg_catalog'
       AND n.nspname <> 'information_schema'
       AND p.prokind <> 'a';
   END IF;
   RETURN;
 END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION TSystem.DBFunction_Register(
  IN FuncSchema         VARCHAR,
  IN FuncName           VARCHAR,
  IN function_script TEXT, IN testMode BOOLEAN DEFAULT TRUE,
  OUT fOID              INTEGER,
  OUT fSchema           VARCHAR,
  OUT fName             VARCHAR,
  OUT signature_hash    TEXT,
  OUT function_hash     TEXT
  ) RETURNS RECORD AS $$
 DECLARE errorMsg TEXT;
 BEGIN

   BEGIN
     -- Ausführen und versuchen die Funktion einfach so mal einspielen.
     EXECUTE function_script;

     -- OID der letzten angelegten Funktion laden

     IF TSystem.postgresqlVersion() < 110 THEN
       fOID := MAX(p.oid)
         FROM pg_catalog.pg_proc p LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace
         WHERE n.nspname <> 'pg_catalog' AND n.nspname ILIKE FuncSchema AND p.proname ILIKE FuncName AND NOT p.proisagg;
     ELSE
       fOID := MAX(p.oid)
         FROM pg_catalog.pg_proc p LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace
         WHERE n.nspname <> 'pg_catalog' AND n.nspname ILIKE FuncSchema AND p.proname ILIKE FuncName AND p.prokind <> 'a';
     END IF;

     SELECT * INTO fSchema, fName, signature_hash, function_hash FROM TSystem.DBFunction_GetHashes(fOID);

     -- RAISE WARNING 'Function OID: %', function_hash;

     -- Wenn wir nur Testen bzw. die HASH-Werte brauchen, eine Exception werfen.
     IF testMode THEN
       RAISE EXCEPTION USING errcode = 'TESTE', message='TSystem.DBFunction_Register -> Rollback aller Änderungen per Exception.';
     END IF;

   EXCEPTION
     WHEN sqlstate 'TESTE' THEN BEGIN
       RAISE WARNING '%', SQLERRM;  -- GET STACKED DIAGNOSTICS errorMsg = PG_EXCEPTION_CONTEXT;
     END;
   END;

 END $$ LANGUAGE plpgsql VOLATILE;
--

/* Beispiele für unterscheidbare Funktionen
       SELECT 1, (TSystem.DBFunction_Register( 'CREATE OR REPLACE FUNCTION x_800_enplan.Test(IN n NUMERIC(12,4)) RETURNS VARCHAR AS $$ BEGIN RETURN ''_I ist '' || i::INTEGER; END $$  LANGUAGE plpgsql;')).*
 UNION SELECT 2, (TSystem.DBFunction_Register( 'CREATE OR REPLACE FUNCTION x_800_enplan.Test(IN n NUMERIC(8,4) ) RETURNS VARCHAR AS $$ BEGIN RETURN ''I ist '' || i::INTEGER; END $$  LANGUAGE plpgsql;')).*
 UNION SELECT 3, (TSystem.DBFunction_Register( 'CREATE OR REPLACE FUNCTION x_800_enplan.Test(IN i INTEGER      ) RETURNS VARCHAR AS $$ BEGIN RETURN ''I ist '' || i::INTEGER; END $$  LANGUAGE plpgsql;')).*
 UNION SELECT 4, (TSystem.DBFunction_Register( 'CREATE OR REPLACE FUNCTION x_800_enplan.Test(IN i INTEGER      ) RETURNS VARCHAR AS $$  BEGIN RETURN ''I ist '' || i::INTEGER; END $$  LANGUAGE plpgsql;')).*
 UNION SELECT 5, (TSystem.DBFunction_Register( 'CREATE OR REPLACE FUNCTION x_800_enplan.Test(IN i      INTEGER ) RETURNS VARCHAR AS $$ BEGIN RETURN '' I ist '' || i::INTEGER; END $$  LANGUAGE plpgsql;')).*
 ORDER BY 1


 -- HINWEIS: Signatur von 1 u. 2 unterschiedlich => NUMERIC(12,4) bzw. NUMERIC(8,4)  Postgres scheint das aber in pg_get_function_arguments(oid) nicht zu unterscheiden

 -- 1;1916929;"x_800_enplan";"test";"1da31aa77943ba32f7d5211bc8b61aa1";"57101dc865941c30cbadfd520d897d91"
 -- 2;1916934;"x_800_enplan";"test";"1da31aa77943ba32f7d5211bc8b61aa1";"57101dc865941c30cbadfd520d897d91"
 -- 3;1916939;"x_800_enplan";"test";"7799fab1243820be9af8bc25efa8304f";"1d1e70ea7a513d4d5885f11954ffaf0d"
 -- 4;1916944;"x_800_enplan";"test";"7799fab1243820be9af8bc25efa8304f";"3386eb8cfcf0086416f8f9c6c639d784"
 -- 5;1916949;"x_800_enplan";"test";"7799fab1243820be9af8bc25efa8304f";"656938e22e1771f5ae19f56d6d2317b1"
*/

-- Tabelle zur Ablage von Funktionsdefinitionen und ergänzenden Daten
CREATE TABLE IF NOT EXISTS DBFunction (
  dbf_id               SERIAL PRIMARY KEY,             -- Key
  --
  dbf_oid              INTEGER,                        -- Object-Id der Funktion im PG-Catalog
  dbf_schema           VARCHAR(100) NOT NULL,          -- DB-Schema der Funktion
  dbf_name             VARCHAR(100) NOT NULL,          -- Name der Funktion
  dbf_signature_hash   TEXT,                           -- Hash über Schema + Name + Ein-/Ausgabeparameter
  dbf_function_hash    TEXT,                           -- Hash über die gesamte Funktion, wie von Postgres
  --
  dbf_group            VARCHAR(100),                   -- Zuordnung zu einer bestimmten Gruppe (z.Bsp. Techplan)
  dbf_descr            TEXT,                           -- Beschreibung
  dbf_revision         INTEGER NOT NULL DEFAULT 1,     -- Revision / Version der Funktion
  dbf_user_script      TEXT,                           -- Script wie der Nutzer es eingegeben hat. Kann noch Macros und Platzhalter enthalten.
  dbf_script           TEXT,                           -- Der Funktionstext, wie z.Bsp. aus Psql-Script, so wird die Funktion in Postgres angelegt (das ist das was im Erzeugungsscript stehen würde)
  dbf_readonly         BOOLEAN NOT NULL DEFAULT FALSE  --
 );
--

-- ACHTUNG: Schreibt im Postgres-Katalog rum und tauscht wirklich Funktionen aus (Einspielen oder Updaten)
CREATE OR REPLACE FUNCTION DBFunction__b_iu_sync_pg() RETURNS TRIGGER AS $$
 DECLARE oldFunction RECORD;  -- Record-Struktur = fOID, fSchema, fName, signature_hash, function_hash
         newFunction RECORD;
 BEGIN
   --

    PERFORM TSystem.LogWarning(
                TSystem.LogFormat(                    -- Message
                    'Funktion wird verarbeitet und im Postgres registriert.'
                  , false     -- Zeilenumbruch
                  , 'Funktion', new.dbf_name
                  , 'Schema', new.dbf_schema
                )
            )
    ;

    -- So tun als würden wir die einspielen, hash berechnen, TRUE = Testflag - löst Exception aus und rollt Änderungen zurück
    SELECT * INTO newFunction FROM TSystem.DBFunction_Register(new.dbf_schema, new.dbf_name, new.dbf_script, TRUE);
    IF (TG_OP = 'UPDATE') THEN
      SELECT * INTO oldFunction FROM TSystem.DBFunction_Register(old.dbf_schema, old.dbf_name, old.dbf_script, TRUE);
    ELSE
      oldFunction := newFunction; -- Neu angelegt: Dann setzen wir Alt = Neu zum Hash-Werte vergleichen
    END IF;



    -- Irgendwas an dem SQL-Script der Funktion hat sich geändert.
    IF (TG_OP = 'INSERT') OR (newFunction.function_hash IS DISTINCT FROM oldFunction.function_hash) THEN



    -- Dieses Mal wird die Funktion richtig eingespielt.
      SELECT * INTO newFunction FROM TSystem.DBFunction_Register(new.dbf_schema, new.dbf_name, new.dbf_script, FALSE); -- False = Kein Testmodus.
      new.dbf_oid            := newFunction.fOID;
      new.dbf_schema         := COALESCE(new.dbf_schema, newFunction.fSchema);  -- Nur setzen, wenn das leer war (Problem Gross/Kleinschreibung im PgCatalog)
      new.dbf_name           := COALESCE(new.dbf_name, newFunction.fName);      -- Nur setzen, wenn das leer war (Problem Gross/Kleinschreibung im PgCatalog)
      new.dbf_signature_hash := newFunction.signature_hash;
      new.dbf_function_hash  := newFunction.function_hash;



      IF (TG_OP = 'UPDATE') THEN

        IF newFunction.signature_hash IS DISTINCT FROM oldFunction.signature_hash THEN
          /* PERFORM PRODAT_MESSAGE('TSystem.DBFunction__b_iu_sync_pg: Update einer bestehenden Funktion. '
                              || E'\  Die Signatur (Name o. Parameter o. Rückgabe) hat sich geändert. '
                              || E'\  Alte Funktion muss gegebenenfalls manuell gedroppt werden.  '
                              , 'Error', Current_user);    */
        END IF;
        new.dbf_revision := old.dbf_revision + 1;
        PERFORM TSystem.LogWarning(
                    TSystem.LogFormat(                    -- Message
                        'Neue Funktion wurde angelegt.'
                      , false     -- Zeilenumbruch
                      , 'Funktion', new.dbf_name
                      , 'Schema', new.dbf_schema
                    )
                )
        ;
      ELSE
        PERFORM TSystem.LogWarning(
                    TSystem.LogFormat(                    -- Message
                        'Funktion wurde geupdated.'
                      , false     -- Zeilenumbruch
                      , 'Funktion', new.dbf_name
                      , 'Schema', new.dbf_schema
                    )
                )
        ;
      END IF;
    END IF;

    RETURN new;
 END $$ LANGUAGE plpgsql;
--

--
DROP TRIGGER IF EXISTS DBFunction__b_iu_sync_pg ON DBFunction;
CREATE TRIGGER DBFunction__b_iu_sync_pg
  BEFORE INSERT OR UPDATE
  ON DBFunction
  FOR EACH ROW
 EXECUTE PROCEDURE DBFunction__b_iu_sync_pg();
--

--
CREATE TABLE DBFunctionVars (
  dbv_id               SERIAL PRIMARY KEY,
  dbv_dbf_id           INTEGER NOT NULL REFERENCES DBFunction ON UPDATE CASCADE ON DELETE CASCADE,
  dbv_typ              VARCHAR(3) DEFAULT 'V',  -- V = Freie Variable, TPF = Techplan-Parameter (Feld-Typ), TPE = Techplan-Parameter (EAV-Typ)
  dbv_varname          VARCHAR(40),
  dbv_p_category       VARCHAR(40),
  dbv_p_name           VARCHAR(40),
  dbv_default_value    NUMERIC DEFAULT 0
 );
--


/* ------------------------ ENDE TECHPLAN FUNKTIONALITÄT ----------------------------*/

-- Gibt Feldinhalt _field aus der Tabelle _table per _dbrid zurück.
CREATE OR REPLACE FUNCTION TSystem.field_from_table_by_dbrid(
      _dbrid    varchar,
      _field    varchar,
      _table    varchar,
      _schema   varchar = NULL
  ) RETURNS varchar AS $$
  DECLARE
      _value varchar;
      _query text;
  BEGIN
      IF   _dbrid IS NULL
          OR _field IS NULL
          OR _table IS NULL
      THEN
          RETURN NULL;
      END IF;

      _query :=
          $inlineSql$
              SELECT %I
              FROM %I.%I
              WHERE dbrid = %L
          $inlineSql$
      ;

      EXECUTE format( _query, _field, COALESCE(_schema, 'public'), _table, _dbrid )
         INTO _value
      ;

      RETURN _value;
  END $$ LANGUAGE plpgsql STABLE;
--


-- findet den bevorzugten Dokumententyp anhand des Verzeichnisses, indem es abgelegt ist
-- bei der Auswahl werden die Typen mit gesetztem dt_parentnodeid__main-Flag bevorzugt
-- danach der erste Typ in alphabetischer Reihnenfolge
-- Paramter _parentnode_id id des zugeordneten Verzeichnisses
CREATE OR REPLACE FUNCTION tsystem.dokutypes__find__by__parentnode_id( _parentnode_id varchar )
  RETURNS varchar
  AS $$
     SELECT dt_id
       FROM dokutypes
     WHERE dt_parentnodeid = _parentnode_id
     ORDER BY
       dt_parentnodeid_default DESC,
       dt_parentnodeid         ASC
     LIMIT 1;
  $$ LANGUAGE sql;
--


-- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT True;
--

-- #17854 Tabelle für das Abspeichern von Farb- und Fontstyleeigenschaften
CREATE TABLE tsystem.cim_font_colors (
  cfc_id serial PRIMARY KEY,                           -- technischer Primärschlüssel
  cfc_kontext varchar(40) NOT null,                    -- Farbkontext (z.B. Plantafel)
  cfc_index integer NOT null,                          -- Index der Farbe

  -- Farbeigenschaften
  cfc_color_argb integer,                              -- Farbe im ARGB-Format (32 Bit)
  cfc_color_bez varchar(60),                           -- Bezeichnung der Farbe (z.B. türkis)

  -- Fontstyleeigenschaften
  ---- null  = Eigenschaft bleibt unverändert
  ---- false = Eigenschaft wird gelöscht (z.B. Schrift wird nicht unterstrichen)
  ---- true  = Eigenschaft wird gesetzt  (z.B. Schrift wird kursiv)
  cfc_font_bold boolean,                               -- dick
  cfc_font_italic boolean,                             -- kursiv
  cfc_font_underline boolean,                          -- unterstrichen
  cfc_font_strikeout boolean                           -- durchgestrichen
);

-- Jeder Index darf in einem Kontext nur einmal vorkommen.
CREATE UNIQUE INDEX cim_font_colors__cfc_index__cfc_kontext ON tsystem.cim_font_colors( cfc_kontext, cfc_index );
--

-- Gibt Fonteigenschaften zu einem Kontext und einem Index zurück;
---- (z.B. Kontext Plantafel, Index 1)
---- Bedeutung der Parameter siehe Tabelle cim_font_colors
CREATE OR REPLACE FUNCTION tsystem.cim_font_colors__get(
  IN _cfc_kontext varchar,
  IN _cfc_index integer,
  OUT cfc_color_argb integer,
  OUT cfc_color_bez varchar,
  OUT cfc_font_bold boolean,
  OUT cfc_font_italic boolean,
  OUT cfc_font_underline boolean,
  OUT cfc_font_strikeout boolean
) RETURNS record AS $$

  SELECT
    cfc_color_argb,
    cfc_color_bez,
    cfc_font_bold,
    cfc_font_italic,
    cfc_font_underline,
    cfc_font_strikeout
  FROM tsystem.cim_font_colors
  WHERE
        cfc_index   = _cfc_index
    AND cfc_kontext = _cfc_kontext;

$$ LANGUAGE sql STABLE;
--

-- #22021 Funktion zum Sichern einer Tabelle in2 z_99_drop-Schema
-- Name der neue erstellten Tabelle: z_99_drop.<Tabellenname ohne Schema>_bkp_<Datum>
CREATE OR REPLACE FUNCTION tsystem.table__backup__create( _tablename varchar, _schemaname varchar = 'public' ) RETURNS boolean AS $$
DECLARE
  _sql varchar;
  _date varchar;
BEGIN

  -- Tabelle gibt es im Schema nicht? Dann False zurückgeben.
  IF NOT EXISTS ( SELECT 1 FROM information_schema.tables where table_name =  _tablename AND table_schema = _schemaname ) THEN
    RETURN false;
  END IF;

  -- Tabelle im Drop sichern
  _date := replace( current_date::varchar, '-', '' );
  _sql := format(' CREATE TABLE %I.%I AS ( SELECT * FROM %I.%I )', 'z_99_drop', _tablename || '_bkp_' || _date, _schemaname, _tablename );
  EXECUTE _sql;

  RETURN true;

END $$ LANGUAGE plpgsql STRICT;
--
